/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.core.spi.multiview.text.MultiViewEditorElement;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.InstantRenamer;
import org.netbeans.modules.csl.api.KeystrokeHandler;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.spi.DefaultLanguageConfig;
import org.netbeans.modules.languages.yaml.YamlCompletion;
import org.netbeans.modules.languages.yaml.YamlKeystrokeHandler;
import org.netbeans.modules.languages.yaml.YamlLexer;
import org.netbeans.modules.languages.yaml.YamlParser;
import org.netbeans.modules.languages.yaml.YamlScanner;
import org.netbeans.modules.languages.yaml.YamlSemanticAnalyzer;
import org.netbeans.modules.languages.yaml.YamlTokenId;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.LanguageProvider;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.openide.util.Lookup;

public class YamlLanguage
extends DefaultLanguageConfig {
    private static final Language<YamlTokenId> language = new LanguageHierarchy<YamlTokenId>(){

        protected String mimeType() {
            return YamlLanguage.MIME_TYPE;
        }

        protected Collection<YamlTokenId> createTokenIds() {
            return EnumSet.allOf(YamlTokenId.class);
        }

        protected Lexer<YamlTokenId> createLexer(LexerRestartInfo<YamlTokenId> info) {
            return new YamlLexer(info);
        }

        protected LanguageEmbedding<? extends TokenId> embedding(Token<YamlTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
            switch ((YamlTokenId)token.id()) {
                case RUBY_EXPR: 
                case RUBY: {
                    return YamlLanguage.findLanguage(YamlLanguage.RUBY_MIME_TYPE);
                }
                case PHP: {
                    return YamlLanguage.findLanguage(YamlLanguage.PHP_MIME_TYPE);
                }
            }
            return null;
        }
    }.language();
    public static final String MIME_TYPE = "text/x-yaml";
    public static final String RUBY_MIME_TYPE = "text/x-ruby";
    public static final String PHP_MIME_TYPE = "text/x-php5";

    public Language getLexerLanguage() {
        return YamlLanguage.language();
    }

    public String getDisplayName() {
        return "YAML";
    }

    public String getLineCommentPrefix() {
        return "#";
    }

    public Parser getParser() {
        return new YamlParser();
    }

    public boolean hasStructureScanner() {
        return true;
    }

    public StructureScanner getStructureScanner() {
        return new YamlScanner();
    }

    public SemanticAnalyzer getSemanticAnalyzer() {
        return new YamlSemanticAnalyzer();
    }

    public KeystrokeHandler getKeystrokeHandler() {
        return new YamlKeystrokeHandler();
    }

    public CodeCompletionHandler getCompletionHandler() {
        return new YamlCompletion();
    }

    public InstantRenamer getInstantRenamer() {
        return null;
    }

    public static final Language<YamlTokenId> language() {
        return language;
    }

    private static LanguageEmbedding<? extends TokenId> findLanguage(String mimeType) {
        LanguageProvider provider;
        Language ret = null;
        Collection providers = Lookup.getDefault().lookupAll(LanguageProvider.class);
        Iterator iterator = providers.iterator();
        while (iterator.hasNext() && (ret = (provider = (LanguageProvider)iterator.next()).findLanguage(mimeType)) == null) {
        }
        return ret != null ? LanguageEmbedding.create(ret, (int)0, (int)0, (boolean)false) : null;
    }

    public static MultiViewEditorElement createMultiViewEditorElement(Lookup context) {
        return new MultiViewEditorElement(context);
    }
}

