/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor.caret;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.editor.caret.EditorCaret;
import org.netbeans.api.editor.caret.MoveCaretsOrigin;
import org.openide.util.Parameters;

public abstract class CascadingNavigationFilter
extends NavigationFilter {
    private NavigationFilter previous;
    private JTextComponent owner;
    private MoveCaretsOrigin regKey;

    protected final NavigationFilter getNextFilter() {
        return this.previous;
    }

    @Override
    public int getNextVisualPositionFrom(JTextComponent text, int pos, Position.Bias bias, int direction, Position.Bias[] biasRet) throws BadLocationException {
        return this.previous != null ? this.previous.getNextVisualPositionFrom(text, pos, bias, direction, biasRet) : super.getNextVisualPositionFrom(text, pos, bias, direction, biasRet);
    }

    @Override
    public void moveDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
        if (this.previous != null) {
            this.previous.moveDot(fb, dot, bias);
        } else {
            super.moveDot(fb, dot, bias);
        }
    }

    @Override
    public void setDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
        if (this.previous != null) {
            this.previous.setDot(fb, dot, bias);
        } else {
            super.setDot(fb, dot, bias);
        }
    }

    public final void unregister() {
        if (this.regKey == null) {
            return;
        }
        NavigationFilter f = EditorCaret.getNavigationFilter(this.owner, this.regKey);
        CascadingNavigationFilter next = null;
        while (f instanceof CascadingNavigationFilter && f != this) {
            next = (CascadingNavigationFilter)f;
            f = next.getNextFilter();
        }
        if (f != this) {
            return;
        }
        if (next == null) {
            EditorCaret.setNavigationFilter(this.owner, this.regKey, this.previous);
        } else {
            next.previous = this.previous;
        }
        this.owner = null;
        this.previous = null;
    }

    public final void register(@NonNull JTextComponent component, @NonNull MoveCaretsOrigin origin) {
        Parameters.notNull((CharSequence)"caret", (Object)component);
        Parameters.notNull((CharSequence)"origin", (Object)origin);
        if (this.owner != null) {
            throw new IllegalStateException();
        }
        EditorCaret.setNavigationFilter(component, origin, this);
    }

    public void setOwnerAndPrevious(JTextComponent component, MoveCaretsOrigin orig, NavigationFilter prev) {
        if (this.owner != null) {
            throw new IllegalStateException("Can be registered only once");
        }
        this.owner = component;
        this.previous = prev;
        this.regKey = orig;
    }
}

