/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.classpath.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

final class ProjectClassPathImplementation
implements ClassPathImplementation,
PropertyChangeListener,
Runnable {
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final File projectFolder;
    private List<PathResourceImplementation> resources;
    private final PropertyEvaluator evaluator;
    private final AtomicBoolean dirty = new AtomicBoolean();
    private final List<String> propertyNames;

    public ProjectClassPathImplementation(File projectFolder, String[] propertyNames, PropertyEvaluator evaluator) {
        assert (projectFolder != null && propertyNames != null && evaluator != null);
        this.projectFolder = projectFolder;
        this.evaluator = evaluator;
        this.propertyNames = Arrays.asList(propertyNames);
        this.resources = this.getPath();
        evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)evaluator));
    }

    public synchronized List<PathResourceImplementation> getResources() {
        assert (this.resources != null);
        return this.resources;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop != null && !this.propertyNames.contains(evt.getPropertyName())) {
            return;
        }
        if (!this.dirty.getAndSet(true)) {
            ProjectManager.mutex().postReadRequest((Runnable)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.dirty.set(false);
        List<PathResourceImplementation> newRoots = this.getPath();
        boolean fire = false;
        ProjectClassPathImplementation projectClassPathImplementation = this;
        synchronized (projectClassPathImplementation) {
            if (!this.resources.equals(newRoots)) {
                this.resources = newRoots;
                fire = true;
            }
        }
        if (fire) {
            this.support.firePropertyChange("resources", null, null);
        }
    }

    private List<PathResourceImplementation> getPath() {
        ArrayList<PathResourceImplementation> result = new ArrayList<PathResourceImplementation>();
        for (String p : this.propertyNames) {
            String prop = this.evaluator.getProperty(p);
            if (prop == null) continue;
            for (String piece : PropertyUtils.tokenizePath((String)prop)) {
                File f = PropertyUtils.resolveFile((File)this.projectFolder, (String)piece);
                URL entry = FileUtil.urlForArchiveOrDir((File)f);
                if (entry != null) {
                    result.add(ClassPathSupport.createResource((URL)entry));
                    continue;
                }
                Logger.getLogger(ProjectClassPathImplementation.class.getName()).log(Level.WARNING, "{0} does not look like a valid archive file", f);
            }
        }
        return Collections.unmodifiableList(result);
    }
}

