/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.environment.PhpEnvironment;
import org.netbeans.modules.php.project.ui.CopyFilesVisual;
import org.netbeans.modules.php.project.ui.LocalServer;
import org.netbeans.modules.php.project.ui.LocalServerController;
import org.netbeans.modules.php.project.ui.SourcesFolderProvider;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.customizer.Bundle;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class CustomizerSources
extends JPanel
implements SourcesFolderProvider,
HelpCtx.Provider {
    private static final long serialVersionUID = -5884875643137545L;
    private static final String DEFAULT_WEB_ROOT = NbBundle.getMessage(CustomizerSources.class, (String)"LBL_DefaultWebRoot");
    private final CopyFilesVisual copyFilesVisual;
    private final boolean originalCopySrcFiles;
    private final String originalCopySrcTarget;
    final ProjectCustomizer.Category category;
    final PhpProjectProperties properties;
    String originalEncoding;
    boolean notified;
    boolean visible;
    private JCheckBox aspTagsCheckBox;
    private JPanel copyFilesPanel;
    private JComboBox<Charset> encodingComboBox;
    private JLabel encodingLabel;
    private JComboBox<PhpVersion> phpVersionComboBox;
    private JLabel phpVersionInfoLabel;
    private JLabel phpVersionLabel;
    private JLabel projectFolderLabel;
    private JTextField projectFolderTextField;
    private JCheckBox shortTagsCheckBox;
    private JButton sourceFolderButton;
    private JLabel sourceFolderLabel;
    private JTextField sourceFolderTextField;
    private JButton webRootButton;
    private JLabel webRootLabel;
    private JTextField webRootTextField;

    public CustomizerSources(ProjectCustomizer.Category category, final PhpProjectProperties properties) {
        this.initComponents();
        this.category = category;
        this.properties = properties;
        this.initEncoding();
        this.initProjectAndSources();
        this.webRootTextField.setText(this.getWebRoot());
        this.originalCopySrcFiles = this.initCopyFiles();
        this.initPhpVersion();
        this.initTags();
        final LocalServer copyTarget = this.initCopyTarget();
        this.originalCopySrcTarget = copyTarget.getSrcRoot();
        this.copyFilesVisual = new CopyFilesVisual(this, LocalServer.PENDING_LOCAL_SERVER);
        this.copyFilesVisual.setCopyFiles(this.originalCopySrcFiles);
        this.copyFilesVisual.setCopyOnOpen(properties.getCopySrcOnOpen());
        this.copyFilesVisual.setState(false);
        this.copyFilesPanel.add("Center", this.copyFilesVisual);
        PhpEnvironment.get().readDocumentRoots(new PhpEnvironment.ReadDocumentRootsNotifier(){

            @Override
            public void finished(final List<PhpEnvironment.DocumentRoot> documentRoots) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CustomizerSources.this.initCopyTargets(documentRoots, copyTarget);
                    }
                });
            }
        }, this.getSourcesFolderName());
        this.encodingComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Charset enc = (Charset)CustomizerSources.this.encodingComboBox.getSelectedItem();
                String encName = enc != null ? enc.name() : CustomizerSources.this.originalEncoding;
                if (!CustomizerSources.this.notified && encName != null && !encName.equals(CustomizerSources.this.originalEncoding)) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerSources.class, (String)"MSG_EncodingWarning"), 2));
                    CustomizerSources.this.notified = true;
                }
                properties.setEncoding(encName);
            }
        });
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        DefaultChangeListener defaultChangeListener = new DefaultChangeListener();
        this.copyFilesVisual.addChangeListener(defaultChangeListener);
        this.sourceFolderTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.webRootTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.phpVersionComboBox.addItemListener(new DefaultComboBoxItemListener());
        DefaultCheckBoxItemListener defaultCheckBoxItemListener = new DefaultCheckBoxItemListener();
        this.shortTagsCheckBox.addItemListener(defaultCheckBoxItemListener);
        this.aspTagsCheckBox.addItemListener(defaultCheckBoxItemListener);
    }

    @Override
    public void addNotify() {
        this.visible = true;
        this.validateFields();
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        this.visible = false;
        super.removeNotify();
    }

    private void initEncoding() {
        this.originalEncoding = ProjectPropertiesSupport.getEncoding(this.properties.getProject());
        if (this.originalEncoding == null) {
            this.originalEncoding = Charset.defaultCharset().name();
        }
        this.encodingComboBox.setRenderer(ProjectCustomizer.encodingRenderer());
        this.encodingComboBox.setModel(ProjectCustomizer.encodingModel((String)this.originalEncoding));
        String lafid = UIManager.getLookAndFeel().getID();
        if (!"Aqua".equals(lafid)) {
            this.encodingComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
            this.encodingComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JComboBox combo = (JComboBox)e.getSource();
                    combo.setPopupVisible(false);
                }
            });
        }
    }

    private void initProjectAndSources() {
        PhpProject project = this.properties.getProject();
        FileObject projectFolder = project.getProjectDirectory();
        String projectPath = FileUtil.getFileDisplayName((FileObject)projectFolder);
        this.projectFolderTextField.setText(projectPath);
        this.sourceFolderTextField.setText(FileUtil.getFileDisplayName((FileObject)ProjectPropertiesSupport.getSourcesDirectory(this.properties.getProject())));
    }

    private void initPhpVersion() {
        PhpVersion phpVersion = ProjectPropertiesSupport.getPhpVersion(this.properties.getProject());
        assert (phpVersion != null);
        this.phpVersionComboBox.setModel(new Utils.PhpVersionComboBoxModel(phpVersion));
    }

    private void initTags() {
        this.shortTagsCheckBox.setSelected(ProjectPropertiesSupport.areShortTagsEnabled(this.properties.getProject()));
        this.aspTagsCheckBox.setSelected(ProjectPropertiesSupport.areAspTagsEnabled(this.properties.getProject()));
    }

    private boolean initCopyFiles() {
        return ProjectPropertiesSupport.isCopySourcesEnabled(this.properties.getProject());
    }

    private LocalServer initCopyTarget() {
        File copyTarget = ProjectPropertiesSupport.getCopySourcesTarget(this.properties.getProject());
        if (copyTarget == null) {
            return LocalServer.getEmpty();
        }
        FileObject resolvedFO = FileUtil.toFileObject((File)copyTarget);
        if (resolvedFO == null) {
            return new LocalServer(copyTarget.getAbsolutePath());
        }
        return new LocalServer(FileUtil.getFileDisplayName((FileObject)resolvedFO));
    }

    void initCopyTargets(List<PhpEnvironment.DocumentRoot> roots, LocalServer initialLocalServer) {
        assert (initialLocalServer != null);
        int size = roots.size() + 1;
        ArrayList<LocalServer> localServers = new ArrayList<LocalServer>(size);
        localServers.add(initialLocalServer);
        for (PhpEnvironment.DocumentRoot root : roots) {
            LocalServer ls = new LocalServer(root.getDocumentRoot());
            localServers.add(ls);
        }
        this.copyFilesVisual.setLocalServerModel(new LocalServer.ComboBoxModel(localServers.toArray(new LocalServer[0])));
        this.copyFilesVisual.selectLocalServer(initialLocalServer);
        this.copyFilesVisual.setState(true);
        this.validateFields();
    }

    @Override
    public String getSourcesFolderName() {
        return this.getSourcesFolder().getName();
    }

    @Override
    public File getSourcesFolder() {
        return FileUtil.normalizeFile((File)new File(this.projectFolderTextField.getText()));
    }

    void validateFields() {
        File projectDirectory;
        String srcPath;
        if (!this.visible) {
            this.category.setValid(true);
            return;
        }
        if (!this.copyFilesVisual.getState()) {
            this.category.setValid(false);
            return;
        }
        this.category.setErrorMessage(null);
        this.category.setValid(true);
        String err = null;
        File srcDir = this.getSrcDir();
        if (!srcDir.isDirectory()) {
            this.category.setErrorMessage(NbBundle.getMessage(CustomizerSources.class, (String)"MSG_IllegalSources"));
            this.category.setValid(false);
            return;
        }
        File webRootDir = this.getWebRootDir();
        if (!webRootDir.exists()) {
            this.category.setErrorMessage(NbBundle.getMessage(CustomizerSources.class, (String)"MSG_IllegalWebRoot"));
            this.category.setValid(false);
            return;
        }
        File copyTargetDir = this.getCopyTargetDir();
        boolean isCopyFiles = this.copyFilesVisual.isCopyFiles();
        if (isCopyFiles) {
            if (copyTargetDir == null) {
                this.category.setErrorMessage(NbBundle.getMessage(CustomizerSources.class, (String)"MSG_IllegalFolderName"));
                this.category.setValid(false);
                return;
            }
            err = LocalServerController.validateLocalServer(this.copyFilesVisual.getLocalServer(), "Folder", true, true);
            if (err != null) {
                this.category.setErrorMessage(err);
                this.category.setValid(false);
                return;
            }
            err = Utils.validateSourcesAndCopyTarget(srcDir.getAbsolutePath(), copyTargetDir.getAbsolutePath());
            if (err != null) {
                this.category.setErrorMessage(err);
                this.category.setValid(false);
                return;
            }
            if (copyTargetDir.isDirectory() && (this.targetFolderChanged(copyTargetDir.getAbsolutePath()) || !this.originalCopySrcFiles)) {
                this.category.setErrorMessage(NbBundle.getMessage(CustomizerSources.class, (String)"MSG_TargetFolderNotEmpty"));
            }
        }
        if ((srcPath = PropertyUtils.relativizeFile((File)(projectDirectory = FileUtil.toFile((FileObject)this.properties.getProject().getProjectDirectory())), (File)srcDir)) == null) {
            srcPath = srcDir.getAbsolutePath();
        }
        this.properties.setSrcDir(srcPath);
        this.properties.setCopySrcFiles(String.valueOf(isCopyFiles));
        this.properties.setCopySrcTarget(copyTargetDir == null ? "" : copyTargetDir.getAbsolutePath());
        this.properties.setCopySrcOnOpen(this.copyFilesVisual.isCopyOnOpen());
        String webRoot = PropertyUtils.relativizeFile((File)srcDir, (File)webRootDir);
        assert (webRoot != null && !webRoot.startsWith("../")) : "WebRoot must be underneath Sources";
        this.properties.setWebRoot(webRoot);
        this.properties.setShortTags(String.valueOf(this.shortTagsCheckBox.isSelected()));
        this.properties.setAspTags(String.valueOf(this.aspTagsCheckBox.isSelected()));
        this.properties.setPhpVersion(((PhpVersion)this.phpVersionComboBox.getSelectedItem()).name());
    }

    private File getSrcDir() {
        return new File(this.sourceFolderTextField.getText());
    }

    private File getWebRootDir() {
        String webRoot = this.webRootTextField.getText();
        if (CustomizerSources.isDefaultWebRoot(webRoot)) {
            return this.getSrcDir();
        }
        return FileUtil.normalizeFile((File)new File(this.getSrcDir(), webRoot));
    }

    private String getWebRoot() {
        String webRoot = this.properties.getWebRoot();
        if (CustomizerSources.isDefaultWebRoot(webRoot)) {
            return DEFAULT_WEB_ROOT;
        }
        return webRoot;
    }

    private static boolean isDefaultWebRoot(String webRoot) {
        return webRoot == null || webRoot.trim().length() == 0 || webRoot.equals(".") || DEFAULT_WEB_ROOT.equals(webRoot);
    }

    private File getCopyTargetDir() {
        LocalServer localServer = this.copyFilesVisual.getLocalServer();
        String srcRoot = localServer.getSrcRoot();
        if (srcRoot == null || srcRoot.length() == 0) {
            return null;
        }
        return FileUtil.normalizeFile((File)new File(srcRoot));
    }

    private boolean targetFolderChanged(String copyTargetDir) {
        return !this.originalCopySrcTarget.equals(copyTargetDir);
    }

    private void initComponents() {
        this.projectFolderLabel = new JLabel();
        this.projectFolderTextField = new JTextField();
        this.sourceFolderLabel = new JLabel();
        this.sourceFolderTextField = new JTextField();
        this.sourceFolderButton = new JButton();
        this.webRootLabel = new JLabel();
        this.webRootTextField = new JTextField();
        this.webRootButton = new JButton();
        this.copyFilesPanel = new JPanel();
        this.encodingLabel = new JLabel();
        this.encodingComboBox = new JComboBox();
        this.phpVersionLabel = new JLabel();
        this.phpVersionComboBox = new JComboBox();
        this.phpVersionInfoLabel = new JLabel();
        this.shortTagsCheckBox = new JCheckBox();
        this.aspTagsCheckBox = new JCheckBox();
        this.projectFolderLabel.setLabelFor(this.projectFolderTextField);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/php/project/ui/customizer/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.projectFolderLabel, (String)bundle.getString("LBL_ProjectFolder"));
        this.projectFolderTextField.setEditable(false);
        this.sourceFolderLabel.setLabelFor(this.sourceFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.sourceFolderLabel, (String)bundle.getString("LBL_SourceFolder"));
        this.sourceFolderTextField.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.sourceFolderButton, (String)NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.sourceFolderButton.text"));
        this.sourceFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerSources.this.sourceFolderButtonActionPerformed(evt);
            }
        });
        this.webRootLabel.setLabelFor(this.webRootTextField);
        Mnemonics.setLocalizedText((JLabel)this.webRootLabel, (String)bundle.getString("LBL_WebRoot"));
        this.webRootTextField.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.webRootButton, (String)NbBundle.getMessage(CustomizerSources.class, (String)"LBL_BrowseWebRoot"));
        this.webRootButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerSources.this.webRootButtonActionPerformed(evt);
            }
        });
        this.copyFilesPanel.setLayout(new BorderLayout());
        this.encodingLabel.setLabelFor(this.encodingComboBox);
        Mnemonics.setLocalizedText((JLabel)this.encodingLabel, (String)NbBundle.getMessage(CustomizerSources.class, (String)"LBL_Encoding"));
        this.phpVersionLabel.setLabelFor(this.phpVersionComboBox);
        Mnemonics.setLocalizedText((JLabel)this.phpVersionLabel, (String)NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.phpVersionLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.phpVersionInfoLabel, (String)NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.phpVersionInfoLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.shortTagsCheckBox, (String)NbBundle.getMessage(CustomizerSources.class, (String)"LBL_ShortTagsEnabled"));
        Mnemonics.setLocalizedText((AbstractButton)this.aspTagsCheckBox, (String)NbBundle.getMessage(CustomizerSources.class, (String)"LBL_AspTagsEnabled"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectFolderLabel).addComponent(this.sourceFolderLabel).addComponent(this.webRootLabel).addComponent(this.encodingLabel).addComponent(this.phpVersionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectFolderTextField).addGroup(layout.createSequentialGroup().addComponent(this.sourceFolderTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourceFolderButton)).addGroup(layout.createSequentialGroup().addComponent(this.webRootTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.webRootButton)).addComponent(this.encodingComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.phpVersionComboBox, 0, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.phpVersionInfoLabel).addGap(0, 0, Short.MAX_VALUE)))).addComponent(this.copyFilesPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.aspTagsCheckBox).addComponent(this.shortTagsCheckBox)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectFolderLabel).addComponent(this.projectFolderTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sourceFolderLabel).addComponent(this.sourceFolderTextField, -2, -1, -2).addComponent(this.sourceFolderButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.webRootLabel).addComponent(this.webRootTextField, -2, -1, -2).addComponent(this.webRootButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copyFilesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.encodingComboBox, -2, -1, -2).addComponent(this.encodingLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phpVersionComboBox, -2, -1, -2).addComponent(this.phpVersionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpVersionInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.shortTagsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.aspTagsCheckBox)));
        this.projectFolderLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.projectFolderLabel.AccessibleContext.accessibleName"));
        this.projectFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.projectFolderLabel.AccessibleContext.accessibleDescription"));
        this.projectFolderTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerSources.class, (String)"ACSN_ProjectFolder"));
        this.projectFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"ACSD_ProjectFolder"));
        this.sourceFolderLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.sourceFolderLabel.AccessibleContext.accessibleName"));
        this.sourceFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.sourceFolderLabel.AccessibleContext.accessibleDescription"));
        this.sourceFolderTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.sourceFolderTextField.AccessibleContext.accessibleName"));
        this.sourceFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.sourceFolderTextField.AccessibleContext.accessibleDescription"));
        this.webRootLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.webRootLabel.AccessibleContext.accessibleName"));
        this.webRootLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.webRootLabel.AccessibleContext.accessibleDescription"));
        this.webRootTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.webRootTextField.AccessibleContext.accessibleName"));
        this.webRootTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.webRootTextField.AccessibleContext.accessibleDescription"));
        this.webRootButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerSources.class, (String)"ACSN_Browse"));
        this.webRootButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"ACSD_BrowseWebRoot"));
        this.copyFilesPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.copyFilesPanel.AccessibleContext.accessibleName"));
        this.copyFilesPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.copyFilesPanel.AccessibleContext.accessibleDescription"));
        this.encodingLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.encodingLabel.AccessibleContext.accessibleName"));
        this.encodingLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.encodingLabel.AccessibleContext.accessibleDescription"));
        this.encodingComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerSources.class, (String)"ACSN_Encoding"));
        this.encodingComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"ACSD_Encoding"));
        this.phpVersionLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.phpVersionLabel.AccessibleContext.accessibleName"));
        this.phpVersionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.phpVersionLabel.AccessibleContext.accessibleDescription"));
        this.phpVersionComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.phpVersionComboBox.AccessibleContext.accessibleName"));
        this.phpVersionComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.phpVersionComboBox.AccessibleContext.accessibleDescription"));
        this.phpVersionInfoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.phpVersionInfoLabel.AccessibleContext.accessibleName"));
        this.phpVersionInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.phpVersionInfoLabel.AccessibleContext.accessibleDescription"));
        this.shortTagsCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.shortTagsCheckBox.AccessibleContext.accessibleName"));
        this.shortTagsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.shortTagsCheckBox.AccessibleContext.accessibleDescription"));
        this.aspTagsCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.aspTagsCheckBox.AccessibleContext.accessibleName"));
        this.aspTagsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.aspTagsCheckBox.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.AccessibleContext.accessibleDescription"));
    }

    private void webRootButtonActionPerformed(ActionEvent evt) {
        FileObject fo = FileUtil.toFileObject((File)this.getSrcDir());
        if (fo == null) {
            return;
        }
        String selected = Utils.browseFolder(this.properties.getProject(), fo, this.webRootTextField.getText());
        if (CustomizerSources.isDefaultWebRoot(selected)) {
            selected = DEFAULT_WEB_ROOT;
        }
        this.webRootTextField.setText(selected);
    }

    private void sourceFolderButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        File sources = new FileChooserBuilder(CustomizerSources.class).setDirectoriesOnly(true).setTitle(Bundle.CustomizerSources_src_browse_title()).setDefaultWorkingDirectory(FileUtil.toFile((FileObject)this.properties.getProject().getProjectDirectory())).forceUseOfDefaultWorkingDirectory(true).showOpenDialog();
        if (sources != null) {
            this.sourceFolderTextField.setText(FileUtil.normalizeFile((File)sources).getAbsolutePath());
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.php.project.ui.customizer.CustomizerSources");
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        throw new IllegalStateException();
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        throw new IllegalStateException();
    }

    private class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            CustomizerSources.this.validateFields();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            CustomizerSources.this.validateFields();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            CustomizerSources.this.validateFields();
        }
    }

    private class DefaultChangeListener
    implements ChangeListener {
        private DefaultChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            CustomizerSources.this.validateFields();
        }
    }

    private class DefaultComboBoxItemListener
    implements ItemListener {
        private DefaultComboBoxItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                CustomizerSources.this.validateFields();
            }
        }
    }

    private class DefaultCheckBoxItemListener
    implements ItemListener {
        private DefaultCheckBoxItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            CustomizerSources.this.validateFields();
        }
    }
}

