/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.console.karaf.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.karaf.shell.api.action.lifecycle.Manager;
import org.apache.karaf.shell.api.console.Registry;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.openhab.core.io.console.extensions.ConsoleCommandExtension;
import org.openhab.core.io.console.karaf.internal.CommandWrapper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class ConsoleSupportKaraf {
    private final Logger logger = LoggerFactory.getLogger(ConsoleSupportKaraf.class);
    private SessionFactory sessionFactory;
    private final Collection<ConsoleCommandExtension> commands = new HashSet<ConsoleCommandExtension>();
    private final Map<ConsoleCommandExtension, CommandWrapper> registeredCommands = new HashMap<ConsoleCommandExtension, CommandWrapper>();
    private Manager manager;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.manager = (Manager)sessionFactory.getRegistry().getService(Manager.class);
        this.manager.register(CommandWrapper.class);
        this.registerCommands();
    }

    public void unsetSessionFactory(SessionFactory sessionFactory) {
        if (this.sessionFactory == sessionFactory) {
            this.unregisterCommands();
            if (this.manager != null) {
                this.manager.unregister(CommandWrapper.class);
            }
            this.sessionFactory = null;
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addConsoleCommandExtension(ConsoleCommandExtension consoleCommandExtension) {
        this.commands.add(consoleCommandExtension);
        if (this.sessionFactory != null) {
            this.registerCommand(consoleCommandExtension);
        }
    }

    public void removeConsoleCommandExtension(ConsoleCommandExtension consoleCommandExtension) {
        this.commands.remove(consoleCommandExtension);
        if (this.sessionFactory != null) {
            this.unregisterCommand(consoleCommandExtension);
        }
    }

    private void registerCommands() {
        for (ConsoleCommandExtension command : this.commands) {
            this.registerCommand(command);
        }
    }

    private void unregisterCommands() {
        for (ConsoleCommandExtension command : this.commands) {
            this.registerCommand(command);
        }
    }

    private void registerCommand(ConsoleCommandExtension command) {
        Registry registry = this.sessionFactory.getRegistry();
        CommandWrapper wrapperNew = new CommandWrapper(command);
        CommandWrapper wrapperOld = this.registeredCommands.put(command, wrapperNew);
        if (wrapperOld != null) {
            registry.unregister((Object)wrapperOld);
        }
        try {
            registry.register((Object)wrapperNew);
        }
        catch (Exception ex) {
            this.logger.error("Cannot register command '{}'.", (Object)command.getCommand(), (Object)ex);
        }
    }

    private void unregisterCommand(ConsoleCommandExtension command) {
        Registry registry = this.sessionFactory.getRegistry();
        CommandWrapper wrapperOld = this.registeredCommands.get(command);
        if (wrapperOld != null) {
            try {
                registry.unregister((Object)wrapperOld);
            }
            catch (Exception ex) {
                this.logger.error("Cannot unregister command '{}'.", (Object)command.getCommand(), (Object)ex);
            }
        }
    }
}

