/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.observe;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.californium.core.observe.ObserveRelation;

public class ObservingEndpoint {
    private final InetSocketAddress address;
    private final List<ObserveRelation> relations;

    public ObservingEndpoint(InetSocketAddress address) {
        if (address == null) {
            throw new NullPointerException("Address must not be null!");
        }
        this.address = address;
        this.relations = new CopyOnWriteArrayList<ObserveRelation>();
    }

    public void addObserveRelation(ObserveRelation relation) {
        this.relations.add(relation);
    }

    public void removeObserveRelation(ObserveRelation relation) {
        this.relations.remove(relation);
    }

    public void cancelAll() {
        for (ObserveRelation relation : this.relations) {
            if (!relation.isEstablished()) continue;
            relation.cancel();
        }
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public boolean isEmpty() {
        return this.relations.isEmpty();
    }
}

