/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.tree.AbstractNodeStore;
import com.amazon.randomcutforest.tree.BoundingBox;
import com.amazon.randomcutforest.tree.Cut;
import com.amazon.randomcutforest.tree.IBoundingBoxView;
import com.amazon.randomcutforest.tree.RandomCutTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Function;

public class HyperTree
extends RandomCutTree {
    private final Function<IBoundingBoxView, double[]> gVecBuild;

    public Function<IBoundingBoxView, double[]> getgVec() {
        return this.gVecBuild;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected HyperTree(Builder builder) {
        super(builder);
        this.gVecBuild = builder.gVec;
    }

    public void makeTree(List<Integer> list, int seed) {
        if (list.size() > 0 && list.size() < this.numberOfLeaves + 1) {
            int[] leftIndex = new int[this.numberOfLeaves - 1];
            int[] rightIndex = new int[this.numberOfLeaves - 1];
            Arrays.fill(leftIndex, this.numberOfLeaves - 1);
            Arrays.fill(rightIndex, this.numberOfLeaves - 1);
            int[] cutDimension = new int[this.numberOfLeaves - 1];
            float[] cutValue = new float[this.numberOfLeaves - 1];
            this.root = this.makeTreeInt(list, seed, 0, this.gVecBuild, leftIndex, rightIndex, cutDimension, cutValue);
            this.nodeStore = ((AbstractNodeStore.Builder)((AbstractNodeStore.Builder)((AbstractNodeStore.Builder)((AbstractNodeStore.Builder)((AbstractNodeStore.Builder)((AbstractNodeStore.Builder)AbstractNodeStore.builder().dimension(this.dimension)).capacity(this.numberOfLeaves - 1)).leftIndex(leftIndex)).rightIndex(rightIndex)).cutDimension(cutDimension)).cutValues(cutValue)).build();
            for (int i = 0; i < list.size(); ++i) {
                this.addPointToPartialTree(list.get(i), 0L);
            }
        } else {
            this.root = AbstractNodeStore.Null;
        }
    }

    private int makeTreeInt(List<Integer> pointList, int seed, int firstFree, Function<IBoundingBoxView, double[]> vecBuild, int[] left, int[] right, int[] cutDimension, float[] cutValue) {
        if (pointList.size() == 0) {
            return AbstractNodeStore.Null;
        }
        BoundingBox thisBox = new BoundingBox(this.pointStoreView.getNumericVector(pointList.get(0)));
        for (int i = 1; i < pointList.size(); ++i) {
            thisBox = thisBox.getMergedBox(this.pointStoreView.getNumericVector(pointList.get(i)));
        }
        if (thisBox.getRangeSum() <= 0.0) {
            return pointList.get(0) + this.nodeStore.getCapacity() + 1;
        }
        Random ring = new Random(seed);
        int leftSeed = ring.nextInt();
        int rightSeed = ring.nextInt();
        Cut cut = this.getCut(thisBox, ring, vecBuild);
        ArrayList<Integer> leftList = new ArrayList<Integer>();
        ArrayList<Integer> rightList = new ArrayList<Integer>();
        for (int j = 0; j < pointList.size(); ++j) {
            if (this.nodeStore.leftOf((float)cut.getValue(), cut.getDimension(), this.pointStoreView.getNumericVector(pointList.get(j)))) {
                leftList.add(pointList.get(j));
                continue;
            }
            rightList.add(pointList.get(j));
        }
        int leftIndex = this.makeTreeInt(leftList, leftSeed, firstFree + 1, vecBuild, left, right, cutDimension, cutValue);
        int rightIndex = this.makeTreeInt(rightList, rightSeed, firstFree + leftList.size(), vecBuild, left, right, cutDimension, cutValue);
        left[firstFree] = Math.min(leftIndex, this.numberOfLeaves - 1);
        right[firstFree] = Math.min(rightIndex, this.numberOfLeaves - 1);
        cutDimension[firstFree] = cut.getDimension();
        cutValue[firstFree] = (float)cut.getValue();
        return firstFree;
    }

    private Cut getCut(IBoundingBoxView bb, Random ring, Function<IBoundingBoxView, double[]> vecSeparation) {
        Random rng = new Random(ring.nextInt());
        double cutf = rng.nextDouble();
        double dimf = rng.nextDouble();
        int td = -1;
        double rangeSum = 0.0;
        double[] vector = vecSeparation.apply(bb);
        for (int i = 0; i < bb.getDimensions(); ++i) {
            vector[i] = (float)vector[i];
            rangeSum += vector[i];
        }
        double breakPoint = dimf * rangeSum;
        float cutValue = 0.0f;
        for (int i = 0; i < bb.getDimensions(); ++i) {
            double range = vector[i];
            if (!(range > 0.0)) continue;
            if (breakPoint > 0.0 && breakPoint <= range && (double)(cutValue = (float)(bb.getMinValue(td = i) + bb.getRange(td) * cutf)) == bb.getMaxValue(td)) {
                cutValue = (float)bb.getMinValue(td);
            }
            breakPoint -= range;
        }
        CommonUtils.checkArgument(td != -1, "Pivot selection failed.");
        return new Cut(td, cutValue);
    }

    public static class Builder
    extends RandomCutTree.Builder<Builder> {
        private Function<IBoundingBoxView, double[]> gVec;

        public Builder buildGVec(Function<IBoundingBoxView, double[]> gVec) {
            this.gVec = gVec;
            return this;
        }

        @Override
        public HyperTree build() {
            return new HyperTree(this);
        }
    }
}

