/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.opensearch.core.search.InnerHits;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class HasParentQuery
extends QueryBase
implements QueryVariant,
ToCopyableBuilder<Builder, HasParentQuery> {
    @Nullable
    private final Boolean ignoreUnmapped;
    @Nullable
    private final InnerHits innerHits;
    @Nonnull
    private final String parentType;
    @Nonnull
    private final Query query;
    @Nullable
    private final Boolean score;
    public static final JsonpDeserializer<HasParentQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HasParentQuery::setupHasParentQueryDeserializer);

    private HasParentQuery(Builder builder) {
        super(builder);
        this.ignoreUnmapped = builder.ignoreUnmapped;
        this.innerHits = builder.innerHits;
        this.parentType = ApiTypeHelper.requireNonNull(builder.parentType, this, "parentType");
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.score = builder.score;
    }

    public static HasParentQuery of(Function<Builder, ObjectBuilder<HasParentQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.HasParent;
    }

    @Nullable
    public final Boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Nullable
    public final InnerHits innerHits() {
        return this.innerHits;
    }

    @Nonnull
    public final String parentType() {
        return this.parentType;
    }

    @Nonnull
    public final Query query() {
        return this.query;
    }

    @Nullable
    public final Boolean score() {
        return this.score;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.ignoreUnmapped != null) {
            generator.writeKey("ignore_unmapped");
            generator.write(this.ignoreUnmapped.booleanValue());
        }
        if (this.innerHits != null) {
            generator.writeKey("inner_hits");
            this.innerHits.serialize(generator, mapper);
        }
        generator.writeKey("parent_type");
        generator.write(this.parentType);
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
        if (this.score != null) {
            generator.writeKey("score");
            generator.write(this.score.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupHasParentQueryDeserializer(ObjectDeserializer<Builder> op) {
        HasParentQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::ignoreUnmapped, JsonpDeserializer.booleanDeserializer(), "ignore_unmapped");
        op.add(Builder::innerHits, InnerHits._DESERIALIZER, "inner_hits");
        op.add(Builder::parentType, JsonpDeserializer.stringDeserializer(), "parent_type");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::score, JsonpDeserializer.booleanDeserializer(), "score");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.ignoreUnmapped);
        result = 31 * result + Objects.hashCode(this.innerHits);
        result = 31 * result + this.parentType.hashCode();
        result = 31 * result + this.query.hashCode();
        result = 31 * result + Objects.hashCode(this.score);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HasParentQuery other = (HasParentQuery)o;
        return Objects.equals(this.ignoreUnmapped, other.ignoreUnmapped) && Objects.equals(this.innerHits, other.innerHits) && this.parentType.equals(other.parentType) && this.query.equals(other.query) && Objects.equals(this.score, other.score);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, HasParentQuery> {
        @Nullable
        private Boolean ignoreUnmapped;
        @Nullable
        private InnerHits innerHits;
        private String parentType;
        private Query query;
        @Nullable
        private Boolean score;

        public Builder() {
        }

        private Builder(HasParentQuery o) {
            super(o);
            this.ignoreUnmapped = o.ignoreUnmapped;
            this.innerHits = o.innerHits;
            this.parentType = o.parentType;
            this.query = o.query;
            this.score = o.score;
        }

        private Builder(Builder o) {
            super(o);
            this.ignoreUnmapped = o.ignoreUnmapped;
            this.innerHits = o.innerHits;
            this.parentType = o.parentType;
            this.query = o.query;
            this.score = o.score;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder ignoreUnmapped(@Nullable Boolean value) {
            this.ignoreUnmapped = value;
            return this;
        }

        @Nonnull
        public final Builder innerHits(@Nullable InnerHits value) {
            this.innerHits = value;
            return this;
        }

        @Nonnull
        public final Builder innerHits(Function<InnerHits.Builder, ObjectBuilder<InnerHits>> fn) {
            return this.innerHits(fn.apply(new InnerHits.Builder()).build());
        }

        @Nonnull
        public final Builder parentType(String value) {
            this.parentType = value;
            return this;
        }

        @Nonnull
        public final Builder query(Query value) {
            this.query = value;
            return this;
        }

        @Nonnull
        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        @Nonnull
        public final Builder score(@Nullable Boolean value) {
            this.score = value;
            return this;
        }

        @Override
        @Nonnull
        public HasParentQuery build() {
            this._checkSingleUse();
            return new HasParentQuery(this);
        }
    }
}

