/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.model.remote.monitors;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.alerting.model.DocLevelMonitorInput;
import org.opensearch.commons.alerting.model.Input;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 &2\u00020\u0001:\u0001&B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006'"}, d2={"Lorg/opensearch/commons/alerting/model/remote/monitors/RemoteDocLevelMonitorInput;", "Lorg/opensearch/commons/alerting/model/Input;", "input", "Lorg/opensearch/core/common/bytes/BytesReference;", "docLevelMonitorInput", "Lorg/opensearch/commons/alerting/model/DocLevelMonitorInput;", "<init>", "(Lorg/opensearch/core/common/bytes/BytesReference;Lorg/opensearch/commons/alerting/model/DocLevelMonitorInput;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getInput", "()Lorg/opensearch/core/common/bytes/BytesReference;", "getDocLevelMonitorInput", "()Lorg/opensearch/commons/alerting/model/DocLevelMonitorInput;", "asTemplateArg", "", "", "", "name", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "common-utils"})
public final class RemoteDocLevelMonitorInput
implements Input {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BytesReference input;
    @NotNull
    private final DocLevelMonitorInput docLevelMonitorInput;
    @NotNull
    public static final String INPUT_FIELD = "input";
    @NotNull
    public static final String INPUT_SIZE = "size";
    @NotNull
    public static final String REMOTE_DOC_LEVEL_MONITOR_INPUT_FIELD = "remote_doc_level_monitor_input";

    public RemoteDocLevelMonitorInput(@NotNull BytesReference input, @NotNull DocLevelMonitorInput docLevelMonitorInput) {
        Intrinsics.checkNotNullParameter((Object)input, (String)INPUT_FIELD);
        Intrinsics.checkNotNullParameter((Object)docLevelMonitorInput, (String)"docLevelMonitorInput");
        this.input = input;
        this.docLevelMonitorInput = docLevelMonitorInput;
    }

    @NotNull
    public final BytesReference getInput() {
        return this.input;
    }

    @NotNull
    public final DocLevelMonitorInput getDocLevelMonitorInput() {
        return this.docLevelMonitorInput;
    }

    public RemoteDocLevelMonitorInput(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        BytesReference bytesReference = sin.readBytesReference();
        Intrinsics.checkNotNullExpressionValue((Object)bytesReference, (String)"readBytesReference(...)");
        this(bytesReference, DocLevelMonitorInput.Companion.readFrom(sin));
    }

    @Override
    @NotNull
    public Map<String, Object> asTemplateArg() {
        byte[] bytes = this.input.toBytesRef().bytes;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)INPUT_SIZE, (Object)bytes.length), TuplesKt.to((Object)INPUT_FIELD, (Object)bytes), TuplesKt.to((Object)"doc_level_input", (Object)this.docLevelMonitorInput)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public String name() {
        return REMOTE_DOC_LEVEL_MONITOR_INPUT_FIELD;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeBytesReference(this.input);
        this.docLevelMonitorInput.writeTo(out);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        byte[] bytes = this.input.toBytesRef().bytes;
        XContentBuilder xContentBuilder = builder.startObject().startObject(REMOTE_DOC_LEVEL_MONITOR_INPUT_FIELD).field(INPUT_SIZE, bytes.length).field(INPUT_FIELD, bytes).field("doc_level_input", (ToXContent)this.docLevelMonitorInput).endObject().endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"endObject(...)");
        return xContentBuilder;
    }

    @NotNull
    public final BytesReference component1() {
        return this.input;
    }

    @NotNull
    public final DocLevelMonitorInput component2() {
        return this.docLevelMonitorInput;
    }

    @NotNull
    public final RemoteDocLevelMonitorInput copy(@NotNull BytesReference input, @NotNull DocLevelMonitorInput docLevelMonitorInput) {
        Intrinsics.checkNotNullParameter((Object)input, (String)INPUT_FIELD);
        Intrinsics.checkNotNullParameter((Object)docLevelMonitorInput, (String)"docLevelMonitorInput");
        return new RemoteDocLevelMonitorInput(input, docLevelMonitorInput);
    }

    public static /* synthetic */ RemoteDocLevelMonitorInput copy$default(RemoteDocLevelMonitorInput remoteDocLevelMonitorInput, BytesReference bytesReference, DocLevelMonitorInput docLevelMonitorInput, int n, Object object) {
        if ((n & 1) != 0) {
            bytesReference = remoteDocLevelMonitorInput.input;
        }
        if ((n & 2) != 0) {
            docLevelMonitorInput = remoteDocLevelMonitorInput.docLevelMonitorInput;
        }
        return remoteDocLevelMonitorInput.copy(bytesReference, docLevelMonitorInput);
    }

    @NotNull
    public String toString() {
        return "RemoteDocLevelMonitorInput(input=" + this.input + ", docLevelMonitorInput=" + this.docLevelMonitorInput + ")";
    }

    public int hashCode() {
        int result = this.input.hashCode();
        result = result * 31 + this.docLevelMonitorInput.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RemoteDocLevelMonitorInput)) {
            return false;
        }
        RemoteDocLevelMonitorInput remoteDocLevelMonitorInput = (RemoteDocLevelMonitorInput)other;
        if (!Intrinsics.areEqual((Object)this.input, (Object)remoteDocLevelMonitorInput.input)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.docLevelMonitorInput, (Object)remoteDocLevelMonitorInput.docLevelMonitorInput);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/opensearch/commons/alerting/model/remote/monitors/RemoteDocLevelMonitorInput$Companion;", "", "<init>", "()V", "INPUT_FIELD", "", "INPUT_SIZE", "REMOTE_DOC_LEVEL_MONITOR_INPUT_FIELD", "parse", "Lorg/opensearch/commons/alerting/model/remote/monitors/RemoteDocLevelMonitorInput;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RemoteDocLevelMonitorInput parse(@NotNull XContentParser xcp) {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            byte[] bytes = null;
            int size = 0;
            DocLevelMonitorInput docLevelMonitorInput = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                String string = fieldName;
                if (Intrinsics.areEqual((Object)string, (Object)RemoteDocLevelMonitorInput.INPUT_FIELD)) {
                    bytes = xcp.binaryValue();
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)RemoteDocLevelMonitorInput.INPUT_SIZE)) {
                    size = xcp.intValue();
                    continue;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)Input.Type.DOCUMENT_LEVEL_INPUT.getValue())) continue;
                docLevelMonitorInput = DocLevelMonitorInput.Companion.parse(xcp);
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
            }
            BytesReference input = BytesReference.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(bytes, 0, size));
            Intrinsics.checkNotNull((Object)input);
            DocLevelMonitorInput docLevelMonitorInput2 = docLevelMonitorInput;
            Intrinsics.checkNotNull(docLevelMonitorInput2);
            return new RemoteDocLevelMonitorInput(input, docLevelMonitorInput2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

