/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.settings.get;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@PublicApi(since="1.0.0")
public class GetSettingsResponse
extends ActionResponse
implements ToXContentObject {
    private final Map<String, Settings> indexToSettings;
    private final Map<String, Settings> indexToDefaultSettings;

    public GetSettingsResponse(Map<String, Settings> indexToSettings, Map<String, Settings> indexToDefaultSettings) {
        this.indexToSettings = Collections.unmodifiableMap(indexToSettings);
        this.indexToDefaultSettings = Collections.unmodifiableMap(indexToDefaultSettings);
    }

    public GetSettingsResponse(StreamInput in) throws IOException {
        super(in);
        this.indexToSettings = in.readMap(StreamInput::readString, Settings::readSettingsFromStream);
        this.indexToDefaultSettings = in.readMap(StreamInput::readString, Settings::readSettingsFromStream);
    }

    public Map<String, Settings> getIndexToSettings() {
        return this.indexToSettings;
    }

    public Map<String, Settings> getIndexToDefaultSettings() {
        return this.indexToDefaultSettings;
    }

    public String getSetting(String index, String setting) {
        Settings settings = this.indexToSettings.get(index);
        if (setting != null) {
            if (settings != null && settings.hasValue(setting)) {
                return settings.get(setting);
            }
            Settings defaultSettings = this.indexToDefaultSettings.get(index);
            if (defaultSettings != null) {
                return defaultSettings.get(setting);
            }
            return null;
        }
        return null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.indexToSettings, StreamOutput::writeString, (o, s) -> Settings.writeSettingsToStream(s, o));
        out.writeMap(this.indexToDefaultSettings, StreamOutput::writeString, (o, s) -> Settings.writeSettingsToStream(s, o));
    }

    private static void parseSettingsField(XContentParser parser, String currentIndexName, Map<String, Settings> indexToSettings, Map<String, Settings> indexToDefaultSettings) throws IOException {
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            switch (parser.currentName()) {
                case "settings": {
                    indexToSettings.put(currentIndexName, Settings.fromXContent(parser));
                    break;
                }
                case "defaults": {
                    indexToDefaultSettings.put(currentIndexName, Settings.fromXContent(parser));
                    break;
                }
                default: {
                    parser.skipChildren();
                    break;
                }
            }
        } else if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
            parser.skipChildren();
        }
        parser.nextToken();
    }

    private static void parseIndexEntry(XContentParser parser, Map<String, Settings> indexToSettings, Map<String, Settings> indexToDefaultSettings) throws IOException {
        String indexName = parser.currentName();
        parser.nextToken();
        while (!parser.isClosed() && parser.currentToken() != XContentParser.Token.END_OBJECT) {
            GetSettingsResponse.parseSettingsField(parser, indexName, indexToSettings, indexToDefaultSettings);
        }
    }

    public static GetSettingsResponse fromXContent(XContentParser parser) throws IOException {
        HashMap<String, Settings> indexToSettings = new HashMap<String, Settings>();
        HashMap<String, Settings> indexToDefaultSettings = new HashMap<String, Settings>();
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        parser.nextToken();
        while (!parser.isClosed()) {
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                GetSettingsResponse.parseIndexEntry(parser, indexToSettings, indexToDefaultSettings);
                continue;
            }
            if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                parser.skipChildren();
                continue;
            }
            parser.nextToken();
        }
        Map<String, Settings> settingsMap = Collections.unmodifiableMap(indexToSettings);
        Map<String, Settings> defaultSettingsMap = Collections.unmodifiableMap(indexToDefaultSettings);
        return new GetSettingsResponse(settingsMap, defaultSettingsMap);
    }

    public String toString() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XContentBuilder builder = new XContentBuilder((XContent)JsonXContent.jsonXContent, (OutputStream)baos);
            this.toXContent(builder, ToXContent.EMPTY_PARAMS, false);
            return builder.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContent(builder, params, this.indexToDefaultSettings.isEmpty());
    }

    private XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, boolean omitEmptySettings) throws IOException {
        builder.startObject();
        for (Map.Entry<String, Settings> cursor : this.getIndexToSettings().entrySet()) {
            if (omitEmptySettings && cursor.getValue().isEmpty()) continue;
            builder.startObject(cursor.getKey());
            builder.startObject("settings");
            cursor.getValue().toXContent(builder, params);
            builder.endObject();
            if (!this.indexToDefaultSettings.isEmpty()) {
                builder.startObject("defaults");
                this.indexToDefaultSettings.get(cursor.getKey()).toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GetSettingsResponse that = (GetSettingsResponse)((Object)o);
        return Objects.equals(this.indexToSettings, that.indexToSettings) && Objects.equals(this.indexToDefaultSettings, that.indexToDefaultSettings);
    }

    public int hashCode() {
        return Objects.hash(this.indexToSettings, this.indexToDefaultSettings);
    }
}

