/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.OpenSearchException;
import org.opensearch.Version;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodeRole;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.extensions.ExtensionDependency;

public class DiscoveryExtensionNode
extends DiscoveryNode
implements Writeable,
ToXContentFragment {
    private Version minimumCompatibleVersion;
    private List<ExtensionDependency> dependencies = Collections.emptyList();
    private List<String> implementedInterfaces = Collections.emptyList();

    public DiscoveryExtensionNode(String name, String id, TransportAddress address, Map<String, String> attributes, Version version, Version minimumCompatibleVersion, List<ExtensionDependency> dependencies) {
        super(name, id, address, attributes, DiscoveryNodeRole.BUILT_IN_ROLES, version);
        this.minimumCompatibleVersion = minimumCompatibleVersion;
        this.dependencies = dependencies;
        this.validate();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVersion(this.minimumCompatibleVersion);
        out.writeVInt(this.dependencies.size());
        for (ExtensionDependency dependency : this.dependencies) {
            dependency.writeTo(out);
        }
    }

    public DiscoveryExtensionNode(StreamInput in) throws IOException {
        super(in);
        this.minimumCompatibleVersion = in.readVersion();
        int size = in.readVInt();
        this.dependencies = new ArrayList<ExtensionDependency>(size);
        for (int i = 0; i < size; ++i) {
            this.dependencies.add(new ExtensionDependency(in));
        }
    }

    public List<ExtensionDependency> getDependencies() {
        return this.dependencies;
    }

    public Version getMinimumCompatibleVersion() {
        return this.minimumCompatibleVersion;
    }

    public List<String> getImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    public void setImplementedInterfaces(List<String> implementedInterfaces) {
        this.implementedInterfaces = implementedInterfaces;
    }

    public boolean dependenciesContain(ExtensionDependency dependency) {
        for (ExtensionDependency extensiondependency : this.dependencies) {
            if (!dependency.getUniqueId().equals(extensiondependency.getUniqueId()) || !dependency.getVersion().equals((Object)extensiondependency.getVersion())) continue;
            return true;
        }
        return false;
    }

    private void validate() {
        if (!Version.CURRENT.onOrAfter(this.minimumCompatibleVersion)) {
            throw new OpenSearchException("Extension minimumCompatibleVersion: " + String.valueOf(this.minimumCompatibleVersion) + " is greater than current OpenSearch version: " + String.valueOf(Version.CURRENT), new Object[0]);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return null;
    }
}

