/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.security;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IndexPermission
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, IndexPermission> {
    @Nonnull
    private final List<String> allowedActions;
    @Nullable
    private final String dls;
    @Nonnull
    private final List<String> fls;
    @Nonnull
    private final List<String> indexPatterns;
    @Nonnull
    private final List<String> maskedFields;
    public static final JsonpDeserializer<IndexPermission> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexPermission::setupIndexPermissionDeserializer);

    private IndexPermission(Builder builder) {
        this.allowedActions = ApiTypeHelper.unmodifiable(builder.allowedActions);
        this.dls = builder.dls;
        this.fls = ApiTypeHelper.unmodifiable(builder.fls);
        this.indexPatterns = ApiTypeHelper.unmodifiable(builder.indexPatterns);
        this.maskedFields = ApiTypeHelper.unmodifiable(builder.maskedFields);
    }

    public static IndexPermission of(Function<Builder, ObjectBuilder<IndexPermission>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> allowedActions() {
        return this.allowedActions;
    }

    @Nullable
    public final String dls() {
        return this.dls;
    }

    @Nonnull
    public final List<String> fls() {
        return this.fls;
    }

    @Nonnull
    public final List<String> indexPatterns() {
        return this.indexPatterns;
    }

    @Nonnull
    public final List<String> maskedFields() {
        return this.maskedFields;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.allowedActions)) {
            generator.writeKey("allowed_actions");
            generator.writeStartArray();
            for (String item0 : this.allowedActions) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.dls != null) {
            generator.writeKey("dls");
            generator.write(this.dls);
        }
        if (ApiTypeHelper.isDefined(this.fls)) {
            generator.writeKey("fls");
            generator.writeStartArray();
            for (String item0 : this.fls) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.indexPatterns)) {
            generator.writeKey("index_patterns");
            generator.writeStartArray();
            for (String item0 : this.indexPatterns) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.maskedFields)) {
            generator.writeKey("masked_fields");
            generator.writeStartArray();
            for (String item0 : this.maskedFields) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIndexPermissionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allowedActions, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "allowed_actions");
        op.add(Builder::dls, JsonpDeserializer.stringDeserializer(), "dls");
        op.add(Builder::fls, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fls");
        op.add(Builder::indexPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index_patterns");
        op.add(Builder::maskedFields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "masked_fields");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.allowedActions);
        result = 31 * result + Objects.hashCode(this.dls);
        result = 31 * result + Objects.hashCode(this.fls);
        result = 31 * result + Objects.hashCode(this.indexPatterns);
        result = 31 * result + Objects.hashCode(this.maskedFields);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexPermission other = (IndexPermission)o;
        return Objects.equals(this.allowedActions, other.allowedActions) && Objects.equals(this.dls, other.dls) && Objects.equals(this.fls, other.fls) && Objects.equals(this.indexPatterns, other.indexPatterns) && Objects.equals(this.maskedFields, other.maskedFields);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, IndexPermission> {
        @Nullable
        private List<String> allowedActions;
        @Nullable
        private String dls;
        @Nullable
        private List<String> fls;
        @Nullable
        private List<String> indexPatterns;
        @Nullable
        private List<String> maskedFields;

        public Builder() {
        }

        private Builder(IndexPermission o) {
            this.allowedActions = Builder._listCopy(o.allowedActions);
            this.dls = o.dls;
            this.fls = Builder._listCopy(o.fls);
            this.indexPatterns = Builder._listCopy(o.indexPatterns);
            this.maskedFields = Builder._listCopy(o.maskedFields);
        }

        private Builder(Builder o) {
            this.allowedActions = Builder._listCopy(o.allowedActions);
            this.dls = o.dls;
            this.fls = Builder._listCopy(o.fls);
            this.indexPatterns = Builder._listCopy(o.indexPatterns);
            this.maskedFields = Builder._listCopy(o.maskedFields);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder allowedActions(List<String> list) {
            this.allowedActions = Builder._listAddAll(this.allowedActions, list);
            return this;
        }

        @Nonnull
        public final Builder allowedActions(String value, String ... values) {
            this.allowedActions = Builder._listAdd(this.allowedActions, value, values);
            return this;
        }

        @Nonnull
        public final Builder dls(@Nullable String value) {
            this.dls = value;
            return this;
        }

        @Nonnull
        public final Builder fls(List<String> list) {
            this.fls = Builder._listAddAll(this.fls, list);
            return this;
        }

        @Nonnull
        public final Builder fls(String value, String ... values) {
            this.fls = Builder._listAdd(this.fls, value, values);
            return this;
        }

        @Nonnull
        public final Builder indexPatterns(List<String> list) {
            this.indexPatterns = Builder._listAddAll(this.indexPatterns, list);
            return this;
        }

        @Nonnull
        public final Builder indexPatterns(String value, String ... values) {
            this.indexPatterns = Builder._listAdd(this.indexPatterns, value, values);
            return this;
        }

        @Nonnull
        public final Builder maskedFields(List<String> list) {
            this.maskedFields = Builder._listAddAll(this.maskedFields, list);
            return this;
        }

        @Nonnull
        public final Builder maskedFields(String value, String ... values) {
            this.maskedFields = Builder._listAdd(this.maskedFields, value, values);
            return this;
        }

        @Override
        @Nonnull
        public IndexPermission build() {
            this._checkSingleUse();
            return new IndexPermission(this);
        }
    }
}

