/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.utils;

import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.core.common.Strings;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.plugin.insights.rules.model.Attribute;
import org.opensearch.plugin.insights.rules.model.MetricType;
import org.opensearch.plugin.insights.rules.model.SearchQueryRecord;
import org.opensearch.plugin.insights.settings.QueryInsightsSettings;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortOrder;
import reactor.util.annotation.NonNull;

public final class QueryInsightsQueryBuilder {
    private static final int MAX_TOP_N_INDEX_READ_SIZE = 500;

    private QueryInsightsQueryBuilder() {
    }

    public static SearchRequest buildTopNSearchRequest(List<String> indexNames, ZonedDateTime start, ZonedDateTime end, String id, Boolean verbose, MetricType metricType) {
        SearchRequest searchRequest = new SearchRequest(indexNames.toArray(new String[0]));
        searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)true, (boolean)false));
        searchRequest.requestCache(Boolean.valueOf(true));
        SearchSourceBuilder searchSourceBuilder = QueryInsightsQueryBuilder.buildSearchSourceBuilder(start, end, id, verbose, metricType);
        searchSourceBuilder.timeout(QueryInsightsSettings.DEFAULT_SEARCH_REQUEST_TIMEOUT);
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    private static SearchSourceBuilder buildSearchSourceBuilder(ZonedDateTime start, ZonedDateTime end, String id, Boolean verbose, @NonNull MetricType metricType) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(500);
        BoolQueryBuilder query = QueryInsightsQueryBuilder.buildTopNQuery(start, end, id, metricType);
        searchSourceBuilder.query((QueryBuilder)query);
        if (Boolean.FALSE.equals(verbose)) {
            searchSourceBuilder.fetchSource(Strings.EMPTY_ARRAY, (String[])Arrays.stream(SearchQueryRecord.VERBOSE_ONLY_FIELDS).map(Attribute::toString).toArray(String[]::new));
        }
        searchSourceBuilder.sort(SortBuilders.fieldSort((String)("measurements." + String.valueOf(metricType) + ".number")).order(SortOrder.DESC));
        return searchSourceBuilder;
    }

    private static BoolQueryBuilder buildTopNQuery(ZonedDateTime start, ZonedDateTime end, String id, MetricType metricType) {
        RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)"timestamp").from((Object)start.toInstant().toEpochMilli()).to((Object)end.toInstant().toEpochMilli());
        BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)rangeQuery);
        if (id != null) {
            query.must((QueryBuilder)QueryBuilders.termQuery((String)"id", (String)id));
        } else {
            query.must((QueryBuilder)QueryBuilders.termQuery((String)("top_n_query." + String.valueOf(metricType)), (boolean)true));
        }
        return query;
    }
}

