/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.lucene;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.TopDocs;

public class SeededTopDocsDISI
extends DocIdSetIterator {
    private final int[] sortedDocIds;
    private int idx = -1;

    public SeededTopDocsDISI(TopDocs topDocs) {
        this.sortedDocIds = new int[topDocs.scoreDocs.length];
        for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
            this.sortedDocIds[i] = topDocs.scoreDocs[i].doc;
        }
        Arrays.sort(this.sortedDocIds);
    }

    public int advance(int target) throws IOException {
        return this.slowAdvance(target);
    }

    public long cost() {
        return this.sortedDocIds.length;
    }

    public int docID() {
        if (this.idx == -1) {
            return -1;
        }
        if (this.idx >= this.sortedDocIds.length) {
            return Integer.MAX_VALUE;
        }
        return this.sortedDocIds[this.idx];
    }

    public int nextDoc() {
        ++this.idx;
        return this.docID();
    }
}

