/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.nio.ByteBuffer;
import java.util.Objects;

public class AESEncryptOutput {
    private final ByteBuffer cipherText;
    private final ByteBuffer authTag;

    protected AESEncryptOutput(BuilderImpl builder) {
        this.cipherText = builder.cipherText();
        this.authTag = builder.authTag();
    }

    public ByteBuffer cipherText() {
        return this.cipherText;
    }

    public ByteBuffer authTag() {
        return this.authTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ByteBuffer cipherText;
        protected ByteBuffer authTag;

        protected BuilderImpl() {
        }

        protected BuilderImpl(AESEncryptOutput model) {
            this.cipherText = model.cipherText();
            this.authTag = model.authTag();
        }

        @Override
        public Builder cipherText(ByteBuffer cipherText) {
            this.cipherText = cipherText;
            return this;
        }

        @Override
        public ByteBuffer cipherText() {
            return this.cipherText;
        }

        @Override
        public Builder authTag(ByteBuffer authTag) {
            this.authTag = authTag;
            return this;
        }

        @Override
        public ByteBuffer authTag() {
            return this.authTag;
        }

        @Override
        public AESEncryptOutput build() {
            if (Objects.isNull(this.cipherText())) {
                throw new IllegalArgumentException("Missing value for required field `cipherText`");
            }
            if (Objects.isNull(this.authTag())) {
                throw new IllegalArgumentException("Missing value for required field `authTag`");
            }
            return new AESEncryptOutput(this);
        }
    }

    public static interface Builder {
        public Builder cipherText(ByteBuffer var1);

        public ByteBuffer cipherText();

        public Builder authTag(ByteBuffer var1);

        public ByteBuffer authTag();

        public AESEncryptOutput build();
    }
}

