/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.web;

import com.google.inject.Injector;
import com.google.inject.servlet.GuiceFilter;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import javax.sql.DataSource;
import org.eclipse.jetty.compression.server.CompressionHandler;
import org.eclipse.jetty.ee10.proxy.AsyncProxyServlet;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.ResourceServlet;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.SessionHandler;
import org.eclipse.jetty.ee10.websocket.server.config.JettyWebSocketServletContainerInitializer;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.RequestLogWriter;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.session.DatabaseAdaptor;
import org.eclipse.jetty.session.DefaultSessionCache;
import org.eclipse.jetty.session.JDBCSessionDataStoreFactory;
import org.eclipse.jetty.session.SessionCache;
import org.eclipse.jetty.session.SessionManager;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.LifecycleObject;
import org.traccar.api.CorsResponseFilter;
import org.traccar.api.DateParameterConverterProvider;
import org.traccar.api.ResourceErrorHandler;
import org.traccar.api.StreamWriter;
import org.traccar.api.resource.ServerResource;
import org.traccar.api.security.SecurityRequestFilter;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.helper.ObjectMapperContextResolver;
import org.traccar.web.ConsoleServlet;
import org.traccar.web.OverrideFileFilter;
import org.traccar.web.WebRequestLog;

public class WebServer
implements LifecycleObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebServer.class);
    private final Injector injector;
    private final Config config;
    private final Server server;

    public WebServer(Injector injector, Config config) throws IOException {
        this.injector = injector;
        this.config = config;
        String address = config.getString(Keys.WEB_ADDRESS);
        int port = config.getInteger(Keys.WEB_PORT);
        this.server = address == null ? new Server(port) : new Server(new InetSocketAddress(address, port));
        ServletContextHandler servletHandler = new ServletContextHandler(1);
        JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)servletHandler, null);
        servletHandler.addFilter(GuiceFilter.class, "/*", EnumSet.allOf(DispatcherType.class));
        this.initApi(servletHandler);
        this.initSessionConfig(servletHandler);
        if (config.getBoolean(Keys.WEB_CONSOLE)) {
            servletHandler.addServlet(new ServletHolder((Servlet)new ConsoleServlet(config)), "/console/*");
        }
        this.initWebApp(servletHandler);
        Handler.Sequence handlers = new Handler.Sequence(new Handler[0]);
        this.initClientProxy(servletHandler);
        handlers.addHandler((Handler)servletHandler);
        handlers.addHandler((Handler)new CompressionHandler());
        this.server.setHandler((Handler)handlers);
        if (config.hasKey(Keys.WEB_REQUEST_LOG_PATH)) {
            RequestLogWriter logWriter = new RequestLogWriter(config.getString(Keys.WEB_REQUEST_LOG_PATH));
            logWriter.setAppend(true);
            logWriter.setRetainDays(config.getInteger(Keys.WEB_REQUEST_LOG_RETAIN_DAYS));
            this.server.setRequestLog((RequestLog)new WebRequestLog((RequestLog.Writer)logWriter));
        }
    }

    private void initClientProxy(ServletContextHandler servletHandler) {
        int port = this.config.getInteger(Keys.PROTOCOL_PORT.withPrefix("osmand"));
        if (port > 0) {
            ServletHolder proxy = new ServletHolder(AsyncProxyServlet.Transparent.class);
            proxy.setInitParameter("proxyTo", "http://localhost:" + port);
            servletHandler.addServlet(proxy, "/client-proxy/*");
            servletHandler.addFilter((request, response, chain) -> {
                HttpServletRequest r = (HttpServletRequest)request;
                if ("POST".equals(r.getMethod()) && "/".equals(r.getRequestURI())) {
                    request.getRequestDispatcher("/client-proxy/").forward(request, response);
                    return;
                }
                chain.doFilter(request, response);
            }, "/*", EnumSet.allOf(DispatcherType.class));
        }
    }

    private void initWebApp(ServletContextHandler servletHandler) throws IOException {
        String cache = this.config.getString(Keys.WEB_CACHE_CONTROL);
        Path baseReal = Paths.get(this.config.getString(Keys.WEB_PATH), new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS);
        servletHandler.setBaseResource(ResourceFactory.of((Container)servletHandler).newResource(baseReal));
        ServletHolder baseHolder = new ServletHolder(ResourceServlet.class);
        baseHolder.setInitParameter("dirAllowed", "false");
        baseHolder.setInitParameter("cacheControl", cache);
        servletHandler.addServlet(baseHolder, "/");
        Path override = Paths.get(this.config.getString(Keys.WEB_OVERRIDE), new String[0]);
        Files.createDirectories(override, new FileAttribute[0]);
        Path overrideReal = override.toRealPath(LinkOption.NOFOLLOW_LINKS);
        ServletHolder overrideHolder = new ServletHolder(ResourceServlet.class);
        overrideHolder.setInitParameter("baseResource", overrideReal.toString());
        overrideHolder.setInitParameter("pathInfoOnly", "true");
        overrideHolder.setInitParameter("dirAllowed", "false");
        overrideHolder.setInitParameter("cacheControl", cache);
        servletHandler.addServlet(overrideHolder, "/override/*");
        FilterHolder filterHolder = new FilterHolder((Filter)new OverrideFileFilter());
        filterHolder.setInitParameter("overridePath", overrideReal.toString());
        servletHandler.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        if (this.config.getBoolean(Keys.WEB_DEBUG)) {
            servletHandler.setWelcomeFiles(new String[]{"debug.html", "index.html"});
        } else {
            servletHandler.setWelcomeFiles(new String[]{"release.html", "index.html"});
        }
    }

    private void initApi(ServletContextHandler servletHandler) {
        String mediaPath = this.config.getString(Keys.MEDIA_PATH);
        if (mediaPath != null) {
            ServletHolder servletHolder = new ServletHolder(ResourceServlet.class);
            servletHolder.setInitParameter("baseResource", Path.of(mediaPath, new String[0]).toUri().toString());
            servletHolder.setInitParameter("dirAllowed", "false");
            servletHolder.setInitParameter("pathInfoOnly", "true");
            servletHandler.addServlet(servletHolder, "/api/media/*");
        }
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.property("jersey.config.server.wadl.disableWadl", (Object)true);
        resourceConfig.registerClasses(new Class[]{JacksonFeature.class, ObjectMapperContextResolver.class, DateParameterConverterProvider.class, SecurityRequestFilter.class, CorsResponseFilter.class, ResourceErrorHandler.class, StreamWriter.class});
        resourceConfig.packages(new String[]{ServerResource.class.getPackage().getName()});
        if (resourceConfig.getClasses().stream().filter(ServerResource.class::equals).findAny().isEmpty()) {
            LOGGER.warn("Failed to load API resources");
        }
        servletHandler.addServlet(new ServletHolder((Servlet)new ServletContainer(resourceConfig)), "/api/*");
    }

    private void initSessionConfig(ServletContextHandler servletHandler) {
        String sameSiteCookie;
        SessionHandler sessionHandler = servletHandler.getSessionHandler();
        if (this.config.getBoolean(Keys.WEB_PERSIST_SESSION)) {
            DatabaseAdaptor databaseAdaptor = new DatabaseAdaptor();
            databaseAdaptor.setDatasource((DataSource)this.injector.getInstance(DataSource.class));
            JDBCSessionDataStoreFactory jdbcSessionDataStoreFactory = new JDBCSessionDataStoreFactory();
            jdbcSessionDataStoreFactory.setDatabaseAdaptor(databaseAdaptor);
            DefaultSessionCache sessionCache = new DefaultSessionCache((SessionManager)sessionHandler);
            sessionCache.setSessionDataStore(jdbcSessionDataStoreFactory.getSessionDataStore((SessionManager)sessionHandler));
            sessionHandler.setSessionCache((SessionCache)sessionCache);
        }
        SessionCookieConfig sessionCookieConfig = servletHandler.getServletContext().getSessionCookieConfig();
        int sessionTimeout = this.config.getInteger(Keys.WEB_SESSION_TIMEOUT);
        if (sessionTimeout > 0) {
            servletHandler.getSessionHandler().setMaxInactiveInterval(sessionTimeout);
            sessionCookieConfig.setMaxAge(sessionTimeout);
        }
        if ((sameSiteCookie = this.config.getString(Keys.WEB_SAME_SITE_COOKIE)) != null) {
            switch (sameSiteCookie.toLowerCase()) {
                case "lax": {
                    sessionHandler.setSameSite(HttpCookie.SameSite.LAX);
                    break;
                }
                case "strict": {
                    sessionHandler.setSameSite(HttpCookie.SameSite.STRICT);
                    break;
                }
                case "none": {
                    sessionCookieConfig.setSecure(true);
                    sessionHandler.setSameSite(HttpCookie.SameSite.NONE);
                    break;
                }
            }
        }
        sessionCookieConfig.setHttpOnly(true);
    }

    @Override
    public void start() throws Exception {
        this.server.start();
    }

    @Override
    public void stop() throws Exception {
        this.server.stop();
    }
}

