/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.traccar.config.Config;
import org.traccar.config.Keys;

@Singleton
public class EventLoopGroupFactory {
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;

    @Inject
    public EventLoopGroupFactory(Config config) {
        IoHandlerFactory ioHandlerFactory = NioIoHandler.newFactory();
        this.bossGroup = new MultiThreadIoEventLoopGroup(config.getInteger(Keys.SERVER_NETTY_BOSS_THREADS), ioHandlerFactory);
        this.workerGroup = new MultiThreadIoEventLoopGroup(config.getInteger(Keys.SERVER_NETTY_WORKER_THREADS), ioHandlerFactory);
    }

    public EventLoopGroup getBossGroup() {
        return this.bossGroup;
    }

    public EventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }
}

