/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.abort;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.abort.AbortData;
import org.pentaho.di.trans.steps.abort.AbortMeta;
import org.pentaho.di.trans.steps.abort.Messages;

public class Abort
extends BaseStep
implements StepInterface {
    private AbortMeta meta;
    private AbortData data;
    private int nrInputRows;
    private int nrThresholdRows;

    public Abort(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (AbortMeta)smi;
        this.data = (AbortData)sdi;
        if (super.init(smi, sdi)) {
            this.nrInputRows = 0;
            String threshold = this.environmentSubstitute(this.meta.getRowThreshold());
            this.nrThresholdRows = Const.toInt((String)threshold, (int)-1);
            if (this.nrThresholdRows < 0) {
                this.logError(Messages.getString("Abort.Log.ThresholdInvalid", threshold));
            }
            return true;
        }
        return false;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (AbortMeta)smi;
        this.data = (AbortData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        this.putRow(this.getInputRowMeta(), r);
        ++this.nrInputRows;
        if (this.nrInputRows > this.nrThresholdRows) {
            this.logMinimal(Messages.getString("Abort.Log.Wrote.AbortRow", Long.toString(this.nrInputRows), this.getInputRowMeta().getString(r)));
            String message = this.environmentSubstitute(this.meta.getMessage());
            if (message == null || message.length() == 0) {
                this.logMinimal(Messages.getString("Abort.Log.DefaultAbortMessage", "" + this.nrInputRows));
            } else {
                this.logMinimal(message);
            }
            this.setErrors(1L);
            this.stopAll();
        } else if (this.meta.isAlwaysLogRows()) {
            this.logMinimal(Messages.getString("Abort.Log.Wrote.Row", Long.toString(this.nrInputRows), this.getInputRowMeta().getString(r)));
        } else if (this.log.isRowLevel()) {
            this.logRowlevel(Messages.getString("Abort.Log.Wrote.Row", Long.toString(this.nrInputRows), this.getInputRowMeta().getString(r)));
        }
        return true;
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

