/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;

public class FirstContactMessage
extends AttributeMessage {
    public static final String TAG = "firstContact";
    private static final String CAMPS_TAG = "camps";
    private static final String OTHER_TAG = "other";
    private static final String PLAYER_TAG = "player";
    private static final String RESULT_TAG = "result";
    private static final String TILE_TAG = "tile";

    public FirstContactMessage(Player player, Player other, Tile tile) {
        super(TAG, PLAYER_TAG, player.getId(), OTHER_TAG, other.getId(), TILE_TAG, tile == null ? null : tile.getId(), CAMPS_TAG, other.isEuropean() ? null : String.valueOf(other.getSettlementCount()));
    }

    public FirstContactMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, PLAYER_TAG, OTHER_TAG, TILE_TAG, CAMPS_TAG, RESULT_TAG);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.EARLY;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
        ServerGame game = freeColServer.getGame();
        Player contactor = this.getPlayer(game);
        Player contactee = this.getOtherPlayer(game);
        Tile tile = this.getTile(game);
        aiPlayer.firstContactHandler(contactor, contactee, tile);
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Game game = freeColClient.getGame();
        Player player = this.getPlayer(game);
        Player other = this.getOtherPlayer(game);
        Tile tile = this.getTile(game);
        int n = this.getSettlementCount();
        if (player == null || player != freeColClient.getMyPlayer()) {
            logger.warning("firstContact with bad player: " + player);
            return;
        }
        if (other == null || other == player || !other.isIndian()) {
            logger.warning("firstContact with bad other player: " + other);
            return;
        }
        if (tile != null && tile.getOwner() != other) {
            logger.warning("firstContact with bad tile: " + tile);
            return;
        }
        this.igc(freeColClient).firstContactHandler(player, other, tile, n);
        this.clientGeneric(freeColClient);
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        ServerGame game = freeColServer.getGame();
        String playerId = this.getStringAttribute(PLAYER_TAG);
        String otherId = this.getStringAttribute(OTHER_TAG);
        Player first = this.getPlayer(game);
        if (first == null) {
            return serverPlayer.clientError("Invalid player: " + playerId);
        }
        if (!serverPlayer.getId().equals(playerId)) {
            return serverPlayer.clientError("Not our player: " + playerId);
        }
        Player otherPlayer = this.getOtherPlayer(game);
        if (otherPlayer == null) {
            return serverPlayer.clientError("Invalid other player: " + otherId);
        }
        if (otherPlayer == serverPlayer) {
            return serverPlayer.clientError("First contact with self!?!");
        }
        return this.igc(freeColServer).nativeFirstContact(serverPlayer, otherPlayer, this.getTile(game), this.getResult());
    }

    public Player getPlayer(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(PLAYER_TAG), Player.class);
    }

    public Player getOtherPlayer(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(OTHER_TAG), Player.class);
    }

    public Tile getTile(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(TILE_TAG), Tile.class);
    }

    public int getSettlementCount() {
        return this.getIntegerAttribute(CAMPS_TAG, -1);
    }

    public boolean getResult() {
        return this.getBooleanAttribute(RESULT_TAG, null);
    }

    public FirstContactMessage setResult(boolean result) {
        this.setBooleanAttribute(RESULT_TAG, result);
        return this;
    }
}

