/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public class UnloadGoodsMessage
extends AttributeMessage {
    public static final String TAG = "unloadGoods";
    private static final String AMOUNT_TAG = "amount";
    private static final String CARRIER_TAG = "carrier";
    private static final String TYPE_TAG = "type";

    public UnloadGoodsMessage(GoodsType goodsType, int amount, Unit carrier) {
        super(TAG, TYPE_TAG, goodsType.getId(), AMOUNT_TAG, String.valueOf(amount), CARRIER_TAG, carrier.getId());
    }

    public UnloadGoodsMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, TYPE_TAG, AMOUNT_TAG, CARRIER_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Unit carrier;
        Specification spec = freeColServer.getSpecification();
        String typeId = this.getStringAttribute(TYPE_TAG);
        int amount = this.getIntegerAttribute(AMOUNT_TAG, -1);
        String carrierId = this.getStringAttribute(CARRIER_TAG);
        try {
            carrier = serverPlayer.getOurFreeColGameObject(carrierId, Unit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        if (!carrier.canCarryGoods()) {
            return serverPlayer.clientError("Not a goods carrier: " + carrierId);
        }
        GoodsType type = spec.getGoodsType(typeId);
        if (type == null) {
            return serverPlayer.clientError("Not a goods type: " + typeId);
        }
        if (amount <= 0) {
            return serverPlayer.clientError("Invalid amount: " + amount);
        }
        int present = carrier.getGoodsCount(type);
        if (present < amount) {
            return serverPlayer.clientError("Attempt to unload " + amount + " " + type.getId() + " but only " + present + " present");
        }
        return this.igc(freeColServer).unloadGoods(serverPlayer, type, amount, carrier);
    }
}

