/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.internal;

import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import generic.theme.Gui;
import generic.theme.ThemeEvent;
import generic.theme.ThemeListener;
import ghidra.util.ColorUtils;
import java.awt.Color;

public class PaintContext {
    private Color background;
    private Color foreground;
    private Color selectionColor;
    private Color highlightColor;
    private Color selectedHighlightColor;
    private Color cursorColor;
    private Color focusedCursorColor;
    private Color notFocusedCursorColor;
    private Color invisibleCursorColor;
    private boolean printing = false;
    private boolean textCopying = false;
    private ThemeListener themeListener = this::themeChanged;

    public PaintContext() {
        this.background = new GColor("color.bg.fieldpanel");
        this.foreground = new GColor("color.fg.fieldpanel");
        this.selectionColor = new GColor("color.bg.fieldpanel.selection");
        this.highlightColor = new GColor("color.bg.fieldpanel.highlight");
        this.updateSelectedHighlightColor();
        this.focusedCursorColor = new GColor("color.cursor.focused");
        this.notFocusedCursorColor = new GColor("color.cursor.unfocused");
        this.cursorColor = this.focusedCursorColor;
        this.invisibleCursorColor = GThemeDefaults.Colors.Palette.NO_COLOR;
        Gui.addThemeListener((ThemeListener)this.themeListener);
    }

    private void themeChanged(ThemeEvent ev) {
        this.updateSelectedHighlightColor();
    }

    public final Color getBackground() {
        return this.background;
    }

    public final Color getForeground() {
        return this.foreground;
    }

    public final Color getSelectionColor() {
        return this.selectionColor;
    }

    public final Color getHighlightColor() {
        return this.highlightColor;
    }

    public final Color getSelectedHighlightColor() {
        return this.selectedHighlightColor;
    }

    public final Color getCursorColor() {
        return this.cursorColor;
    }

    public final Color getFocusedCursorColor() {
        return this.focusedCursorColor;
    }

    public void setSelectionColor(Color c) {
        this.selectionColor = c;
        this.updateSelectedHighlightColor();
    }

    public void setHighlightColor(Color c) {
        this.highlightColor = c;
        this.updateSelectedHighlightColor();
    }

    private void updateSelectedHighlightColor() {
        this.selectedHighlightColor = ColorUtils.addColors((Color)this.highlightColor, (Color)this.selectionColor);
    }

    public void setBackgroundColor(Color c) {
        this.background = c;
    }

    public void setForegroundColor(Color c) {
        this.foreground = c;
    }

    public void setCursorColor(Color c) {
        this.cursorColor = c;
        this.invisibleCursorColor = GThemeDefaults.Colors.Palette.NO_COLOR;
    }

    public boolean cursorHidden() {
        return this.cursorColor == this.invisibleCursorColor;
    }

    public boolean cursorFocused() {
        return this.cursorColor == this.focusedCursorColor;
    }

    public void setCursorFocused(boolean isFocused) {
        this.cursorColor = isFocused ? this.focusedCursorColor : this.notFocusedCursorColor;
    }

    public void setCursorHidden(boolean isHidden) {
        this.cursorColor = isHidden ? this.invisibleCursorColor : this.focusedCursorColor;
    }

    public void setFocusedCursorColor(Color color) {
        this.focusedCursorColor = color;
    }

    public void setNotFocusedCursorColor(Color color) {
        this.notFocusedCursorColor = color;
    }

    public Color getNotFocusedCursorColor() {
        return this.notFocusedCursorColor;
    }

    public void setPrinting(boolean b) {
        this.printing = b;
    }

    public void setTextCopying(boolean b) {
        this.textCopying = b;
    }

    public boolean isPrinting() {
        return this.printing;
    }

    public boolean isTextCopying() {
        return this.textCopying;
    }
}

