/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.task;

import generic.concurrent.GThreadPool;
import ghidra.util.TaskUtilities;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.util.concurrent.Executor;

class BackgroundThreadTaskLauncher {
    private Task task;

    BackgroundThreadTaskLauncher(Task task) {
        this.task = task;
    }

    void run(TaskMonitor monitor) {
        TaskUtilities.addTrackedTask((Task)this.task, (TaskMonitor)monitor);
        String name = "Task - " + this.task.getTaskTitle();
        GThreadPool pool = GThreadPool.getSharedThreadPool((String)"GSwing Worker");
        Executor executor = pool.getExecutor();
        executor.execute(() -> {
            Thread.currentThread().setName(name);
            this.task.monitoredRun(monitor);
        });
    }
}

