/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import docking.widgets.fieldpanel.field.AbstractTextFieldElement;
import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import generic.theme.GThemeDefaults;
import ghidra.app.decompiler.ClangToken;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;

public class ClangFieldElement
extends AbstractTextFieldElement {
    private final ClangToken token;

    public ClangFieldElement(ClangToken token, AttributedString as, int col) {
        super(as, 0, col);
        this.token = token;
    }

    ClangToken getToken() {
        return this.token;
    }

    public void paint(JComponent c, Graphics g, int x, int y) {
        Color highlightColor = this.token.getHighlight();
        if (highlightColor != null) {
            g.setColor(highlightColor);
            g.fillRect(x, y - this.getHeightAbove(), this.getStringWidth(), this.getHeightAbove() + this.getHeightBelow());
        }
        super.paint(c, g, x, y);
        if (this.token.isMatchingToken()) {
            g.setColor((Color)GThemeDefaults.Colors.Palette.GRAY);
            int offset = 1;
            g.drawRect(x - offset, y - this.getHeightAbove() - offset, this.getStringWidth() + offset * 2, this.getHeightAbove() + this.getHeightBelow() + offset * 2);
        }
    }

    public FieldElement substring(int start, int end) {
        AttributedString as = this.attributedString.substring(start, end);
        if (as == this.attributedString) {
            return this;
        }
        return new ClangFieldElement(this.token, as, this.column + start);
    }

    public FieldElement replaceAll(char[] targets, char replacement) {
        return new ClangFieldElement(this.token, this.attributedString.replaceAll(targets, replacement), this.column);
    }
}

