/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.util;

import ghidra.feature.vt.api.impl.VTRelatedMatchImpl;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationStatus;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.api.util.VTRelatedMatch;
import ghidra.feature.vt.gui.provider.relatedMatches.VTRelatedMatchCorrelationType;
import ghidra.feature.vt.gui.provider.relatedMatches.VTRelatedMatchType;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VTRelatedMatchUtil {
    public static Collection<VTRelatedMatch> getRelatedMatches(TaskMonitor monitor, VTSession session, VTMatch match) throws CancelledException {
        ArrayList<VTRelatedMatch> list = new ArrayList<VTRelatedMatch>();
        VTAssociation association = match.getAssociation();
        Program sourceProgram = session.getSourceProgram();
        Address sourceAddress = association.getSourceAddress();
        Function sourceFunction = sourceProgram.getListing().getFunctionAt(sourceAddress);
        if (sourceFunction == null) {
            return list;
        }
        Set<Address> sourceCallersOf = VTRelatedMatchUtil.getCallersOf(sourceFunction);
        Set<Address> sourceCalleesOf = VTRelatedMatchUtil.getCalleesOf(sourceFunction);
        Program destinationProgram = session.getDestinationProgram();
        Address destinationAddress = association.getDestinationAddress();
        Function destinationFunction = destinationProgram.getListing().getFunctionAt(destinationAddress);
        Set<Address> destinationCallersOf = VTRelatedMatchUtil.getCallersOf(destinationFunction);
        Set<Address> destinationCalleesOf = VTRelatedMatchUtil.getCalleesOf(destinationFunction);
        Listing sourceListing = sourceProgram.getListing();
        Listing destinationListing = destinationProgram.getListing();
        int matchCount = VTRelatedMatchUtil.getMatchCount(session);
        monitor.setMessage("Searching for related matches");
        monitor.initialize((long)matchCount);
        List<VTMatchSet> matchSets = session.getMatchSets();
        for (VTMatchSet matchSet : matchSets) {
            Collection<VTMatch> matches = matchSet.getMatches();
            for (VTMatch otherMatch : matches) {
                monitor.checkCancelled();
                VTAssociation otherAssociation = otherMatch.getAssociation();
                VTAssociationStatus associationStatus = otherAssociation.getStatus();
                Address otherSourceAddress = otherAssociation.getSourceAddress();
                Address otherDestinationAddress = otherAssociation.getDestinationAddress();
                VTRelatedMatchCorrelationType sourceCorrelationType = sourceCallersOf.contains(otherSourceAddress) ? VTRelatedMatchCorrelationType.CALLER : (sourceCalleesOf.contains(otherSourceAddress) ? VTRelatedMatchCorrelationType.CALLEE : (otherSourceAddress.equals((Object)sourceAddress) ? VTRelatedMatchCorrelationType.TARGET : VTRelatedMatchCorrelationType.UNRELATED));
                VTRelatedMatchCorrelationType destinationCorrelationType = destinationCallersOf.contains(otherDestinationAddress) ? VTRelatedMatchCorrelationType.CALLER : (destinationCalleesOf.contains(otherDestinationAddress) ? VTRelatedMatchCorrelationType.CALLEE : (otherDestinationAddress.equals((Object)destinationAddress) ? VTRelatedMatchCorrelationType.TARGET : VTRelatedMatchCorrelationType.UNRELATED));
                VTRelatedMatchType relatedMatchType = VTRelatedMatchType.findMatchType(sourceCorrelationType, destinationCorrelationType, associationStatus);
                Function otherSourceFunction = sourceListing.getFunctionAt(otherSourceAddress);
                Function otherDestinationFunction = destinationListing.getFunctionAt(otherDestinationAddress);
                if (relatedMatchType != null && otherSourceFunction != null && otherDestinationFunction != null) {
                    list.add(new VTRelatedMatchImpl(relatedMatchType, otherSourceAddress, otherSourceFunction, otherDestinationAddress, otherDestinationFunction));
                }
                monitor.incrementProgress(1L);
            }
        }
        return list;
    }

    private static int getMatchCount(VTSession session) {
        List<VTMatchSet> matchSets = session.getMatchSets();
        int count = 0;
        for (VTMatchSet matchSet : matchSets) {
            count += matchSet.getMatchCount();
        }
        return count;
    }

    public static Set<Address> getCalleesOf(Function function) {
        HashSet<Address> result = new HashSet<Address>();
        ReferenceManager referenceManager = function.getProgram().getReferenceManager();
        AddressSetView body = function.getBody();
        AddressIterator iterator = referenceManager.getReferenceSourceIterator(body, true);
        while (iterator.hasNext()) {
            Reference[] referencesFrom;
            Address address = iterator.next();
            for (Reference reference : referencesFrom = referenceManager.getReferencesFrom(address)) {
                RefType refType = reference.getReferenceType();
                if (!refType.isCall()) continue;
                result.add(reference.getToAddress());
            }
        }
        return result;
    }

    public static Set<Address> getCallersOf(Function function) {
        HashSet<Address> result = new HashSet<Address>();
        ReferenceManager referenceManager = function.getProgram().getReferenceManager();
        Address entryPoint = function.getEntryPoint();
        ReferenceIterator referencesTo = referenceManager.getReferencesTo(entryPoint);
        Listing listing = function.getProgram().getListing();
        while (referencesTo.hasNext()) {
            Reference reference = referencesTo.next();
            Address fromAddress = reference.getFromAddress();
            Function referenceFunction = listing.getFunctionContaining(fromAddress);
            if (referenceFunction == null) continue;
            result.add(referenceFunction.getEntryPoint());
        }
        return result;
    }
}

