/*
 * Decompiled with CFR 0.152.
 */
package generic.hash;

import generic.hash.AbstractMessageDigest;
import ghidra.util.task.TaskMonitor;

public class FNV1a32MessageDigest
extends AbstractMessageDigest {
    public static final int FNV_32_OFFSET_BASIS = -2128831035;
    public static final int FNV_32_PRIME = 16777619;
    private int hashvalue;

    public FNV1a32MessageDigest(int initialVector) {
        super("FNV-1a", 4);
        this.hashvalue = initialVector;
    }

    public FNV1a32MessageDigest() {
        super("FNV-1a", 4);
        this.init();
    }

    private void init() {
        this.hashvalue = -2128831035;
    }

    @Override
    public void update(byte[] input, int offset, int len) {
        for (int ii = 0; ii < len; ++ii) {
            this.hashvalue ^= input[offset++] & 0xFF;
            this.hashvalue *= 16777619;
        }
    }

    @Override
    public void update(byte[] input, int offset, int len, TaskMonitor monitor) {
        for (int ii = 0; !(ii >= len || ii % 1000000 == 0 && monitor.isCancelled()); ++ii) {
            this.hashvalue ^= input[offset++] & 0xFF;
            this.hashvalue *= 16777619;
        }
    }

    @Override
    public void update(byte input) {
        this.hashvalue ^= input & 0xFF;
        this.hashvalue *= 16777619;
    }

    @Override
    public int digest(byte[] buf, int offset, int len) {
        if (buf.length < 4 || len < 4) {
            offset += len - 1;
            this.hashvalue >>= 8 * (4 - len);
            for (int ii = 0; ii < len; ++ii) {
                buf[offset--] = (byte)(this.hashvalue & 0xFF);
                this.hashvalue >>= 8;
            }
            this.init();
            return len;
        }
        offset += 3;
        buf[offset--] = (byte)(this.hashvalue & 0xFF);
        this.hashvalue >>= 8;
        buf[offset--] = (byte)(this.hashvalue & 0xFF);
        this.hashvalue >>= 8;
        buf[offset--] = (byte)(this.hashvalue & 0xFF);
        this.hashvalue >>= 8;
        buf[offset--] = (byte)(this.hashvalue & 0xFF);
        this.init();
        return 4;
    }

    @Override
    public long digestLong() {
        long result = (long)this.hashvalue & 0xFFFFFFFFL;
        this.init();
        return result;
    }

    @Override
    public void reset() {
        this.init();
    }
}

