/*
 * Decompiled with CFR 0.152.
 */
package javaslang.match.model;

import java.util.List;
import java.util.stream.Collectors;
import javaslang.match.model.MethodModel;
import javaslang.match.model.TypeParameterModel;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

public class ClassModel {
    private final Elements elementUtils;
    private final DeclaredType declaredType;

    public static ClassModel of(Elements elementUtils, TypeElement typeElement) {
        return new ClassModel(elementUtils, (DeclaredType)typeElement.asType());
    }

    public ClassModel(Elements elementUtils, DeclaredType declaredType) {
        this.elementUtils = elementUtils;
        this.declaredType = declaredType;
    }

    public TypeElement typeElement() {
        return (TypeElement)this.declaredType.asElement();
    }

    public String getClassName() {
        String fqn = this.getFullQualifiedName();
        return this.hasDefaultPackage() ? fqn : fqn.substring(this.getPackageName().length() + 1);
    }

    public String getFullQualifiedName() {
        return this.typeElement().getQualifiedName().toString();
    }

    public List<MethodModel> getMethods() {
        return this.typeElement().getEnclosedElements().stream().filter(element -> {
            String name2 = element.getSimpleName().toString();
            return element instanceof ExecutableElement && !name2.isEmpty() && !"<init>".equals(name2) && !"<clinit>".equals(name2);
        }).map(element -> new MethodModel(this.elementUtils, (ExecutableElement)element)).collect(Collectors.toList());
    }

    public String getPackageName() {
        return this.elementUtils.getPackageOf(this.typeElement()).getQualifiedName().toString();
    }

    public List<TypeParameterModel> getTypeParameters() {
        return this.declaredType.getTypeArguments().stream().map(typeMirror -> new TypeParameterModel(this.elementUtils, (TypeMirror)typeMirror)).collect(Collectors.toList());
    }

    public boolean hasDefaultPackage() {
        return this.elementUtils.getPackageOf(this.typeElement()).isUnnamed();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof ClassModel && this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.declaredType.toString();
    }
}

