/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.util.Addresses;

final class RemoteHostId {
    private final byte[] _ip;
    private final int _port;
    private final Hash _peerHash;
    private final int _hashCode;

    public RemoteHostId(byte[] ip, int port) {
        this(ip, port, null);
    }

    public RemoteHostId(Hash peerHash) {
        this(null, 0, peerHash);
    }

    private RemoteHostId(byte[] ip, int port, Hash peerHash) {
        this._ip = ip;
        this._port = port;
        this._peerHash = peerHash;
        this._hashCode = DataHelper.hashCode(this._ip) ^ DataHelper.hashCode(this._peerHash) ^ this._port;
    }

    public byte[] getIP() {
        return this._ip;
    }

    public int getPort() {
        return this._port;
    }

    public Hash getPeerHash() {
        return this._peerHash;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoteHostId)) {
            return false;
        }
        RemoteHostId id = (RemoteHostId)obj;
        return this._port == id._port && DataHelper.eq(this._ip, id._ip) && DataHelper.eq(this._peerHash, id._peerHash);
    }

    public String toString() {
        if (this._ip != null) {
            return Addresses.toString(this._ip, this._port);
        }
        return this._peerHash.toBase64();
    }
}

