/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.ssdp;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import org.cybergarage.net.HostInterface;
import org.cybergarage.upnp.device.SearchListener;
import org.cybergarage.upnp.ssdp.HTTPMUSocket;
import org.cybergarage.upnp.ssdp.SSDP;
import org.cybergarage.upnp.ssdp.SSDPPacket;
import org.cybergarage.util.ListenerList;

public class SSDPSearchSocket
extends HTTPMUSocket
implements Runnable {
    private boolean useIPv6Address;
    private ListenerList deviceSearchListenerList = new ListenerList();
    private Thread deviceSearchThread = null;

    public SSDPSearchSocket(String bindAddr, int port, String multicast) throws IOException {
        boolean ok = this.open(bindAddr, multicast);
        if (!ok) {
            throw new IOException("Bind to " + bindAddr + " failed");
        }
    }

    public SSDPSearchSocket(InetAddress bindAddr) throws IOException {
        boolean ok = bindAddr.getAddress().length != 4 ? this.open((Inet6Address)bindAddr) : this.open((Inet4Address)bindAddr);
        if (!ok) {
            throw new IOException("Bind to " + bindAddr + " failed");
        }
    }

    public boolean open(Inet4Address bindAddr) {
        this.useIPv6Address = false;
        return this.open("239.255.255.250", 1900, bindAddr);
    }

    public boolean open(Inet6Address bindAddr) {
        this.useIPv6Address = true;
        return this.open(SSDP.getIPv6Address(), 1900, bindAddr);
    }

    public boolean open(String bind, String multicast) {
        if (HostInterface.isIPv6Address(bind) && HostInterface.isIPv6Address(multicast)) {
            this.useIPv6Address = true;
        } else if (HostInterface.isIPv4Address(bind) && HostInterface.isIPv4Address(multicast)) {
            this.useIPv6Address = false;
        } else {
            throw new IllegalArgumentException("Cannot open a UDP Socket for IPv6 address on IPv4 interface or viceversa");
        }
        return this.open(multicast, 1900, bind);
    }

    public boolean open(String bindAddr) {
        String addr = "239.255.255.250";
        this.useIPv6Address = false;
        if (HostInterface.isIPv6Address(bindAddr)) {
            addr = SSDP.getIPv6Address();
            this.useIPv6Address = true;
        }
        return this.open(addr, 1900, bindAddr);
    }

    public void addSearchListener(SearchListener listener) {
        this.deviceSearchListenerList.add(listener);
    }

    public void removeSearchListener(SearchListener listener) {
        this.deviceSearchListenerList.remove(listener);
    }

    public void performSearchListener(SSDPPacket ssdpPacket) {
        int listenerSize = this.deviceSearchListenerList.size();
        for (int n = 0; n < listenerSize; ++n) {
            SearchListener listener = (SearchListener)this.deviceSearchListenerList.get(n);
            listener.deviceSearchReceived(ssdpPacket);
        }
    }

    @Override
    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.deviceSearchThread == thisThread) {
            Thread.yield();
            SSDPPacket packet = null;
            try {
                packet = this.receive();
            }
            catch (IOException e) {
                break;
            }
            if (packet == null || !packet.isDiscover()) continue;
            this.performSearchListener(packet);
        }
    }

    public void start() {
        StringBuffer name = new StringBuffer("Cyber.SSDPSearchSocket/");
        String localAddr = this.getLocalAddress();
        if (localAddr != null && 0 < localAddr.length()) {
            name.append(this.getMulticastAddress()).append(':');
            name.append(this.getMulticastPort());
        }
        this.deviceSearchThread = new Thread((Runnable)this, name.toString());
        this.deviceSearchThread.start();
    }

    public void stop() {
        this.close();
        this.deviceSearchThread = null;
    }
}

