/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.prng;

import gnu.crypto.prng.BasePRNGStandalone;
import gnu.crypto.prng.DevRandom;
import gnu.crypto.prng.IRandomStandalone;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Map;
import net.i2p.crypto.CryptixAESKeyCache;
import net.i2p.crypto.CryptixRijndael_Algorithm;
import net.i2p.crypto.SHA256Generator;

public class FortunaStandalone
extends BasePRNGStandalone
implements Serializable {
    private static final long serialVersionUID = 16435934L;
    private static final int SEED_FILE_SIZE = 64;
    static final int NUM_POOLS = 32;
    static final int MIN_POOL_SIZE = 64;
    protected final IRandomStandalone generator;
    protected final MessageDigest[] pools;
    protected long lastReseed;
    private int pool;
    protected int pool0Count;
    protected int reseedCount;
    public static final String SEED = "gnu.crypto.prng.fortuna.seed";

    public FortunaStandalone() {
        this(false);
    }

    public FortunaStandalone(boolean useDevRandom) {
        super("Fortuna i2p");
        if (useDevRandom && !DevRandom.isSupported()) {
            useDevRandom = false;
        }
        IRandomStandalone iRandomStandalone = this.generator = useDevRandom ? new DevRandom() : new Generator();
        if (useDevRandom) {
            this.pools = null;
        } else {
            this.pools = new MessageDigest[32];
            for (int i = 0; i < 32; ++i) {
                this.pools[i] = SHA256Generator.getDigestInstance();
            }
        }
    }

    public void seed(byte[] val) {
        throw new UnsupportedOperationException("use override");
    }

    @Override
    public void setup(Map<String, byte[]> attributes) {
        this.lastReseed = 0L;
        this.reseedCount = 0;
        this.pool = 0;
        this.pool0Count = 0;
        this.generator.init(attributes);
    }

    @Override
    public void fillBlock() {
        throw new UnsupportedOperationException("use override");
    }

    @Override
    public void addRandomByte(byte b) {
        if (this.pools == null) {
            return;
        }
        this.pools[this.pool].update(b);
        if (this.pool == 0) {
            ++this.pool0Count;
        }
        this.pool = (this.pool + 1) % 32;
    }

    @Override
    public void addRandomBytes(byte[] buf, int offset, int length) {
        if (this.pools == null) {
            return;
        }
        this.pools[this.pool].update(buf, offset, length);
        if (this.pool == 0) {
            this.pool0Count += length;
        }
        this.pool = (this.pool + 1) % 32;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        byte[] seed = new byte[64];
        this.generator.nextBytes(seed);
        out.write(seed);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        byte[] seed = new byte[64];
        in.readFully(seed);
        this.generator.addRandomBytes(seed);
    }

    private static class Generator
    extends BasePRNGStandalone
    implements Cloneable {
        private static final int LIMIT = 0x100000;
        private final MessageDigest hash = SHA256Generator.getDigestInstance();
        private final byte[] counter = new byte[16];
        private final byte[] key;
        private Object cryptixKey;
        private CryptixAESKeyCache.KeyCacheEntry cryptixKeyBuf;
        private boolean seeded;

        public Generator() {
            super("Fortuna.generator.i2p");
            this.buffer = new byte[16];
            int keysize = 32;
            this.key = new byte[keysize];
            this.cryptixKeyBuf = CryptixAESKeyCache.createNew();
        }

        @Override
        public final byte nextByte() {
            byte[] b = new byte[1];
            this.nextBytes(b, 0, 1);
            return b[0];
        }

        @Override
        public final void nextBytes(byte[] out, int offset, int length) {
            if (!this.seeded) {
                throw new IllegalStateException("generator not seeded");
            }
            int count = 0;
            do {
                int amount = Math.min(0x100000, length - count);
                super.nextBytes(out, offset + count, amount);
                count += amount;
                for (int i = 0; i < this.key.length; i += this.counter.length) {
                    CryptixRijndael_Algorithm.blockEncrypt(this.counter, this.buffer, 0, 0, this.cryptixKey);
                    this.incrementCounter();
                    int l = Math.min(this.key.length - i, 16);
                    System.arraycopy(this.buffer, 0, this.key, i, l);
                }
                this.resetKey();
            } while (count < length);
            CryptixRijndael_Algorithm.blockEncrypt(this.counter, this.buffer, 0, 0, this.cryptixKey);
            this.incrementCounter();
            this.ndx = 0;
        }

        @Override
        public final void addRandomByte(byte b) {
            this.addRandomBytes(new byte[]{b});
        }

        @Override
        public final void addRandomBytes(byte[] seed, int offset, int length) {
            this.hash.update(this.key, 0, this.key.length);
            this.hash.update(seed, offset, length);
            byte[] newkey = this.hash.digest();
            System.arraycopy(newkey, 0, this.key, 0, Math.min(this.key.length, newkey.length));
            this.resetKey();
            this.incrementCounter();
            this.seeded = true;
        }

        @Override
        public final void fillBlock() {
            CryptixRijndael_Algorithm.blockEncrypt(this.counter, this.buffer, 0, 0, this.cryptixKey);
            this.incrementCounter();
        }

        @Override
        public void setup(Map<String, byte[]> attributes) {
            this.seeded = false;
            Arrays.fill(this.key, (byte)0);
            Arrays.fill(this.counter, (byte)0);
            byte[] seed = attributes.get(FortunaStandalone.SEED);
            if (seed != null) {
                this.addRandomBytes(seed);
            }
        }

        private final void resetKey() {
            try {
                this.cryptixKey = CryptixRijndael_Algorithm.makeKey(this.key, 16, this.cryptixKeyBuf);
            }
            catch (InvalidKeyException ike) {
                throw new Error("hrmf", ike);
            }
        }

        private final void incrementCounter() {
            for (int i = 0; i < this.counter.length; ++i) {
                int n = i;
                this.counter[n] = (byte)(this.counter[n] + 1);
                if (this.counter[i] != 0) break;
            }
        }
    }
}

