/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.edns;

import java.io.DataOutputStream;
import java.io.IOException;
import org.minidns.edns.Edns;
import org.minidns.edns.Nsid;
import org.minidns.edns.UnknownEdnsOption;

public abstract class EdnsOption {
    public final int optionCode;
    public final int optionLength;
    protected final byte[] optionData;
    private String toStringCache;
    private String terminalOutputCache;

    protected EdnsOption(int optionCode, byte[] optionData) {
        this.optionCode = optionCode;
        this.optionLength = optionData.length;
        this.optionData = optionData;
    }

    protected EdnsOption(byte[] optionData) {
        this.optionCode = this.getOptionCode().asInt;
        this.optionLength = optionData.length;
        this.optionData = optionData;
    }

    public final void writeToDos(DataOutputStream dos) throws IOException {
        dos.writeShort(this.optionCode);
        dos.writeShort(this.optionLength);
        dos.write(this.optionData);
    }

    public abstract Edns.OptionCode getOptionCode();

    public final String toString() {
        if (this.toStringCache == null) {
            this.toStringCache = this.toStringInternal().toString();
        }
        return this.toStringCache;
    }

    protected abstract CharSequence toStringInternal();

    public final String asTerminalOutput() {
        if (this.terminalOutputCache == null) {
            this.terminalOutputCache = this.asTerminalOutputInternal().toString();
        }
        return this.terminalOutputCache;
    }

    protected abstract CharSequence asTerminalOutputInternal();

    public static EdnsOption parse(int intOptionCode, byte[] optionData) {
        EdnsOption res;
        Edns.OptionCode optionCode = Edns.OptionCode.from(intOptionCode);
        switch (optionCode) {
            case NSID: {
                res = new Nsid(optionData);
                break;
            }
            default: {
                res = new UnknownEdnsOption(intOptionCode, optionData);
            }
        }
        return res;
    }
}

