/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.ArrayList;
import java.util.List;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.PendingGatewayMessage;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;

abstract class TunnelGateway {
    protected final RouterContext _context;
    protected final Log _log;
    protected final List<PendingGatewayMessage> _queue;
    protected final QueuePreprocessor _preprocessor;
    protected final Sender _sender;
    protected final Receiver _receiver;
    protected long _lastFlush;
    protected final DelayedFlush _delayedFlush;
    protected int _messagesSent;

    protected TunnelGateway(RouterContext context, QueuePreprocessor preprocessor, Sender sender, Receiver receiver) {
        this._context = context;
        this._log = context.logManager().getLog(this.getClass());
        this._queue = new ArrayList<PendingGatewayMessage>(4);
        this._preprocessor = preprocessor;
        this._sender = sender;
        this._receiver = receiver;
        this._delayedFlush = new DelayedFlush();
        this._lastFlush = this._context.clock().now();
    }

    public void add(TunnelGatewayMessage msg) {
        this.add(msg.getMessage(), null, null);
    }

    public void add(I2NPMessage msg, Hash toRouter, TunnelId toTunnel) {
        throw new UnsupportedOperationException("unused, right?");
    }

    public int getMessagesSent() {
        return this._messagesSent;
    }

    public static interface QueuePreprocessor {
        public boolean preprocessQueue(List<PendingGatewayMessage> var1, Sender var2, Receiver var3);

        public long getDelayAmount();
    }

    public static interface Sender {
        public long sendPreprocessed(byte[] var1, Receiver var2);
    }

    public static interface Receiver {
        public long receiveEncrypted(byte[] var1);

        public Hash getSendTo();
    }

    protected class DelayedFlush
    extends SimpleTimer2.TimedEvent {
        DelayedFlush() {
            super(TunnelGateway.this._context.simpleTimer2());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timeReached() {
            boolean wantRequeue = false;
            long delayAmount = -1L;
            List<PendingGatewayMessage> list = TunnelGateway.this._queue;
            synchronized (list) {
                if (!TunnelGateway.this._queue.isEmpty() && (wantRequeue = TunnelGateway.this._preprocessor.preprocessQueue(TunnelGateway.this._queue, TunnelGateway.this._sender, TunnelGateway.this._receiver))) {
                    delayAmount = TunnelGateway.this._preprocessor.getDelayAmount();
                    if (TunnelGateway.this._log.shouldLog(10)) {
                        TunnelGateway.this._log.debug("Remaining after delayed flush preprocessing: " + TunnelGateway.this._queue);
                    }
                }
            }
            if (wantRequeue) {
                this.schedule(delayAmount);
            } else {
                TunnelGateway.this._lastFlush = TunnelGateway.this._context.clock().now();
            }
        }
    }
}

