/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.i2p.client.streaming.I2PSocketEepGet;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.data.DataHelper;
import net.i2p.util.EepGet;
import org.klomp.snark.BandwidthListener;
import org.klomp.snark.BitField;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.MagnetState;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.PartialPiece;
import org.klomp.snark.Peer;
import org.klomp.snark.PeerCoordinator;
import org.klomp.snark.PeerID;
import org.klomp.snark.PeerListener;
import org.klomp.snark.Request;
import org.klomp.snark.URIUtil;

class WebPeer
extends Peer
implements EepGet.StatusListener {
    private final PeerCoordinator _coordinator;
    private final URI _uri;
    private final List<Request> outstandingRequests = new ArrayList<Request>();
    private final boolean isMultiFile;
    private Request lastRequest;
    private PeerListener listener;
    private BitField bitfield;
    private Thread thread;
    private boolean connected;
    private long lastRcvd;
    private int maxRequests;
    public static final byte[] IDBytes = DataHelper.getASCII("WebSeedBEP19");
    private static final long HEADER_TIMEOUT = 60000L;
    private static final long TOTAL_TIMEOUT = 600000L;
    private static final long INACTIVITY_TIMEOUT = 120000L;
    private static final long TARGET_FETCH_TIME = 120000L;
    private static final int ABSOLUTE_MIN_REQUESTS = 8;
    private static final int ABSOLUTE_MAX_REQUESTS = 128;
    private final int MIN_REQUESTS;
    private final int MAX_REQUESTS;

    public WebPeer(PeerCoordinator coord, URI uri, PeerID peerID, MetaInfo metainfo) {
        super(peerID, null, null, metainfo);
        this.MAX_REQUESTS = Math.max(1, Math.min(128, metainfo.getPieceLength(0) / 16384));
        this.maxRequests = this.MIN_REQUESTS = Math.min(8, this.MAX_REQUESTS);
        this.isMultiFile = metainfo.getLengths() != null;
        this._coordinator = coord;
        this._uri = uri;
    }

    @Override
    public String toString() {
        return "WebSeed " + this._uri;
    }

    @Override
    public synchronized String getSocket() {
        return this.toString() + ' ' + this.outstandingRequests.toString();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof WebPeer) {
            WebPeer p = (WebPeer)o;
            return this.getPeerID().equals(p.getPeerID());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void runConnection(I2PSnarkUtil util, PeerListener listener, BandwidthListener bwl, BitField ignore, MagnetState mState, boolean uploadOnly) {
        if (uploadOnly) {
            return;
        }
        boolean fails = false;
        int successes = 0;
        long dl = 0L;
        boolean notify = true;
        ByteArrayOutputStream out = null;
        ArrayList<Request> requests = new ArrayList<Request>(8);
        try {
            I2PSocketEepGet get;
            String url;
            block79: {
                Iterator iter;
                DataInputStream dis;
                boolean ok;
                if (!util.connected() && !(ok = util.connect())) {
                    return;
                }
                block41: while (true) {
                    PartialPiece pp;
                    Object pcs;
                    I2PSocketManager mgr;
                    if ((mgr = util.getSocketManager()) != null) {
                        if (notify) {
                            pcs = this;
                            synchronized (pcs) {
                                this.listener = listener;
                                this.bitfield = new BitField(this.metainfo.getPieces());
                                this.bitfield.setAll();
                                this.thread = Thread.currentThread();
                                this.connected = true;
                            }
                            listener.connected(this);
                            boolean want = listener.gotBitField(this, this.bitfield);
                            if (!want) {
                                return;
                            }
                            listener.gotChoke(this, false);
                            notify = false;
                        }
                        WebPeer want = this;
                        synchronized (want) {
                            if (!requests.isEmpty()) {
                                this.outstandingRequests.removeAll(requests);
                                requests.clear();
                            }
                            this.addRequest();
                            if (this._log.shouldDebug()) {
                                this._log.debug("Requests: " + this.outstandingRequests);
                            }
                        }
                    } else {
                        pcs = this.returnPartialPieces();
                        WebPeer webPeer = this;
                        synchronized (webPeer) {
                            this.connected = false;
                            this.outstandingRequests.clear();
                        }
                        requests.clear();
                        if (!pcs.isEmpty()) {
                            listener.savePartialPieces(this, (List<Request>)pcs);
                        }
                        listener.disconnected(this);
                        this.disconnect();
                        if (!this._log.shouldWarn()) return;
                        this._log.warn("Completed, successful fetches: " + successes + " downloaded: " + dl + " for " + this);
                        return;
                    }
                    {
                        while (this.outstandingRequests.isEmpty()) {
                            if (this._coordinator.getNeededLength() <= 0L) {
                                if (!this._log.shouldDebug()) return;
                                this._log.debug("Complete: " + this);
                                return;
                            }
                            if (this._log.shouldDebug()) {
                                this._log.debug("No requests, sleeping: " + this);
                            }
                            this.connected = false;
                            out = null;
                            try {
                                this.wait();
                            }
                            catch (InterruptedException ie) {
                                if (!this._log.shouldWarn()) return;
                                this._log.warn("Interrupted: " + this, ie);
                                return;
                            }
                        }
                        this.connected = true;
                        this.lastRequest = this.outstandingRequests.get(0);
                        requests.add(this.lastRequest);
                        int piece = this.lastRequest.getPiece();
                        for (int i = 1; i < this.outstandingRequests.size() && i < this.maxRequests; ++i) {
                            Request r = this.outstandingRequests.get(i);
                            if (!this.shouldRequest(r.len)) break;
                            if (r.getPiece() != piece || this.lastRequest.off + this.lastRequest.len != r.off) continue;
                            requests.add(r);
                            this.lastRequest = r;
                        }
                    }
                    Request first = (Request)requests.get(0);
                    Request last = (Request)requests.get(requests.size() - 1);
                    int piece = first.getPiece();
                    int off = first.off;
                    long toff = (long)piece * (long)this.metainfo.getPieceLength(0) + (long)off;
                    int tlen = last.off - first.off + last.len;
                    long start = System.currentTimeMillis();
                    if (out == null) {
                        out = new ByteArrayOutputStream(tlen);
                    } else {
                        out.reset();
                    }
                    int filenum = -1;
                    while (out.size() < tlen) {
                        long foff;
                        int flen;
                        block84: {
                            long limit;
                            block83: {
                                long filelen;
                                long fend;
                                long fstart;
                                List<Long> lengths;
                                block82: {
                                    block80: {
                                        block81: {
                                            flen = tlen - out.size();
                                            if (!this.isMultiFile) break block80;
                                            lengths = this.metainfo.getLengths();
                                            limit = 0L;
                                            if (filenum >= 0) break block81;
                                            fstart = 0L;
                                            fend = 0L;
                                            foff = 0L;
                                            break block82;
                                        }
                                        foff = 0L;
                                        limit = lengths.get(++filenum);
                                        break block83;
                                    }
                                    String uri = this._uri.toString();
                                    url = uri.endsWith("/") ? uri + URIUtil.encodePath(this.metainfo.getName()) : uri;
                                    foff = toff;
                                    flen = tlen;
                                    break block84;
                                }
                                for (int f = 0; f < lengths.size(); fstart += filelen, ++f) {
                                    filelen = lengths.get(f);
                                    fend = fstart + filelen;
                                    if (toff >= fend) continue;
                                    filenum = f;
                                    foff = toff - fstart;
                                    limit = fend - toff;
                                    break;
                                }
                                if (filenum < 0) {
                                    throw new IllegalStateException(this.lastRequest.toString());
                                }
                            }
                            if (limit > 0L && (long)flen > limit) {
                                flen = (int)limit;
                            }
                            if (this.metainfo.isPaddingFile(filenum)) {
                                for (int i = 0; i < flen; ++i) {
                                    out.write(0);
                                }
                                if (!this._log.shouldDebug()) continue;
                                this._log.debug("Skipped padding file " + filenum);
                                continue;
                            }
                            String uri = this._uri.toString();
                            Comparable<StringBuilder> buf = new StringBuilder(uri.length() + 128);
                            buf.append(uri);
                            if (!uri.endsWith("/")) {
                                buf.append('/');
                            }
                            URIUtil.encodePath(buf, this.metainfo.getName());
                            List<String> path = this.metainfo.getFiles().get(filenum);
                            for (int i = 0; i < path.size(); ++i) {
                                buf.append('/');
                                URIUtil.encodePath(buf, path.get(i));
                            }
                            url = buf.toString();
                        }
                        get = new I2PSocketEepGet(util.getContext(), mgr, 0, (long)flen, (long)flen, null, out, url);
                        get.addHeader("User-Agent", "I2PSnark");
                        get.addHeader("Range", "bytes=" + foff + '-' + (foff + (long)flen - 1L));
                        get.addStatusListener(this);
                        int osz = out.size();
                        if (this._log.shouldDebug()) {
                            this._log.debug("Fetching piece: " + piece + " offset: " + off + " file offset: " + foff + " len: " + flen + " from " + url);
                        }
                        if (((EepGet)get).fetch(60000L, 600000L, 120000L)) {
                            int resp = get.getStatusCode();
                            if (resp != 200 && resp != 206) {
                                this.fail(url, resp);
                                return;
                            }
                            int sz = out.size() - osz;
                            if (sz != flen) {
                                if (!this._log.shouldWarn()) return;
                                this._log.warn("Fetch of " + url + " received: " + sz + " expected: " + flen);
                                return;
                            }
                            ++successes;
                            dl += (long)flen;
                            if (this.isMultiFile) continue;
                            break;
                        }
                        if (out.size() > 0) {
                            dis = new DataInputStream(new ByteArrayInputStream(out.toByteArray()));
                            iter = requests.iterator();
                            break block41;
                        }
                        break block79;
                    }
                    if (this._log.shouldDebug()) {
                        this._log.debug("Fetch of piece: " + piece + " chunks: " + requests.size() + " offset: " + off + " torrent offset: " + toff + " len: " + tlen + " successful");
                    }
                    DataInputStream dis2 = new DataInputStream(new ByteArrayInputStream(out.toByteArray()));
                    for (Request request : requests) {
                        request.read(dis2, this);
                    }
                    PartialPiece partialPiece = pp = last.getPartialPiece();
                    synchronized (partialPiece) {
                        if (pp.isComplete()) {
                            if (!listener.gotPiece(this, pp)) {
                                if (!this._log.shouldWarn()) return;
                                this._log.warn("Got BAD " + piece + " from " + this);
                                return;
                            }
                            if (this._log.shouldDebug()) {
                                this._log.debug("Got " + piece + ": " + this);
                            }
                        }
                    }
                    long l = this.lastRcvd - start;
                    if (l < 120000L) {
                        this.maxRequests = Math.min(this.MAX_REQUESTS, 2 * this.maxRequests);
                        continue;
                    }
                    if (l <= 240000L) continue;
                    this.maxRequests = Math.max(this.MIN_REQUESTS, this.maxRequests / 2);
                }
                while (iter.hasNext()) {
                    Request req = (Request)iter.next();
                    if (dis.available() < req.len) break;
                    req.read(dis, this);
                    iter.remove();
                    if (!this._log.shouldWarn()) continue;
                    this._log.warn("Saved chunk " + req + " recvd before failure");
                }
            }
            int resp = get.getStatusCode();
            this.fail(url, resp);
            return;
        }
        catch (IOException eofe) {
            if (!this._log.shouldWarn()) return;
            this._log.warn(this.toString(), eofe);
            return;
        }
        finally {
            List<Request> pcs = this.returnPartialPieces();
            WebPeer webPeer = this;
            synchronized (webPeer) {
                this.connected = false;
                this.outstandingRequests.clear();
            }
            requests.clear();
            if (!pcs.isEmpty()) {
                listener.savePartialPieces(this, pcs);
            }
            listener.disconnected(this);
            this.disconnect();
            if (this._log.shouldWarn()) {
                this._log.warn("Completed, successful fetches: " + successes + " downloaded: " + dl + " for " + this);
            }
        }
    }

    private void fail(String url, int resp) {
        if (this._log.shouldWarn()) {
            this._log.warn("Fetch of " + url + " failed, rc: " + resp);
        }
        if (resp == 301 || resp == 308 || resp == 401 || resp == 403 || resp == 404 || resp == 410 || resp == 414 || resp == 416 || resp == 451) {
            this._coordinator.banWebPeer(this._uri.getHost(), true);
            if (this._log.shouldWarn()) {
                this._log.warn("Permanently banning the webseed " + url);
            }
        } else if (resp == 429 || resp == 503) {
            this._coordinator.banWebPeer(this._uri.getHost(), false);
            if (this._log.shouldWarn()) {
                this._log.warn("Temporarily banning the webseed " + url);
            }
        }
    }

    @Override
    public int getMaxPipeline() {
        return this.maxRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        WebPeer webPeer = this;
        synchronized (webPeer) {
            return this.connected;
        }
    }

    @Override
    synchronized void disconnect() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    @Override
    public void have(int piece) {
    }

    @Override
    void cancel(int piece) {
    }

    @Override
    void request() {
        this.addRequest();
    }

    @Override
    public boolean isInterested() {
        return false;
    }

    @Override
    @Deprecated
    public void setInteresting(boolean interest) {
    }

    @Override
    public boolean isInteresting() {
        return true;
    }

    @Override
    public void setChoking(boolean choke) {
    }

    @Override
    public boolean isChoking() {
        return false;
    }

    @Override
    public boolean isChoked() {
        return false;
    }

    @Override
    public long getInactiveTime() {
        if (this.lastRcvd <= 0L) {
            return -1L;
        }
        long now = System.currentTimeMillis();
        return now - this.lastRcvd;
    }

    @Override
    public long getMaxInactiveTime() {
        return 480000L;
    }

    @Override
    public void keepAlive() {
    }

    @Override
    public void retransmitRequests() {
    }

    @Override
    public int completed() {
        return this.metainfo.getPieces();
    }

    @Override
    public boolean isCompleted() {
        return true;
    }

    @Override
    public boolean isWebPeer() {
        return false;
    }

    @Override
    public void downloaded(int size) {
        super.downloaded(size);
        this._coordinator.downloaded(size);
    }

    @Override
    public boolean shouldRequest(int size) {
        return this._coordinator.shouldRequest(this, size);
    }

    private synchronized void addRequest() {
        boolean more_pieces = true;
        while (more_pieces) {
            boolean isLastChunk;
            boolean bl = more_pieces = this.outstandingRequests.size() < this.getMaxPipeline();
            if (more_pieces && this.lastRequest == null) {
                more_pieces = this.requestNextPiece();
                continue;
            }
            if (!more_pieces) continue;
            int pieceLength = this.metainfo.getPieceLength(this.lastRequest.getPiece());
            boolean bl2 = isLastChunk = this.lastRequest.off + this.lastRequest.len == pieceLength;
            if (isLastChunk) {
                more_pieces = this.requestNextPiece();
                continue;
            }
            PartialPiece nextPiece = this.lastRequest.getPartialPiece();
            int nextBegin = this.lastRequest.off + 16384;
            int maxLength = pieceLength - nextBegin;
            int nextLength = maxLength > 16384 ? 16384 : maxLength;
            Request req = new Request(nextPiece, nextBegin, nextLength);
            this.outstandingRequests.add(req);
            this.lastRequest = req;
            if (!this.shouldRequest(maxLength)) continue;
            this.notifyAll();
        }
    }

    private synchronized boolean requestNextPiece() {
        PartialPiece pp = this.listener.getPartialPiece(this, this.bitfield);
        if (pp != null) {
            if (!this.getRequestedPieces().contains(pp.getPiece())) {
                Request r = pp.getRequest();
                this.outstandingRequests.add(r);
                this.lastRequest = r;
                if (this.shouldRequest(r.len)) {
                    this.notifyAll();
                }
                return true;
            }
            if (this._log.shouldLog(30)) {
                this._log.warn("Got dup from coord: " + pp);
            }
            pp.release();
        }
        if (this.outstandingRequests.isEmpty()) {
            this.lastRequest = null;
        }
        return false;
    }

    private synchronized Set<Integer> getRequestedPieces() {
        HashSet<Integer> rv = new HashSet<Integer>(this.outstandingRequests.size() + 1);
        for (Request req : this.outstandingRequests) {
            rv.add(req.getPiece());
        }
        return rv;
    }

    private synchronized int getFirstOutstandingRequest(int piece) {
        for (int i = 0; i < this.outstandingRequests.size(); ++i) {
            if (this.outstandingRequests.get(i).getPiece() != piece) continue;
            return i;
        }
        return -1;
    }

    private synchronized List<Request> returnPartialPieces() {
        Set<Integer> pcs = this.getRequestedPieces();
        ArrayList<Request> rv = new ArrayList<Request>(pcs.size());
        for (Integer p : pcs) {
            Request req = this.getLowestOutstandingRequest(p);
            if (req == null) continue;
            rv.add(req);
        }
        this.outstandingRequests.clear();
        return rv;
    }

    private synchronized Request getLowestOutstandingRequest(int piece) {
        Request rv = null;
        int lowest = Integer.MAX_VALUE;
        for (Request r : this.outstandingRequests) {
            if (r.getPiece() != piece || r.off >= lowest) continue;
            lowest = r.off;
            rv = r;
        }
        return rv;
    }

    @Override
    public void bytesTransferred(long alreadyTransferred, int currentWrite, long bytesTransferred, long bytesRemaining, String url) {
        this.lastRcvd = System.currentTimeMillis();
    }

    @Override
    public void attemptFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt, int numRetries, Exception cause) {
    }

    @Override
    public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
    }

    @Override
    public void transferFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt) {
    }

    @Override
    public void headerReceived(String url, int attemptNum, String key, String val) {
    }

    @Override
    public void attempting(String url) {
    }
}

