/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.prng;

import gnu.crypto.prng.IRandomStandalone;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.i2p.data.DataHelper;

class DevRandom
implements IRandomStandalone {
    private static final String F = "/dev/random";
    private final File file = new File("/dev/random");

    DevRandom() {
    }

    public static boolean isSupported() {
        return new File(F).canRead();
    }

    @Override
    public String name() {
        return F;
    }

    @Override
    public void init(Map<String, byte[]> attributes) {
        if (!DevRandom.isSupported()) {
            throw new IllegalStateException("Cannot open /dev/random");
        }
    }

    @Override
    public byte nextByte() {
        throw new IllegalStateException("unsupported");
    }

    @Override
    public void nextBytes(byte[] out) throws IllegalStateException {
        this.nextBytes(out, 0, out.length);
    }

    @Override
    public void nextBytes(byte[] out, int offset, int length) throws IllegalStateException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.file);
            DataHelper.read(in, out, offset, length);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Read failed /dev/random", ioe);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void addRandomByte(byte b) {
    }

    @Override
    public void addRandomBytes(byte[] in) {
    }

    @Override
    public void addRandomBytes(byte[] in, int offset, int length) {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

