/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.util.Clock;

public class Lease
extends DataStructureImpl {
    protected Hash _gateway;
    protected TunnelId _tunnelId;
    protected long _end;

    public Hash getGateway() {
        return this._gateway;
    }

    public void setGateway(Hash ident) {
        this._gateway = ident;
    }

    public TunnelId getTunnelId() {
        return this._tunnelId;
    }

    public void setTunnelId(TunnelId id) {
        this._tunnelId = id;
    }

    @Deprecated
    public Date getEndDate() {
        return new Date(this._end);
    }

    @Deprecated
    public void setEndDate(Date date) {
        this._end = date.getTime();
    }

    public long getEndTime() {
        return this._end;
    }

    public void setEndDate(long date) {
        this._end = date;
    }

    public boolean isExpired() {
        return this.isExpired(0L);
    }

    public boolean isExpired(long fudgeFactor) {
        return this._end < Clock.getInstance().now() - fudgeFactor;
    }

    @Override
    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this._gateway = Hash.create(in);
        this._tunnelId = new TunnelId();
        this._tunnelId.readBytes(in);
        this._end = DataHelper.readLong(in, 8);
    }

    @Override
    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._gateway == null || this._tunnelId == null) {
            throw new DataFormatException("Not enough data to write out a Lease");
        }
        this._gateway.writeBytes(out);
        this._tunnelId.writeBytes(out);
        DataHelper.writeLong(out, 8, this._end);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Lease)) {
            return false;
        }
        Lease lse = (Lease)object;
        return this._end == lse.getEndTime() && DataHelper.eq(this._tunnelId, lse.getTunnelId()) && DataHelper.eq(this._gateway, lse.getGateway());
    }

    public int hashCode() {
        return (int)this._end ^ DataHelper.hashCode(this._gateway) ^ DataHelper.hashCode(this._tunnelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("[Lease: ");
        buf.append("\n\tEnd Date: ").append(DataHelper.formatTime(this._end));
        buf.append("\n\tGateway: ").append(this._gateway);
        buf.append("\n\tTunnelId: ").append(this._tunnelId);
        buf.append("]");
        return buf.toString();
    }
}

