/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.GitSilentFileAdder;
import com.intellij.openapi.GitSilentFileAdderProvider;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.observation.ActivityKey;
import com.intellij.platform.backend.observation.TrackingUtil;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelResult;
import com.intellij.platform.eel.OwnedBuilder;
import com.intellij.platform.eel.fs.EelFileSystemApi;
import com.intellij.platform.eel.fs.EelFileSystemApiHelpersKt;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomModule;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomSubproject;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.statistics.MavenActionsUsagesCollector;
import org.jetbrains.idea.maven.utils.MavenActivityKey;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.NioFiles;
import org.jetbrains.idea.maven.wizards.MavenModuleBuilderHelper;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 /2\u00020\u0001:\u0002./Bb\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u0012\r\u0010\u000f\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\bH\u0016J \u0010 \u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\bH\u0016J\u0018\u0010!\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001eH\u0004J\u0010\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u001eH\u0004J\u001e\u0010(\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u001eH\u0082@\u00a2\u0006\u0002\u0010)J*\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,2\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010-\u001a\u0004\u0018\u00010\u000eH\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00060"}, d2={"Lorg/jetbrains/idea/maven/wizards/MavenModuleBuilderHelper;", "", "myProjectId", "Lorg/jetbrains/idea/maven/model/MavenId;", "myAggregatorProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "myParentProject", "myInheritGroupId", "", "myInheritVersion", "myArchetype", "Lorg/jetbrains/idea/maven/model/MavenArchetype;", "myPropertiesToCreateByArtifact", "", "", "myCommandName", "Lcom/intellij/openapi/util/NlsContexts$Command;", "<init>", "(Lorg/jetbrains/idea/maven/model/MavenId;Lorg/jetbrains/idea/maven/project/MavenProject;Lorg/jetbrains/idea/maven/project/MavenProject;ZZLorg/jetbrains/idea/maven/model/MavenArchetype;Ljava/util/Map;Ljava/lang/String;)V", "getMyProjectId", "()Lorg/jetbrains/idea/maven/model/MavenId;", "getMyAggregatorProject", "()Lorg/jetbrains/idea/maven/project/MavenProject;", "getMyCommandName", "()Ljava/lang/String;", "configure", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "isInteractive", "doConfigure", "setPomPackagingForAggregatorProject", "file", "useSubprojects", "model", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "updateProjectPom", "pom", "generateFromArchetype", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "copyGeneratedFiles", "workingDir", "Ljava/nio/file/Path;", "artifactId", "CoroutineService", "Companion", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenModuleBuilderHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenModuleBuilderHelper.kt\norg/jetbrains/idea/maven/wizards/MavenModuleBuilderHelper\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 EelResult.kt\ncom/intellij/platform/eel/EelResultKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,304:1\n30#2,2:305\n46#3:307\n42#3:308\n35#3,4:309\n37#4,2:313\n*S KotlinDebug\n*F\n+ 1 MavenModuleBuilderHelper.kt\norg/jetbrains/idea/maven/wizards/MavenModuleBuilderHelper\n*L\n134#1:305,2\n221#1:307\n221#1:308\n221#1:309,4\n207#1:313,2\n*E\n"})
public class MavenModuleBuilderHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MavenId myProjectId;
    @Nullable
    private final MavenProject myAggregatorProject;
    @Nullable
    private final MavenProject myParentProject;
    private final boolean myInheritGroupId;
    private final boolean myInheritVersion;
    @Nullable
    private final MavenArchetype myArchetype;
    @Nullable
    private final Map<String, String> myPropertiesToCreateByArtifact;
    @Nullable
    private final String myCommandName;

    public MavenModuleBuilderHelper(@NotNull MavenId myProjectId, @Nullable MavenProject myAggregatorProject, @Nullable MavenProject myParentProject, boolean myInheritGroupId, boolean myInheritVersion, @Nullable MavenArchetype myArchetype, @Nullable Map<String, String> myPropertiesToCreateByArtifact, @Nullable String myCommandName) {
        Intrinsics.checkNotNullParameter((Object)myProjectId, (String)"myProjectId");
        this.myProjectId = myProjectId;
        this.myAggregatorProject = myAggregatorProject;
        this.myParentProject = myParentProject;
        this.myInheritGroupId = myInheritGroupId;
        this.myInheritVersion = myInheritVersion;
        this.myArchetype = myArchetype;
        this.myPropertiesToCreateByArtifact = myPropertiesToCreateByArtifact;
        this.myCommandName = myCommandName;
    }

    @NotNull
    protected final MavenId getMyProjectId() {
        return this.myProjectId;
    }

    @Nullable
    protected final MavenProject getMyAggregatorProject() {
        return this.myAggregatorProject;
    }

    @Nullable
    protected final String getMyCommandName() {
        return this.myCommandName;
    }

    public void configure(@NotNull Project project, @NotNull VirtualFile root, boolean isInteractive) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        TrackingUtil.trackActivityBlocking((Project)project, (ActivityKey)MavenActivityKey.INSTANCE, () -> MavenModuleBuilderHelper.configure$lambda$0(this, project, root, isInteractive));
    }

    public void doConfigure(@NotNull Project project, @NotNull VirtualFile root, boolean isInteractive) {
        PsiFile[] psiFileArray;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        MavenActionsUsagesCollector.trigger(project, MavenActionsUsagesCollector.CREATE_MAVEN_PROJECT);
        if (this.myAggregatorProject != null) {
            PsiFile[] psiFileArray2 = new PsiFile[]{MavenModuleBuilderHelper.getPsiFile(project, this.myAggregatorProject.getFile())};
            psiFileArray = psiFileArray2;
        } else {
            psiFileArray = PsiFile.EMPTY_ARRAY;
        }
        PsiFile[] psiFiles = psiFileArray;
        VirtualFile pom = (VirtualFile)WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])Arrays.copyOf(psiFiles, psiFiles.length)).withName(this.myCommandName).compute(() -> MavenModuleBuilderHelper.doConfigure$lambda$0(project, root, this, isInteractive));
        if (pom == null) {
            return;
        }
        if (this.myAggregatorProject == null) {
            MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
            manager.addManagedFilesOrUnignoreNoUpdate(CollectionsKt.listOf((Object)pom));
        }
        if (this.myArchetype == null) {
            try {
                VfsUtil.createDirectories((String)(root.getPath() + "/src/main/java"));
                VfsUtil.createDirectories((String)(root.getPath() + "/src/main/resources"));
                VfsUtil.createDirectories((String)(root.getPath() + "/src/test/java"));
            }
            catch (IOException e) {
                MavenLog.LOG.info((Throwable)e);
            }
        }
        MavenLog.LOG.info(this.getClass().getSimpleName() + " forceUpdateAllProjectsOrFindAllAvailablePomFiles");
        MavenProjectsManager.getInstance(project).forceUpdateAllProjectsOrFindAllAvailablePomFiles();
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<CoroutineService> serviceClass$iv = CoroutineService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        CoroutineScope cs = ((CoroutineService)object).getCoroutineScope();
        TrackingUtil.launchTracked$default((CoroutineScope)cs, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(pom, project, this, null){
            int label;
            final /* synthetic */ VirtualFile $pom;
            final /* synthetic */ Project $project;
            final /* synthetic */ MavenModuleBuilderHelper this$0;
            {
                this.$pom = $pom;
                this.$project = $project;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
                        ModalityState modalityState = ModalityState.nonModal();
                        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"nonModal(...)");
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$pom, this.$project, this.this$0, null){
                            int label;
                            final /* synthetic */ VirtualFile $pom;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ MavenModuleBuilderHelper this$0;
                            {
                                this.$pom = $pom;
                                this.$project = $project;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (!this.$pom.isValid()) {
                                            MavenModuleBuilderHelper.showError(this.$project, new RuntimeException("Project is not valid"));
                                            return Unit.INSTANCE;
                                        }
                                        this.label = 1;
                                        v0 = CoroutinesKt.writeIntentReadAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.openapi.project.Project com.intellij.openapi.vfs.VirtualFile ), ()Lcom/intellij/openapi/editor/Editor;)((Project)this.$project, (VirtualFile)this.$pom), (Continuation)((Continuation)this));
                                        if (v0 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl17
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl17:
                                        // 2 sources

                                        if (MavenModuleBuilderHelper.access$getMyArchetype$p(this.this$0) != null) {
                                            this.label = 2;
                                            v1 = MavenModuleBuilderHelper.access$generateFromArchetype(this.this$0, this.$project, this.$pom, (Continuation)this);
                                            if (v1 == var2_2) {
                                                return var2_2;
                                            }
                                        }
                                        ** GOTO lbl26
                                    }
                                    case 2: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl26:
                                        // 2 sources

                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final Editor invokeSuspend$lambda$0(Project $project, VirtualFile $pom) {
                                PsiFile psiFile = MavenModuleBuilderHelper.getPsiFile($project, $pom);
                                Intrinsics.checkNotNull((Object)psiFile);
                                return EditorHelper.openInEditor((PsiElement)((PsiElement)psiFile));
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    protected final void setPomPackagingForAggregatorProject(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        MavenProject mavenProject = this.myAggregatorProject;
        Intrinsics.checkNotNull((Object)mavenProject);
        VirtualFile aggregatorProjectFile = mavenProject.getFile();
        MavenDomProjectModel model = MavenDomUtil.getMavenDomProjectModel(project, aggregatorProjectFile);
        if (model != null) {
            model.getPackaging().setStringValue("pom");
            PsiFile psiFile = MavenModuleBuilderHelper.getPsiFile(project, file2);
            boolean useSubprojects = this.useSubprojects(model);
            if (useSubprojects) {
                MavenDomSubproject subproject = model.getSubprojects().addSubproject();
                subproject.setValue(psiFile);
            } else {
                MavenDomModule module = model.getModules().addModule();
                module.setValue(psiFile);
            }
            VirtualFile[] virtualFileArray = new VirtualFile[]{aggregatorProjectFile};
            MavenModuleBuilderHelper.Companion.unblockAndSaveDocuments(project, virtualFileArray);
        }
    }

    private final boolean useSubprojects(MavenDomProjectModel model) {
        List<MavenDomSubproject> list = model.getSubprojects().getSubprojects();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getSubprojects(...)");
        if (CollectionsKt.any((Iterable)list)) {
            return true;
        }
        List<MavenDomModule> list2 = model.getModules().getModules();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getModules(...)");
        if (CollectionsKt.any((Iterable)list2)) {
            return false;
        }
        String modelVersion = (String)model.getModelVersion().getValue();
        return VersionComparatorUtil.compare((String)modelVersion, (String)"4.1.0") >= 0;
    }

    protected final void updateProjectPom(@NotNull Project project, @NotNull VirtualFile pom) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)pom, (String)"pom");
        if (this.myParentProject == null) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)project).withName(this.myCommandName).run(() -> MavenModuleBuilderHelper.updateProjectPom$lambda$0(project, pom, this));
    }

    /*
     * Unable to fully structure code
     */
    private final Object generateFromArchetype(Project project, VirtualFile pom, Continuation<? super Unit> $completion) {
        if (!($completion instanceof generateFromArchetype.1)) ** GOTO lbl-1000
        var18_4 = $completion;
        if ((var18_4.label & -2147483648) != 0) {
            var18_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ MavenModuleBuilderHelper this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MavenModuleBuilderHelper.access$generateFromArchetype(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var19_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                MavenActionsUsagesCollector.trigger(project, MavenActionsUsagesCollector.CREATE_MAVEN_PROJECT_FROM_ARCHETYPE);
                $continuation.L$0 = project;
                $continuation.L$1 = pom;
                $continuation.label = 1;
                v0 = EelProviderUtil.getEelDescriptor((Project)project).toEelApi((Continuation)$continuation);
                if (v0 == var19_6) {
                    return var19_6;
                }
                ** GOTO lbl25
            }
            case 1: {
                pom = (VirtualFile)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                eel = (EelApi)v0;
                var6_9 = (OwnedBuilder)EelFileSystemApiHelpersKt.createTemporaryDirectory((EelFileSystemApi)eel.getFs()).suffix("tmp").prefix("archetype").deleteOnExit(true);
                $i$f$getOrThrow = 0;
                $continuation.L$0 = project;
                $continuation.L$1 = pom;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)eel);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$getOrThrow$iv);
                $continuation.I$0 = $i$f$getOrThrow;
                $continuation.label = 2;
                v1 = $this$getOrThrow$iv.eelIt((Continuation)$continuation);
                ** if (v1 != var19_6) goto lbl40
lbl39:
                // 1 sources

                return var19_6;
lbl40:
                // 1 sources

                ** GOTO lbl51
            }
            case 2: {
                $i$f$getOrThrow = $continuation.I$0;
                $this$getOrThrow$iv = (OwnedBuilder)$continuation.L$3;
                eel = (EelApi)$continuation.L$2;
                pom = (VirtualFile)$continuation.L$1;
                project = (Project)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl51:
                    // 2 sources

                    $this$getOrThrow$iv$iv = (EelResult)v1;
                    $i$f$getOrThrow = false;
                    $this$getOr$iv$iv$iv = $this$getOrThrow$iv$iv;
                    $i$f$getOr = false;
                    var12_25 = $this$getOr$iv$iv$iv;
                    if (!(var12_25 instanceof EelResult.Ok)) {
                        if (var12_25 instanceof EelResult.Error) {
                            it$iv$iv = (EelResult.Error)$this$getOr$iv$iv$iv;
                            $i$a$-getOr-EelResultKt$getOrThrow$2$iv$iv = false;
                            it = (EelFileSystemApi.CreateTemporaryEntryError)it$iv$iv.getError();
                            $i$a$-getOrThrow-MavenModuleBuilderHelper$generateFromArchetype$workingDir$1 = false;
                            throw new IOException(it.getMessage());
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    $this$getOrThrow$iv = EelNioBridgeServiceKt.asNioPath((EelPath)((EelPath)((EelResult.Ok)$this$getOr$iv$iv$iv).getValue()));
                }
                catch (IOException e) {
                    MavenModuleBuilderHelper.showError(project, e);
                    return Unit.INSTANCE;
                }
                workingDir = $this$getOrThrow$iv;
                mavenVersion = MavenUtil.getMavenVersion(project);
                archetypePluginVersion = StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.6.3") >= 0 ? "RELEASE" : "3.1.2";
                params = new MavenRunnerParameters(false, workingDir.toString(), null, (List<String>)CollectionsKt.listOf((Object)("org.apache.maven.plugins:maven-archetype-plugin:" + archetypePluginVersion + ":generate")), CollectionsKt.emptyList());
                runner = MavenRunner.getInstance(project);
                v2 = runner.getState().clone();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"clone(...)");
                settings = v2;
                props = settings.getMavenProperties();
                Intrinsics.checkNotNull(props);
                var12_25 = props;
                var13_27 = "interactiveMode";
                var14_29 = "false";
                var12_25.put(var13_27, var14_29);
                if (this.myPropertiesToCreateByArtifact != null) {
                    props.putAll(this.myPropertiesToCreateByArtifact);
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)pom);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)eel);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)workingDir);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)mavenVersion);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)archetypePluginVersion);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)params);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)runner);
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)settings);
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable(props);
                $continuation.label = 3;
                v3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(runner, params, settings, this, (Path)workingDir, pom, project, props, null){
                    int label;
                    final /* synthetic */ MavenRunner $runner;
                    final /* synthetic */ MavenRunnerParameters $params;
                    final /* synthetic */ MavenRunnerSettings $settings;
                    final /* synthetic */ MavenModuleBuilderHelper this$0;
                    final /* synthetic */ Path $workingDir;
                    final /* synthetic */ VirtualFile $pom;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Map<String, String> $props;
                    {
                        this.$runner = $runner;
                        this.$params = $params;
                        this.$settings = $settings;
                        this.this$0 = $receiver;
                        this.$workingDir = $workingDir;
                        this.$pom = $pom;
                        this.$project = $project;
                        this.$props = $props;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.$runner.run(this.$params, this.$settings, () -> generateFromArchetype.2.invokeSuspend$lambda$0(this.this$0, this.$workingDir, this.$pom, this.$project, this.$props));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final void invokeSuspend$lambda$0(MavenModuleBuilderHelper this$0, Path $workingDir, VirtualFile $pom, Project $project, Map $props) {
                        this$0.copyGeneratedFiles($workingDir, $pom, $project, (String)$props.get("artifactId"));
                    }
                }), (Continuation)$continuation);
                if (v3 == var19_6) {
                    return var19_6;
                }
                ** GOTO lbl114
            }
            case 3: {
                props = (Map)$continuation.L$9;
                settings = (MavenRunnerSettings)$continuation.L$8;
                runner = (MavenRunner)$continuation.L$7;
                params = (MavenRunnerParameters)$continuation.L$6;
                archetypePluginVersion = (String)$continuation.L$5;
                mavenVersion = (String)$continuation.L$4;
                workingDir = (Path)$continuation.L$3;
                eel = (EelApi)$continuation.L$2;
                pom = (VirtualFile)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl114:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final void copyGeneratedFiles(@NotNull Path workingDir, @NotNull VirtualFile pom, @NotNull Project project, @Nullable String artifactId) {
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)pom, (String)"pom");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String artifactId2 = artifactId;
        GitSilentFileAdder gitSilentFileAdder = GitSilentFileAdderProvider.create((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)gitSilentFileAdder, (String)"create(...)");
        GitSilentFileAdder vcsFileAdder = gitSilentFileAdder;
        try {
            try {
                String string = artifactId2;
                if (string == null) {
                    string = this.myProjectId.getArtifactId();
                }
                if ((artifactId2 = string) != null) {
                    Path sourceDir = workingDir.resolve(artifactId2);
                    Path path = pom.getParent().toNioPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
                    Path targetDir = path;
                    vcsFileAdder.markFileForAdding(targetDir, true);
                    NioFiles.copyRecursively(sourceDir, targetDir);
                }
                FileUtil.delete((Path)workingDir);
            }
            catch (Exception e) {
                MavenModuleBuilderHelper.showError(project, e);
                vcsFileAdder.finish();
                return;
            }
            pom.getParent().refresh(false, false);
            pom.refresh(false, false);
            this.updateProjectPom(project, pom);
            LocalFileSystem.getInstance().refreshWithoutFileWatcher(true);
        }
        finally {
            vcsFileAdder.finish();
        }
    }

    private static final Unit configure$lambda$0(MavenModuleBuilderHelper this$0, Project $project, VirtualFile $root, boolean $isInteractive) {
        this$0.doConfigure($project, $root, $isInteractive);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final VirtualFile doConfigure$lambda$0(Project $project, VirtualFile $root, MavenModuleBuilderHelper this$0, boolean $isInteractive) {
        GitSilentFileAdder gitSilentFileAdder = GitSilentFileAdderProvider.create((Project)$project);
        Intrinsics.checkNotNullExpressionValue((Object)gitSilentFileAdder, (String)"create(...)");
        GitSilentFileAdder vcsFileAdder = gitSilentFileAdder;
        VirtualFile file2 = null;
        try {
            try {
                VirtualFile virtualFile = file2 = $root.findChild("pom.xml");
                if (virtualFile != null) {
                    virtualFile.delete((Object)this$0);
                }
                file2 = $root.createChildData((Object)this$0, "pom.xml");
                if (this$0.myAggregatorProject == null) {
                    $root.createChildDirectory((Object)this$0, ".mvn");
                }
                vcsFileAdder.markFileForAdding(file2);
                MavenUtil.runOrApplyMavenProjectFileTemplate($project, file2, this$0.myProjectId, $isInteractive);
            }
            catch (IOException e) {
                MavenModuleBuilderHelper.showError($project, e);
                VirtualFile virtualFile = file2;
                vcsFileAdder.finish();
                return virtualFile;
            }
            this$0.updateProjectPom($project, file2);
        }
        finally {
            vcsFileAdder.finish();
        }
        if (this$0.myAggregatorProject != null) {
            this$0.setPomPackagingForAggregatorProject($project, file2);
        }
        return file2;
    }

    private static final void updateProjectPom$lambda$0(Project $project, VirtualFile $pom, MavenModuleBuilderHelper this$0) {
        XmlElement el;
        PsiDocumentManager.getInstance((Project)$project).commitAllDocuments();
        MavenDomProjectModel model = MavenDomUtil.getMavenDomProjectModel($project, $pom);
        if (model == null) {
            return;
        }
        MavenDomUtil.updateMavenParent(model, this$0.myParentProject);
        if (this$0.myInheritGroupId) {
            XmlElement xmlElement = el = model.getGroupId().getXmlElement();
            if (xmlElement != null) {
                xmlElement.delete();
            }
        }
        if (this$0.myInheritVersion) {
            XmlElement xmlElement = el = model.getVersion().getXmlElement();
            if (xmlElement != null) {
                xmlElement.delete();
            }
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)$project);
        PsiFile psiFile = MavenModuleBuilderHelper.getPsiFile($project, $pom);
        Intrinsics.checkNotNull((Object)psiFile);
        codeStyleManager.reformat((PsiElement)psiFile);
        List pomFiles = new ArrayList(2);
        pomFiles.add($pom);
        if (!FileUtil.namesEqual((String)"pom.xml", (String)this$0.myParentProject.getFile().getName())) {
            pomFiles.add(this$0.myParentProject.getFile());
            MavenProjectsManager.getInstance($project).scheduleForceUpdateMavenProject(this$0.myParentProject);
        }
        Collection $this$toTypedArray$iv = pomFiles;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        VirtualFile[] virtualFileArray = thisCollection$iv.toArray(new VirtualFile[0]);
        MavenModuleBuilderHelper.Companion.unblockAndSaveDocuments($project, Arrays.copyOf(virtualFileArray, virtualFileArray.length));
    }

    @JvmStatic
    @Nullable
    protected static final PsiFile getPsiFile(@NotNull Project project, @NotNull VirtualFile pom) {
        return Companion.getPsiFile(project, pom);
    }

    @JvmStatic
    protected static final void showError(@NotNull Project project, @NotNull Throwable e) {
        Companion.showError(project, e);
    }

    public static final /* synthetic */ MavenArchetype access$getMyArchetype$p(MavenModuleBuilderHelper $this) {
        return $this.myArchetype;
    }

    public static final /* synthetic */ Object access$generateFromArchetype(MavenModuleBuilderHelper $this, Project project, VirtualFile pom, Continuation $completion) {
        return $this.generateFromArchetype(project, pom, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000bJ\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\nH\u0005J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0005\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/idea/maven/wizards/MavenModuleBuilderHelper$Companion;", "", "<init>", "()V", "unblockAndSaveDocuments", "", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/vfs/VirtualFile;)V", "getPsiFile", "Lcom/intellij/psi/PsiFile;", "pom", "showError", "e", "", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        private final void unblockAndSaveDocuments(Project project, VirtualFile ... files2) {
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
            FileDocumentManager fileDocumentManager2 = fileDocumentManager;
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
            for (VirtualFile file2 : files2) {
                Document document = fileDocumentManager2.getDocument(file2);
                if (document == null) continue;
                psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
                fileDocumentManager2.saveDocument(document);
            }
        }

        @JvmStatic
        @Nullable
        protected final PsiFile getPsiFile(@NotNull Project project, @NotNull VirtualFile pom) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)pom, (String)"pom");
            return PsiManager.getInstance((Project)project).findFile(pom);
        }

        @JvmStatic
        protected final void showError(@NotNull Project project, @NotNull Throwable e) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            String string = MavenProjectBundle.message("notification.title.failed.to.create.maven.project", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            MavenUtil.showError(project, string, e);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/maven/wizards/MavenModuleBuilderHelper$CoroutineService;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "intellij.maven"})
    private static final class CoroutineService {
        @NotNull
        private final CoroutineScope coroutineScope;

        public CoroutineService(@NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            this.coroutineScope = coroutineScope;
        }

        @NotNull
        public final CoroutineScope getCoroutineScope() {
            return this.coroutineScope;
        }
    }
}

