/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.classMembers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.refactoring.classMembers.AbstractMemberInfoStorage;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import java.util.ArrayList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.refactoring.classMembers.GrMemberInfo;

public class GrMemberInfoStorage
extends AbstractMemberInfoStorage<GrMember, PsiClass, GrMemberInfo> {
    public GrMemberInfoStorage(GrTypeDefinition aClass, MemberInfoBase.Filter<GrMember> memberInfoFilter) {
        super((PsiElement)aClass, memberInfoFilter);
    }

    protected boolean isInheritor(PsiClass baseClass, PsiClass aClass) {
        return aClass.isInheritor(baseClass, true);
    }

    protected void extractClassMembers(PsiClass aClass, ArrayList<GrMemberInfo> temp) {
        GrMemberInfo.extractClassMembers(aClass, temp, (MemberInfoBase.Filter<GrMember>)this.myFilter, false);
    }

    protected boolean memberConflict(GrMember member1, GrMember member) {
        if (member instanceof GrMethod && member1 instanceof GrMethod) {
            return MethodSignatureUtil.areSignaturesEqual((PsiMethod)((GrMethod)member), (PsiMethod)((GrMethod)member1));
        }
        if (member instanceof GrField && member1 instanceof GrField || member instanceof GrTypeDefinition && member1 instanceof GrTypeDefinition) {
            return member.getName().equals(member1.getName());
        }
        return false;
    }

    protected void buildSubClassesMap(PsiClass aClass) {
        if (aClass instanceof GrTypeDefinition) {
            GrImplementsClause implementsList;
            GrExtendsClause extendsList = ((GrTypeDefinition)aClass).getExtendsClause();
            if (extendsList != null) {
                this.buildSubClassesMapForList(extendsList.getReferencedTypes(), (GrTypeDefinition)aClass);
            }
            if ((implementsList = ((GrTypeDefinition)aClass).getImplementsClause()) != null) {
                this.buildSubClassesMapForList(implementsList.getReferencedTypes(), (GrTypeDefinition)aClass);
            }
        }
    }

    private void buildSubClassesMapForList(PsiClassType[] classesList, GrTypeDefinition aClass) {
        for (PsiClassType element : classesList) {
            PsiClass resolved = element.resolve();
            if (!(resolved instanceof GrTypeDefinition)) continue;
            GrTypeDefinition superClass = (GrTypeDefinition)resolved;
            this.getSubclasses(superClass).add(aClass);
            this.buildSubClassesMap(superClass);
        }
    }
}

