/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrModifierListUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrTraitMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;

public final class GroovyOverrideImplementExploreUtil {
    @NotNull
    public static Collection<MethodSignature> getMethodSignaturesToOverride(@NotNull GrTypeDefinition aClass) {
        if (aClass == null) {
            GroovyOverrideImplementExploreUtil.$$$reportNull$$$0(0);
        }
        if (aClass.isAnnotationType()) {
            Set<MethodSignature> set = Collections.emptySet();
            if (set == null) {
                GroovyOverrideImplementExploreUtil.$$$reportNull$$$0(1);
            }
            return set;
        }
        Set<MethodSignature> set = GroovyOverrideImplementExploreUtil.getMapToOverrideImplement(aClass, false, true).keySet();
        if (set == null) {
            GroovyOverrideImplementExploreUtil.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public static Collection<MethodSignature> getMethodSignaturesToImplement(@NotNull GrTypeDefinition aClass) {
        if (aClass == null) {
            GroovyOverrideImplementExploreUtil.$$$reportNull$$$0(3);
        }
        Set<MethodSignature> set = GroovyOverrideImplementExploreUtil.getMapToOverrideImplement(aClass, true, true).keySet();
        if (set == null) {
            GroovyOverrideImplementExploreUtil.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public static Collection<CandidateInfo> getMethodsToOverrideImplement(GrTypeDefinition aClass, boolean toImplement) {
        Collection<CandidateInfo> collection = GroovyOverrideImplementExploreUtil.getMapToOverrideImplement(aClass, toImplement, true).values();
        if (collection == null) {
            GroovyOverrideImplementExploreUtil.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    public static Map<MethodSignature, CandidateInfo> getMapToOverrideImplement(GrTypeDefinition aClass, boolean toImplement, boolean skipImplemented) {
        Collection allMethodSignatures = aClass.getVisibleSignatures();
        return GroovyOverrideImplementExploreUtil.getMapToOverrideImplement(aClass, allMethodSignatures, toImplement, skipImplemented);
    }

    @NotNull
    public static Map<MethodSignature, CandidateInfo> getMapToOverrideImplement(PsiClass aClass, Collection<? extends HierarchicalMethodSignature> allMethodSignatures, boolean toImplement, boolean skipImplemented) {
        LinkedHashMap<MethodSignature, PsiMethod> abstracts = new LinkedHashMap<MethodSignature, PsiMethod>();
        LinkedHashMap<MethodSignature, PsiMethod> finals = new LinkedHashMap<MethodSignature, PsiMethod>();
        LinkedHashMap<MethodSignature, PsiMethod> concretes = new LinkedHashMap<MethodSignature, PsiMethod>();
        PsiUtilCore.ensureValid((PsiElement)aClass);
        for (HierarchicalMethodSignature hierarchicalMethodSignature : allMethodSignatures) {
            PsiMethod method = hierarchicalMethodSignature.getMethod();
            if (method instanceof GrTraitMethod) {
                for (HierarchicalMethodSignature superSignature : hierarchicalMethodSignature.getSuperSignatures()) {
                    GroovyOverrideImplementExploreUtil.processMethod(aClass, skipImplemented, abstracts, finals, concretes, superSignature, superSignature.getMethod());
                }
                continue;
            }
            GroovyOverrideImplementExploreUtil.processMethod(aClass, skipImplemented, abstracts, finals, concretes, hierarchicalMethodSignature, method);
        }
        TreeMap<MethodSignature, CandidateInfo> result2 = new TreeMap<MethodSignature, CandidateInfo>((Comparator<MethodSignature>)new OverrideImplementExploreUtil.MethodSignatureComparator());
        if (toImplement || aClass.isInterface()) {
            GroovyOverrideImplementExploreUtil.collectMethodsToImplement(aClass, abstracts, finals, concretes, result2);
        } else {
            for (Map.Entry entry : concretes.entrySet()) {
                PsiMethod abstractOne;
                MethodSignature signature = (MethodSignature)entry.getKey();
                PsiMethod concrete = (PsiMethod)entry.getValue();
                if (finals.get(signature) != null || (abstractOne = (PsiMethod)abstracts.get(signature)) != null && abstractOne.getContainingClass().isInheritor(concrete.getContainingClass(), true) && !"java.lang.Object".equals(concrete.getContainingClass().getQualifiedName())) continue;
                PsiSubstitutor subst = OverrideImplementExploreUtil.correctSubstitutor((PsiMethod)concrete, (PsiSubstitutor)signature.getSubstitutor());
                CandidateInfo info = new CandidateInfo((PsiElement)concrete, subst);
                result2.put(signature, info);
            }
        }
        TreeMap<MethodSignature, CandidateInfo> treeMap = result2;
        if (treeMap == null) {
            GroovyOverrideImplementExploreUtil.$$$reportNull$$$0(6);
        }
        return treeMap;
    }

    public static void processMethod(PsiClass aClass, boolean skipImplemented, Map<MethodSignature, PsiMethod> abstracts, Map<MethodSignature, PsiMethod> finals, Map<MethodSignature, PsiMethod> concretes, HierarchicalMethodSignature signature, PsiMethod method) {
        PsiMethod implemented;
        PsiUtilCore.ensureValid((PsiElement)method);
        if (GrModifierListUtil.hasCodeModifierProperty((PsiModifierListOwner)method, "static") || GrModifierListUtil.hasCodeModifierProperty((PsiModifierListOwner)method, "final") || GrModifierListUtil.hasCodeModifierProperty((PsiModifierListOwner)method, "private")) {
            return;
        }
        PsiClass hisClass = method.getContainingClass();
        if (hisClass == null) {
            return;
        }
        if (method.isConstructor() && (!aClass.isInheritor(hisClass, false) || aClass instanceof PsiAnonymousClass || aClass.isEnum())) {
            return;
        }
        if (skipImplemented && (implemented = MethodSignatureUtil.findMethodBySignature((PsiClass)aClass, (MethodSignature)signature, (boolean)false)) != null && !(implemented instanceof GrTraitMethod) && !(implemented instanceof GrLightMethodBuilder)) {
            return;
        }
        if (method.hasModifierProperty("final")) {
            finals.put((MethodSignature)signature, method);
            return;
        }
        Map<MethodSignature, PsiMethod> map2 = method.hasModifierProperty("abstract") ? abstracts : concretes;
        GroovyOverrideImplementExploreUtil.fillMap(signature, method, map2);
        if (GroovyOverrideImplementExploreUtil.isDefaultMethod(method)) {
            GroovyOverrideImplementExploreUtil.fillMap(signature, method, concretes);
        }
    }

    private static void fillMap(HierarchicalMethodSignature signature, PsiMethod method, Map<MethodSignature, PsiMethod> map2) {
        PsiMethod other = map2.get(signature);
        if (other == null || GroovyOverrideImplementExploreUtil.preferLeftForImplement(method, other)) {
            map2.put((MethodSignature)signature, method);
        }
    }

    private static boolean preferLeftForImplement(PsiMethod left, PsiMethod right) {
        PsiAnnotation[] rightAnnotations;
        if (PsiUtil.getAccessLevel((PsiModifierList)left.getModifierList()) > PsiUtil.getAccessLevel((PsiModifierList)right.getModifierList())) {
            return true;
        }
        PsiClass lClass = left.getContainingClass();
        PsiClass rClass = right.getContainingClass();
        if (lClass != null && !lClass.isInterface()) {
            return true;
        }
        if (rClass != null && !rClass.isInterface()) {
            return false;
        }
        PsiAnnotation[] leftAnnotations = left.getModifierList().getAnnotations();
        return leftAnnotations.length > (rightAnnotations = right.getModifierList().getAnnotations()).length;
    }

    private static boolean isDefaultMethod(PsiMethod method) {
        return method instanceof GrMethod && !method.getModifierList().hasExplicitModifier("abstract") && GrTraitUtil.isTrait(method.getContainingClass());
    }

    public static void collectMethodsToImplement(PsiClass aClass, Map<MethodSignature, PsiMethod> abstracts, Map<MethodSignature, PsiMethod> finals, Map<MethodSignature, PsiMethod> concretes, Map<MethodSignature, CandidateInfo> result2) {
        for (Map.Entry<MethodSignature, PsiMethod> entry : abstracts.entrySet()) {
            MethodSignature signature = entry.getKey();
            PsiMethod abstractOne = entry.getValue();
            PsiMethod concrete = concretes.get(signature);
            if (concrete != null && PsiUtil.getAccessLevel((PsiModifierList)concrete.getModifierList()) >= PsiUtil.getAccessLevel((PsiModifierList)abstractOne.getModifierList()) && (abstractOne.getContainingClass().isInterface() || !abstractOne.getContainingClass().isInheritor(concrete.getContainingClass(), true)) && !GroovyOverrideImplementExploreUtil.isDefaultMethod(abstractOne) || finals.get(signature) != null) continue;
            PsiSubstitutor subst = OverrideImplementExploreUtil.correctSubstitutor((PsiMethod)abstractOne, (PsiSubstitutor)signature.getSubstitutor());
            CandidateInfo info = new CandidateInfo((PsiElement)abstractOne, subst);
            result2.put(signature, info);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/util/GroovyOverrideImplementExploreUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/util/GroovyOverrideImplementExploreUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodSignaturesToOverride";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodSignaturesToImplement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsToOverrideImplement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapToOverrideImplement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMethodSignaturesToOverride";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMethodSignaturesToImplement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

