/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.actions.ToggleAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainFrame;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.Shortcut;

public class FullscreenToggleAction
extends ToggleAction {
    private final transient GraphicsDevice gd;
    private Rectangle prevBounds;

    public FullscreenToggleAction() {
        super(I18n.tr("Fullscreen view", new Object[0]), new ImageProvider("fullscreen"), I18n.tr("Toggle fullscreen view", new Object[0]), Shortcut.registerShortcut("menu:view:fullscreen", I18n.tr("View: {0}", I18n.tr("Fullscreen view", new Object[0])), 122, 5003), false, null, false);
        this.setHelpId(HelpUtil.ht("/Action/FullscreenView"));
        this.setToolbarId("fullscreen");
        MainApplication.getToolbar().register(this);
        this.gd = GraphicsEnvironment.isHeadless() ? null : GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        this.setSelected(Config.getPref().getBoolean("draw.fullscreen", false));
        this.notifySelectedState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.toggleSelectedState(e);
        Config.getPref().putBoolean("draw.fullscreen", this.isSelected());
        this.notifySelectedState();
        this.safeSetMode();
    }

    public void initial() {
        if (this.isSelected()) {
            this.safeSetMode();
        }
    }

    protected void safeSetMode() {
        try {
            this.setMode();
        }
        catch (Exception exception) {
            Config.getPref().put("draw.fullscreen", null);
            throw exception;
        }
    }

    protected void setMode() {
        String exclusive;
        MainFrame frame = MainApplication.getMainFrame();
        ArrayList<Window> visibleWindows = new ArrayList<Window>();
        visibleWindows.add(frame);
        for (Window w : Frame.getWindows()) {
            if (!w.isVisible() || w == frame) continue;
            visibleWindows.add(w);
        }
        boolean selected = this.isSelected();
        if (frame != null) {
            frame.dispose();
            frame.setUndecorated(selected);
            if (selected) {
                this.prevBounds = frame.getBounds();
                frame.setBounds(new Rectangle(GuiHelper.getScreenSize()));
            }
        }
        if (("true".equals(exclusive = Config.getPref().get("draw.fullscreen.exclusive-mode", "auto")) || "auto".equals(exclusive) && !PlatformManager.isPlatformWindows()) && this.gd != null) {
            this.gd.setFullScreenWindow(selected ? frame : null);
        }
        if (!selected && this.prevBounds != null && frame != null) {
            frame.setBounds(this.prevBounds);
        }
        for (Window wind : visibleWindows) {
            if (wind == null) continue;
            wind.setVisible(true);
        }
        if (frame != null) {
            frame.getJMenuBar().getInputMap(2).put(KeyStroke.getKeyStroke(121, 0), "none");
        }
    }
}

