/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import jakarta.persistence.ParameterMode;
import java.util.Locale;
import java.util.Objects;
import org.hibernate.engine.jdbc.env.spi.ExtractedDatabaseMetaData;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.procedure.ParameterTypeException;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.procedure.spi.ParameterStrategy;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.spi.AbstractQueryParameter;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.sql.exec.internal.JdbcCallParameterExtractorImpl;
import org.hibernate.sql.exec.internal.JdbcCallParameterRegistrationImpl;
import org.hibernate.sql.exec.internal.JdbcCallRefCursorExtractorImpl;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.JdbcCallParameterRegistration;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.type.BasicType;
import org.hibernate.type.BindableType;
import org.hibernate.type.OutputableType;
import org.hibernate.type.ProcedureParameterNamedBinder;
import org.hibernate.type.internal.BindingTypeHelper;

public class ProcedureParameterImpl<T>
extends AbstractQueryParameter<T>
implements ProcedureParameterImplementor<T> {
    private final String name;
    private final Integer position;
    private final ParameterMode mode;
    private final Class<T> javaType;

    public ProcedureParameterImpl(String name, ParameterMode mode, Class<T> javaType, BindableType<T> hibernateType) {
        super(false, hibernateType);
        this.name = name;
        this.position = null;
        this.mode = mode;
        this.javaType = javaType;
    }

    public ProcedureParameterImpl(Integer position, ParameterMode mode, Class<T> javaType, BindableType<T> hibernateType) {
        super(false, hibernateType);
        this.name = null;
        this.position = position;
        this.mode = mode;
        this.javaType = javaType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public ParameterMode getMode() {
        return this.mode;
    }

    @Override
    public Class<T> getParameterType() {
        return this.javaType;
    }

    @Override
    public NamedCallableQueryMemento.ParameterMemento toMemento() {
        return session -> this.isNamed() ? new ProcedureParameterImpl<T>(this.getName(), this.getMode(), this.javaType, this.getHibernateType()) : new ProcedureParameterImpl<T>(this.getPosition(), this.getMode(), this.javaType, this.getHibernateType());
    }

    @Override
    public JdbcCallParameterRegistration toJdbcParameterRegistration(int startIndex, ProcedureCallImplementor<?> procedureCall) {
        JdbcCallParameterExtractorImpl parameterExtractor;
        JdbcParameterBinder parameterBinder;
        JdbcCallRefCursorExtractorImpl refCursorExtractor;
        String jdbcParamName;
        QueryParameterBinding binding = procedureCall.getParameterBindings().getBinding(this);
        boolean isNamed = procedureCall.getParameterStrategy() == ParameterStrategy.NAMED && this.name != null;
        SharedSessionContractImplementor session = procedureCall.getSession();
        OutputableType typeToUse = (OutputableType)BindingTypeHelper.resolveTemporalPrecision(binding == null ? null : binding.getExplicitTemporalPrecision(), this.getBindableType(binding), session.getFactory().getQueryEngine().getCriteriaBuilder());
        ExtractedDatabaseMetaData databaseMetaData = session.getFactory().getJdbcServices().getJdbcEnvironment().getExtractedDatabaseMetaData();
        boolean passProcedureParameterNames = session.getFactory().getSessionFactoryOptions().isPassProcedureParameterNames();
        switch (this.mode) {
            case REF_CURSOR: {
                jdbcParamName = this.name != null && databaseMetaData.supportsNamedParameters() && passProcedureParameterNames ? this.name : null;
                refCursorExtractor = new JdbcCallRefCursorExtractorImpl(startIndex);
                parameterBinder = null;
                parameterExtractor = null;
                break;
            }
            case IN: {
                jdbcParamName = this.getJdbcParamName(procedureCall, isNamed, passProcedureParameterNames, typeToUse, databaseMetaData);
                this.validateBindableType(typeToUse, startIndex);
                parameterBinder = this.getParameterBinder(typeToUse, jdbcParamName);
                parameterExtractor = null;
                refCursorExtractor = null;
                break;
            }
            case INOUT: {
                jdbcParamName = this.getJdbcParamName(procedureCall, isNamed, passProcedureParameterNames, typeToUse, databaseMetaData);
                this.validateBindableType(typeToUse, startIndex);
                parameterBinder = this.getParameterBinder(typeToUse, jdbcParamName);
                parameterExtractor = new JdbcCallParameterExtractorImpl(procedureCall.getProcedureName(), jdbcParamName, startIndex, typeToUse);
                refCursorExtractor = null;
                break;
            }
            default: {
                jdbcParamName = this.getJdbcParamName(procedureCall, isNamed, passProcedureParameterNames, typeToUse, databaseMetaData);
                this.validateBindableType(typeToUse, startIndex);
                parameterBinder = null;
                parameterExtractor = new JdbcCallParameterExtractorImpl(procedureCall.getProcedureName(), jdbcParamName, startIndex, typeToUse);
                refCursorExtractor = null;
            }
        }
        return new JdbcCallParameterRegistrationImpl(jdbcParamName, startIndex, this.mode, typeToUse, parameterBinder, parameterExtractor, refCursorExtractor);
    }

    private BindableType<T> getBindableType(QueryParameterBinding<T> binding) {
        if (this.getHibernateType() != null) {
            return this.getHibernateType();
        }
        if (binding != null) {
            return binding.getBindType();
        }
        return null;
    }

    private String getJdbcParamName(ProcedureCallImplementor<?> procedureCall, boolean isNamed, boolean passProcedureParameterNames, OutputableType<T> typeToUse, ExtractedDatabaseMetaData databaseMetaData) {
        return isNamed && passProcedureParameterNames && this.canDoNameParameterBinding(typeToUse, procedureCall, databaseMetaData) ? this.name : null;
    }

    private void validateBindableType(BindableType<T> bindableType, int startIndex) {
        if (bindableType == null) {
            throw new ParameterTypeException(String.format(Locale.ROOT, "Could not determine ProcedureCall parameter bind type - %s (%s)", this.name != null ? this.name : this.position, startIndex));
        }
    }

    private JdbcParameterBinder getParameterBinder(BindableType<T> typeToUse, String name) {
        if (typeToUse == null) {
            throw new ParameterTypeException(String.format(Locale.ROOT, "Cannot determine the bindable type for procedure parameter %s (%s)", this.name != null ? this.name : this.position, name));
        }
        if (typeToUse instanceof BasicType) {
            return new JdbcParameterImpl((BasicType)typeToUse);
        }
        throw new UnsupportedOperationException();
    }

    private boolean canDoNameParameterBinding(BindableType<?> hibernateType, ProcedureCallImplementor<?> procedureCall, ExtractedDatabaseMetaData databaseMetaData) {
        return procedureCall.getFunctionReturn() == null && databaseMetaData.supportsNamedParameters() && hibernateType instanceof ProcedureParameterNamedBinder && ((ProcedureParameterNamedBinder)((Object)hibernateType)).canDoSetting();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.position, this.mode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof ProcedureParameterImpl)) {
            return false;
        }
        ProcedureParameterImpl that = (ProcedureParameterImpl)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.position, that.position) && this.mode == that.mode;
    }

    public String toString() {
        return this.position == null ? this.name : this.position.toString();
    }
}

