/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.docker.installation;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import org.keycloak.Config;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.ClientInstallationProvider;

public class DockerRegistryConfigFileInstallationProvider
implements ClientInstallationProvider {
    public ClientInstallationProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "docker-v2-registry-config-file";
    }

    public Response generateInstallation(KeycloakSession session, RealmModel realm, ClientModel client, URI serverBaseUri) {
        StringBuilder responseString = new StringBuilder("auth:\n").append("  token:\n").append("    realm: ").append(serverBaseUri).append("/realms/").append(realm.getName()).append("/protocol/").append("docker-v2").append("/auth\n").append("    service: ").append(client.getClientId()).append("\n").append("    issuer: ").append(serverBaseUri).append("/realms/").append(realm.getName()).append("\n");
        return Response.ok((Object)responseString.toString(), (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
    }

    public String getProtocol() {
        return "docker-v2";
    }

    public String getDisplayType() {
        return "Registry Config File";
    }

    public String getHelpText() {
        return "Provides a registry configuration file snippet for use with this client";
    }

    public String getFilename() {
        return "config.yml";
    }

    public String getMediaType() {
        return "text/plain";
    }

    public boolean isDownloadOnly() {
        return false;
    }
}

