
#ifndef LIBKMAHJONGG_EXPORT_H
#define LIBKMAHJONGG_EXPORT_H

#ifdef LIBKMAHJONGG_STATIC_DEFINE
#  define LIBKMAHJONGG_EXPORT
#  define LIBKMAHJONGG_NO_EXPORT
#else
#  ifndef LIBKMAHJONGG_EXPORT
#    ifdef KMahjongglib_EXPORTS
        /* We are building this library */
#      define LIBKMAHJONGG_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define LIBKMAHJONGG_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef LIBKMAHJONGG_NO_EXPORT
#    define LIBKMAHJONGG_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef LIBKMAHJONGG_DECL_DEPRECATED
#  define LIBKMAHJONGG_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef LIBKMAHJONGG_DECL_DEPRECATED_EXPORT
#  define LIBKMAHJONGG_DECL_DEPRECATED_EXPORT LIBKMAHJONGG_EXPORT LIBKMAHJONGG_DECL_DEPRECATED
#endif

#ifndef LIBKMAHJONGG_DECL_DEPRECATED_NO_EXPORT
#  define LIBKMAHJONGG_DECL_DEPRECATED_NO_EXPORT LIBKMAHJONGG_NO_EXPORT LIBKMAHJONGG_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef LIBKMAHJONGG_NO_DEPRECATED
#    define LIBKMAHJONGG_NO_DEPRECATED
#  endif
#endif
#include <kmahjongglib_version.h>

#define LIBKMAHJONGG_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(LIBKMAHJONGG_NO_DEPRECATED)
#  undef LIBKMAHJONGG_DEPRECATED
#  define LIBKMAHJONGG_DEPRECATED_EXPORT LIBKMAHJONGG_EXPORT
#  define LIBKMAHJONGG_DEPRECATED_NO_EXPORT LIBKMAHJONGG_NO_EXPORT
#elif defined(LIBKMAHJONGG_NO_DEPRECATED_WARNINGS)
#  define LIBKMAHJONGG_DEPRECATED
#  define LIBKMAHJONGG_DEPRECATED_EXPORT LIBKMAHJONGG_EXPORT
#  define LIBKMAHJONGG_DEPRECATED_NO_EXPORT LIBKMAHJONGG_NO_EXPORT
#else
#  define LIBKMAHJONGG_DEPRECATED LIBKMAHJONGG_DECL_DEPRECATED
#  define LIBKMAHJONGG_DEPRECATED_EXPORT LIBKMAHJONGG_DECL_DEPRECATED_EXPORT
#  define LIBKMAHJONGG_DEPRECATED_NO_EXPORT LIBKMAHJONGG_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define LIBKMAHJONGG_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define LIBKMAHJONGG_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef LIBKMAHJONGG_NO_DEPRECATED
#  define LIBKMAHJONGG_DISABLE_DEPRECATED_BEFORE_AND_AT KMAHJONGGLIB_VERSION
#endif
#ifdef LIBKMAHJONGG_NO_DEPRECATED_WARNINGS
#  define LIBKMAHJONGG_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef LIBKMAHJONGG_DEPRECATED_WARNINGS_SINCE
#  ifdef LIBKMAHJONGG_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define LIBKMAHJONGG_DEPRECATED_WARNINGS_SINCE LIBKMAHJONGG_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define LIBKMAHJONGG_DEPRECATED_WARNINGS_SINCE KMAHJONGGLIB_VERSION
#  endif
#endif

#ifndef LIBKMAHJONGG_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define LIBKMAHJONGG_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef LIBKMAHJONGG_DEPRECATED
#  define LIBKMAHJONGG_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > LIBKMAHJONGG_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define LIBKMAHJONGG_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* LIBKMAHJONGG_EXPORT_H */
