/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.utils;

import java.util.regex.Pattern;

public class WildcardMatcher {
    public static boolean match(String str, String wildcardMatcher) {
        if (str == null && wildcardMatcher == null) {
            return true;
        }
        if (str == null || wildcardMatcher == null) {
            return false;
        }
        Pattern wildcardRegexp = Pattern.compile(WildcardMatcher.wildcardToRegexp(wildcardMatcher, '.'));
        return wildcardRegexp.matcher(str).matches();
    }

    private static String wildcardToRegexp(String globExp, char separator) {
        StringBuilder dst = new StringBuilder();
        char[] src = globExp.replace("**" + separator + "*", "**").toCharArray();
        int i = 0;
        block6: while (i < src.length) {
            char c = src[i++];
            switch (c) {
                case '*': {
                    if (i < src.length && src[i] == '*') {
                        dst.append(".*");
                        ++i;
                        continue block6;
                    }
                    dst.append("[^");
                    dst.append(separator);
                    dst.append("]*");
                    continue block6;
                }
                case '?': {
                    dst.append("[^");
                    dst.append(separator);
                    dst.append("]");
                    continue block6;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    dst.append('\\').append(c);
                    continue block6;
                }
                case '\\': {
                    i = WildcardMatcher.doubleSlashes(dst, src, i);
                    continue block6;
                }
            }
            dst.append(c);
        }
        return dst.toString();
    }

    private static int doubleSlashes(StringBuilder dst, char[] src, int i) {
        dst.append('\\');
        if (i + 1 < src.length) {
            dst.append('\\');
            dst.append(src[i]);
            ++i;
        } else {
            dst.append('\\');
        }
        return i;
    }
}

