/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.HashSet;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class IDFilter
extends StartTagBuffer {
    private String requiredId;
    private int activeDepth = 0;
    private boolean matched = false;
    private HashSet<SimpleType> nonIDs;

    public IDFilter(Receiver next, String id) {
        super(next);
        this.requiredId = id;
    }

    public void startElement(NodeName nameCode, SchemaType typeCode, int locationId, int properties) throws XPathException {
        this.matched = false;
        if (this.activeDepth > 0) {
            ++this.activeDepth;
        }
        super.startElement(nameCode, typeCode, locationId, properties);
    }

    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        super.attribute(attName, typeCode, value, locationId, properties);
        if ((attName.equals(StandardNames.XML_ID_NAME) || (properties & 0x800) != 0) && value.toString().equals(this.requiredId)) {
            this.matched = true;
        }
    }

    public void startContent() throws XPathException {
        if (this.activeDepth > 0) {
            super.startContent();
        } else if (this.matched) {
            this.activeDepth = 1;
            super.startContent();
        }
    }

    protected void declareNamespacesForStartElement() throws XPathException {
        if (this.activeDepth == 1) {
            this.declareAllNamespaces();
        } else {
            super.declareNamespacesForStartElement();
        }
    }

    public void endElement() throws XPathException {
        if (this.activeDepth > 0) {
            this.nextReceiver.endElement();
            --this.activeDepth;
        } else {
            this.undeclareNamespacesForElement();
        }
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.activeDepth > 0) {
            super.characters(chars, locationId, properties);
        }
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        if (this.activeDepth > 0) {
            super.processingInstruction(target, data, locationId, properties);
        }
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.activeDepth > 0) {
            super.comment(chars, locationId, properties);
        }
    }

    public boolean usesTypeAnnotations() {
        return true;
    }

    private boolean isIDCode(SimpleType typeCode) {
        if (typeCode == BuiltInAtomicType.ID) {
            return true;
        }
        if (typeCode instanceof BuiltInAtomicType) {
            return false;
        }
        if (this.nonIDs == null) {
            this.nonIDs = new HashSet(20);
        }
        if (this.nonIDs.contains(typeCode)) {
            return false;
        }
        if (typeCode.isAtomicType()) {
            if (this.getConfiguration().getTypeHierarchy().isSubType((AtomicType)typeCode, BuiltInAtomicType.ID)) {
                return true;
            }
            this.nonIDs.add(typeCode);
            return false;
        }
        return false;
    }
}

