/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

public interface EncodingCodes {
    public static final byte DESCRIBED_TYPE_INDICATOR = 0;
    public static final byte NULL = 64;
    public static final byte BOOLEAN = 86;
    public static final byte BOOLEAN_TRUE = 65;
    public static final byte BOOLEAN_FALSE = 66;
    public static final byte UBYTE = 80;
    public static final byte USHORT = 96;
    public static final byte UINT = 112;
    public static final byte SMALLUINT = 82;
    public static final byte UINT0 = 67;
    public static final byte ULONG = -128;
    public static final byte SMALLULONG = 83;
    public static final byte ULONG0 = 68;
    public static final byte BYTE = 81;
    public static final byte SHORT = 97;
    public static final byte INT = 113;
    public static final byte SMALLINT = 84;
    public static final byte LONG = -127;
    public static final byte SMALLLONG = 85;
    public static final byte FLOAT = 114;
    public static final byte DOUBLE = -126;
    public static final byte DECIMAL32 = 116;
    public static final byte DECIMAL64 = -124;
    public static final byte DECIMAL128 = -108;
    public static final byte CHAR = 115;
    public static final byte TIMESTAMP = -125;
    public static final byte UUID = -104;
    public static final byte VBIN8 = -96;
    public static final byte VBIN32 = -80;
    public static final byte STR8 = -95;
    public static final byte STR32 = -79;
    public static final byte SYM8 = -93;
    public static final byte SYM32 = -77;
    public static final byte LIST0 = 69;
    public static final byte LIST8 = -64;
    public static final byte LIST32 = -48;
    public static final byte MAP8 = -63;
    public static final byte MAP32 = -47;
    public static final byte ARRAY8 = -32;
    public static final byte ARRAY32 = -16;

    public static String toString(byte encoding) {
        switch (encoding) {
            case 0: {
                return "DESCRIBED_TYPE_INDICATOR:0x00";
            }
            case 64: {
                return "NULL:0x40";
            }
            case 86: {
                return "BOOLEAN:0x56";
            }
            case 65: {
                return "BOOLEAN_TRUE:0x41";
            }
            case 66: {
                return "BOOLEAN_FALSE:0x42";
            }
            case 80: {
                return "UBYTE:0x50";
            }
            case 96: {
                return "USHORT:0x60";
            }
            case 112: {
                return "UINT:0x70";
            }
            case 82: {
                return "SMALLUINT:0x52";
            }
            case 67: {
                return "UINT0:0x43";
            }
            case -128: {
                return "ULONG:0x80";
            }
            case 83: {
                return "SMALLULONG:0x53";
            }
            case 68: {
                return "ULONG0:0x44";
            }
            case 81: {
                return "BYTE:0x51";
            }
            case 97: {
                return "SHORT:0x61";
            }
            case 113: {
                return "INT:0x71";
            }
            case 84: {
                return "SMALLINT:0x54";
            }
            case -127: {
                return "LONG:0x81";
            }
            case 85: {
                return "SMALLLONG:0x55";
            }
            case 114: {
                return "FLOAT:0x72";
            }
            case -126: {
                return "DOUBLE:0x82";
            }
            case 116: {
                return "DECIMAL32:0x74";
            }
            case -124: {
                return "DECIMAL64:0x84";
            }
            case -108: {
                return "DECIMAL128:0x94";
            }
            case 115: {
                return "CHAR:0x73";
            }
            case -125: {
                return "TIMESTAMP:0x83";
            }
            case -104: {
                return "UUID:0x98";
            }
            case -96: {
                return "VBIN8:0xa0";
            }
            case -80: {
                return "VBIN32:0xb0";
            }
            case -95: {
                return "STR8:0xa1";
            }
            case -79: {
                return "STR32:0xb1";
            }
            case -93: {
                return "SYM8:0xa3";
            }
            case -77: {
                return "SYM32:0xb3";
            }
            case 69: {
                return "LIST0:0x45";
            }
            case -64: {
                return "LIST8:0xc0";
            }
            case -48: {
                return "LIST32:0xd0";
            }
            case -63: {
                return "MAP8:0xc1";
            }
            case -47: {
                return "MAP32:0xd1";
            }
            case -32: {
                return "ARRAY32:0xe0";
            }
            case -16: {
                return "ARRAY32:0xf0";
            }
        }
        return "Unknown-Type:" + String.format("0x%02X ", encoding);
    }
}

