/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;

public class VkDisplayModeParametersKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VISIBLEREGION;
    public static final int REFRESHRATE;

    public VkDisplayModeParametersKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDisplayModeParametersKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public VkExtent2D visibleRegion() {
        return VkDisplayModeParametersKHR.nvisibleRegion(this.address());
    }

    @NativeType(value="uint32_t")
    public int refreshRate() {
        return VkDisplayModeParametersKHR.nrefreshRate(this.address());
    }

    public VkDisplayModeParametersKHR visibleRegion(VkExtent2D value) {
        VkDisplayModeParametersKHR.nvisibleRegion(this.address(), value);
        return this;
    }

    public VkDisplayModeParametersKHR visibleRegion(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.visibleRegion());
        return this;
    }

    public VkDisplayModeParametersKHR refreshRate(@NativeType(value="uint32_t") int value) {
        VkDisplayModeParametersKHR.nrefreshRate(this.address(), value);
        return this;
    }

    public VkDisplayModeParametersKHR set(VkExtent2D visibleRegion, int refreshRate) {
        this.visibleRegion(visibleRegion);
        this.refreshRate(refreshRate);
        return this;
    }

    public VkDisplayModeParametersKHR set(VkDisplayModeParametersKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDisplayModeParametersKHR malloc() {
        return (VkDisplayModeParametersKHR)VkDisplayModeParametersKHR.wrap(VkDisplayModeParametersKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkDisplayModeParametersKHR calloc() {
        return (VkDisplayModeParametersKHR)VkDisplayModeParametersKHR.wrap(VkDisplayModeParametersKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkDisplayModeParametersKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkDisplayModeParametersKHR)VkDisplayModeParametersKHR.wrap(VkDisplayModeParametersKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkDisplayModeParametersKHR create(long address) {
        return (VkDisplayModeParametersKHR)VkDisplayModeParametersKHR.wrap(VkDisplayModeParametersKHR.class, (long)address);
    }

    @Nullable
    public static VkDisplayModeParametersKHR createSafe(long address) {
        return address == 0L ? null : (VkDisplayModeParametersKHR)VkDisplayModeParametersKHR.wrap(VkDisplayModeParametersKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkDisplayModeParametersKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkDisplayModeParametersKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkDisplayModeParametersKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDisplayModeParametersKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkDisplayModeParametersKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkDisplayModeParametersKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkDisplayModeParametersKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkDisplayModeParametersKHR mallocStack() {
        return VkDisplayModeParametersKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDisplayModeParametersKHR callocStack() {
        return VkDisplayModeParametersKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDisplayModeParametersKHR mallocStack(MemoryStack stack) {
        return VkDisplayModeParametersKHR.malloc(stack);
    }

    @Deprecated
    public static VkDisplayModeParametersKHR callocStack(MemoryStack stack) {
        return VkDisplayModeParametersKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDisplayModeParametersKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDisplayModeParametersKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDisplayModeParametersKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDisplayModeParametersKHR.calloc(capacity, stack);
    }

    public static VkDisplayModeParametersKHR malloc(MemoryStack stack) {
        return (VkDisplayModeParametersKHR)VkDisplayModeParametersKHR.wrap(VkDisplayModeParametersKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDisplayModeParametersKHR calloc(MemoryStack stack) {
        return (VkDisplayModeParametersKHR)VkDisplayModeParametersKHR.wrap(VkDisplayModeParametersKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkDisplayModeParametersKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkDisplayModeParametersKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static VkExtent2D nvisibleRegion(long struct) {
        return VkExtent2D.create(struct + (long)VISIBLEREGION);
    }

    public static int nrefreshRate(long struct) {
        return UNSAFE.getInt(null, struct + (long)REFRESHRATE);
    }

    public static void nvisibleRegion(long struct, VkExtent2D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)VISIBLEREGION), (long)VkExtent2D.SIZEOF);
    }

    public static void nrefreshRate(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)REFRESHRATE, value);
    }

    static {
        Struct.Layout layout = VkDisplayModeParametersKHR.__struct((Struct.Member[])new Struct.Member[]{VkDisplayModeParametersKHR.__member((int)VkExtent2D.SIZEOF, (int)VkExtent2D.ALIGNOF), VkDisplayModeParametersKHR.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VISIBLEREGION = layout.offsetof(0);
        REFRESHRATE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkDisplayModeParametersKHR, Buffer>
    implements NativeResource {
        private static final VkDisplayModeParametersKHR ELEMENT_FACTORY = VkDisplayModeParametersKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDisplayModeParametersKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkExtent2D visibleRegion() {
            return VkDisplayModeParametersKHR.nvisibleRegion(this.address());
        }

        @NativeType(value="uint32_t")
        public int refreshRate() {
            return VkDisplayModeParametersKHR.nrefreshRate(this.address());
        }

        public Buffer visibleRegion(VkExtent2D value) {
            VkDisplayModeParametersKHR.nvisibleRegion(this.address(), value);
            return this;
        }

        public Buffer visibleRegion(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.visibleRegion());
            return this;
        }

        public Buffer refreshRate(@NativeType(value="uint32_t") int value) {
            VkDisplayModeParametersKHR.nrefreshRate(this.address(), value);
            return this;
        }
    }
}

