/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPassthroughFB;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrPassthroughLayerCreateInfoFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int PASSTHROUGH;
    public static final int FLAGS;
    public static final int PURPOSE;

    public XrPassthroughLayerCreateInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrPassthroughLayerCreateInfoFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrPassthroughLayerCreateInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrPassthroughLayerCreateInfoFB.nnext(this.address());
    }

    @NativeType(value="XrPassthroughFB")
    public long passthrough() {
        return XrPassthroughLayerCreateInfoFB.npassthrough(this.address());
    }

    @NativeType(value="XrPassthroughFlagsFB")
    public long flags() {
        return XrPassthroughLayerCreateInfoFB.nflags(this.address());
    }

    @NativeType(value="XrPassthroughLayerPurposeFB")
    public int purpose() {
        return XrPassthroughLayerCreateInfoFB.npurpose(this.address());
    }

    public XrPassthroughLayerCreateInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrPassthroughLayerCreateInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrPassthroughLayerCreateInfoFB type$Default() {
        return this.type(1000118002);
    }

    public XrPassthroughLayerCreateInfoFB next(@NativeType(value="void const *") long value) {
        XrPassthroughLayerCreateInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrPassthroughLayerCreateInfoFB passthrough(XrPassthroughFB value) {
        XrPassthroughLayerCreateInfoFB.npassthrough(this.address(), value);
        return this;
    }

    public XrPassthroughLayerCreateInfoFB flags(@NativeType(value="XrPassthroughFlagsFB") long value) {
        XrPassthroughLayerCreateInfoFB.nflags(this.address(), value);
        return this;
    }

    public XrPassthroughLayerCreateInfoFB purpose(@NativeType(value="XrPassthroughLayerPurposeFB") int value) {
        XrPassthroughLayerCreateInfoFB.npurpose(this.address(), value);
        return this;
    }

    public XrPassthroughLayerCreateInfoFB set(int type, long next, XrPassthroughFB passthrough, long flags, int purpose) {
        this.type(type);
        this.next(next);
        this.passthrough(passthrough);
        this.flags(flags);
        this.purpose(purpose);
        return this;
    }

    public XrPassthroughLayerCreateInfoFB set(XrPassthroughLayerCreateInfoFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrPassthroughLayerCreateInfoFB malloc() {
        return (XrPassthroughLayerCreateInfoFB)XrPassthroughLayerCreateInfoFB.wrap(XrPassthroughLayerCreateInfoFB.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrPassthroughLayerCreateInfoFB calloc() {
        return (XrPassthroughLayerCreateInfoFB)XrPassthroughLayerCreateInfoFB.wrap(XrPassthroughLayerCreateInfoFB.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrPassthroughLayerCreateInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrPassthroughLayerCreateInfoFB)XrPassthroughLayerCreateInfoFB.wrap(XrPassthroughLayerCreateInfoFB.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrPassthroughLayerCreateInfoFB create(long address) {
        return (XrPassthroughLayerCreateInfoFB)XrPassthroughLayerCreateInfoFB.wrap(XrPassthroughLayerCreateInfoFB.class, (long)address);
    }

    @Nullable
    public static XrPassthroughLayerCreateInfoFB createSafe(long address) {
        return address == 0L ? null : (XrPassthroughLayerCreateInfoFB)XrPassthroughLayerCreateInfoFB.wrap(XrPassthroughLayerCreateInfoFB.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrPassthroughLayerCreateInfoFB.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrPassthroughLayerCreateInfoFB.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrPassthroughLayerCreateInfoFB.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrPassthroughLayerCreateInfoFB.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrPassthroughLayerCreateInfoFB.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrPassthroughLayerCreateInfoFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrPassthroughLayerCreateInfoFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrPassthroughLayerCreateInfoFB malloc(MemoryStack stack) {
        return (XrPassthroughLayerCreateInfoFB)XrPassthroughLayerCreateInfoFB.wrap(XrPassthroughLayerCreateInfoFB.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrPassthroughLayerCreateInfoFB calloc(MemoryStack stack) {
        return (XrPassthroughLayerCreateInfoFB)XrPassthroughLayerCreateInfoFB.wrap(XrPassthroughLayerCreateInfoFB.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrPassthroughLayerCreateInfoFB.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrPassthroughLayerCreateInfoFB.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long npassthrough(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PASSTHROUGH));
    }

    public static long nflags(long struct) {
        return UNSAFE.getLong(null, struct + (long)FLAGS);
    }

    public static int npurpose(long struct) {
        return UNSAFE.getInt(null, struct + (long)PURPOSE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void npassthrough(long struct, XrPassthroughFB value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PASSTHROUGH), (long)value.address());
    }

    public static void nflags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)FLAGS, value);
    }

    public static void npurpose(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PURPOSE, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PASSTHROUGH)));
    }

    static {
        Struct.Layout layout = XrPassthroughLayerCreateInfoFB.__struct((Struct.Member[])new Struct.Member[]{XrPassthroughLayerCreateInfoFB.__member((int)4), XrPassthroughLayerCreateInfoFB.__member((int)POINTER_SIZE), XrPassthroughLayerCreateInfoFB.__member((int)POINTER_SIZE), XrPassthroughLayerCreateInfoFB.__member((int)8), XrPassthroughLayerCreateInfoFB.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        PASSTHROUGH = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
        PURPOSE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrPassthroughLayerCreateInfoFB, Buffer>
    implements NativeResource {
        private static final XrPassthroughLayerCreateInfoFB ELEMENT_FACTORY = XrPassthroughLayerCreateInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrPassthroughLayerCreateInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrPassthroughLayerCreateInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrPassthroughLayerCreateInfoFB.nnext(this.address());
        }

        @NativeType(value="XrPassthroughFB")
        public long passthrough() {
            return XrPassthroughLayerCreateInfoFB.npassthrough(this.address());
        }

        @NativeType(value="XrPassthroughFlagsFB")
        public long flags() {
            return XrPassthroughLayerCreateInfoFB.nflags(this.address());
        }

        @NativeType(value="XrPassthroughLayerPurposeFB")
        public int purpose() {
            return XrPassthroughLayerCreateInfoFB.npurpose(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrPassthroughLayerCreateInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000118002);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrPassthroughLayerCreateInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer passthrough(XrPassthroughFB value) {
            XrPassthroughLayerCreateInfoFB.npassthrough(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="XrPassthroughFlagsFB") long value) {
            XrPassthroughLayerCreateInfoFB.nflags(this.address(), value);
            return this;
        }

        public Buffer purpose(@NativeType(value="XrPassthroughLayerPurposeFB") int value) {
            XrPassthroughLayerCreateInfoFB.npurpose(this.address(), value);
            return this;
        }
    }
}

