/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class Lint {
    protected static final Context.Key<Lint> lintKey = new Context.Key();
    private final Context context;
    private final Options options;
    private final Log log;
    private Symtab syms;
    private Names names;
    private EnumSet<LintCategory> values;
    private EnumSet<LintCategory> suppressedValues;
    private static final Map<String, LintCategory> map = new LinkedHashMap<String, LintCategory>(40);

    public static Lint instance(Context context) {
        Lint instance = context.get(lintKey);
        if (instance == null) {
            instance = new Lint(context);
        }
        return instance;
    }

    public Lint augment(Symbol sym) {
        EnumSet<LintCategory> suppressions = this.suppressionsFrom(sym);
        if (!suppressions.isEmpty()) {
            Lint lint = new Lint(this);
            lint.values.removeAll(suppressions);
            lint.suppressedValues.addAll(suppressions);
            return lint;
        }
        return this;
    }

    public Lint enable(LintCategory ... lc) {
        Lint l = new Lint(this);
        l.values.addAll(Arrays.asList(lc));
        l.suppressedValues.removeAll(Arrays.asList(lc));
        return l;
    }

    public Lint suppress(LintCategory ... lc) {
        Lint l = new Lint(this);
        l.values.removeAll(Arrays.asList(lc));
        l.suppressedValues.addAll(Arrays.asList(lc));
        return l;
    }

    protected Lint(Context context) {
        this.context = context;
        context.put(lintKey, this);
        this.options = Options.instance(context);
        this.log = Log.instance(context);
    }

    protected Lint(Lint other) {
        other.initializeRootIfNeeded();
        this.context = other.context;
        this.options = other.options;
        this.log = other.log;
        this.syms = other.syms;
        this.names = other.names;
        this.values = other.values.clone();
        this.suppressedValues = other.suppressedValues.clone();
    }

    private void initializeRootIfNeeded() {
        if (this.values == null) {
            this.values = this.options.getLintCategoriesOf(Option.XLINT, this::getDefaults);
            this.suppressedValues = LintCategory.newEmptySet();
        }
    }

    private EnumSet<LintCategory> getDefaults() {
        EnumSet<LintCategory> defaults = LintCategory.newEmptySet();
        Source source = Source.instance(this.context);
        Stream.of(LintCategory.values()).filter(lc -> {
            boolean bl;
            switch (lc.ordinal()) {
                case 5: {
                    if (source.compareTo(Source.JDK9) >= 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 29: {
                    bl = Source.Feature.REDUNDANT_STRICTFP.allowedInSource(source);
                    break;
                }
                case 35: {
                    if (!this.options.isSet(Option.PREVIEW)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = lc.enabledByDefault;
                }
            }
            return bl;
        }).forEach(defaults::add);
        return defaults;
    }

    public String toString() {
        this.initializeRootIfNeeded();
        return "Lint:[enable" + this.values + ",suppress" + this.suppressedValues + "]";
    }

    public boolean isEnabled(LintCategory lc) {
        this.initializeRootIfNeeded();
        return this.values.contains((Object)lc);
    }

    public boolean isSuppressed(LintCategory lc) {
        this.initializeRootIfNeeded();
        return this.suppressedValues.contains((Object)lc);
    }

    public EnumSet<LintCategory> suppressionsFrom(Symbol symbol) {
        EnumSet<LintCategory> suppressions = this.suppressionsFrom(symbol.getDeclarationAttributes().stream());
        if (symbol.isDeprecated() && symbol.isDeprecatableViaAnnotation()) {
            suppressions.add(LintCategory.DEPRECATION);
        }
        return suppressions;
    }

    private EnumSet<LintCategory> suppressionsFrom(Stream<Attribute.Compound> attributes) {
        this.initializeSymbolsIfNeeded();
        EnumSet<LintCategory> result = LintCategory.newEmptySet();
        attributes.filter(attribute -> attribute.type.tsym == this.syms.suppressWarningsType.tsym).map(this::suppressionsFrom).forEach(result::addAll);
        return result;
    }

    private EnumSet<LintCategory> suppressionsFrom(Attribute.Compound suppressWarnings) {
        EnumSet<LintCategory> result = LintCategory.newEmptySet();
        Attribute[] attributeArray = suppressWarnings.member(this.names.value);
        if (attributeArray instanceof Attribute.Array) {
            Attribute.Array values = (Attribute.Array)attributeArray;
            for (Attribute value : values.values) {
                Optional.of(value).filter(val -> val instanceof Attribute.Constant).map(val -> (String)((Attribute.Constant)val).value).flatMap(LintCategory::get).filter(lc -> lc.annotationSuppression).ifPresent(result::add);
            }
        }
        return result;
    }

    private void initializeSymbolsIfNeeded() {
        if (this.syms == null) {
            this.syms = Symtab.instance(this.context);
            this.names = Names.instance(this.context);
        }
    }

    public static enum LintCategory {
        AUXILIARYCLASS("auxiliaryclass"),
        CAST("cast"),
        CLASSFILE("classfile", false, false, new String[0]),
        DANGLING_DOC_COMMENTS("dangling-doc-comments"),
        DEPRECATION("deprecation"),
        DEP_ANN("dep-ann", true, true, new String[0]),
        DIVZERO("divzero"),
        EMPTY("empty"),
        EXPORTS("exports"),
        FALLTHROUGH("fallthrough"),
        FINALLY("finally"),
        IDENTITY("identity", true, true, "synchronization"),
        INCUBATING("incubating", false, true, new String[0]),
        LOSSY_CONVERSIONS("lossy-conversions"),
        MISSING_EXPLICIT_CTOR("missing-explicit-ctor"),
        MODULE("module", true, true, new String[0]),
        OPENS("opens", true, true, new String[0]),
        OPTIONS("options", false, false, new String[0]),
        OUTPUT_FILE_CLASH("output-file-clash", false, false, new String[0]),
        OVERLOADS("overloads"),
        OVERRIDES("overrides"),
        PATH("path", false, false, new String[0]),
        PROCESSING("processing", false, false, new String[0]),
        RAW("rawtypes"),
        REMOVAL("removal", true, true, new String[0]),
        REQUIRES_AUTOMATIC("requires-automatic"),
        REQUIRES_TRANSITIVE_AUTOMATIC("requires-transitive-automatic", true, true, new String[0]),
        SERIAL("serial"),
        STATIC("static"),
        STRICTFP("strictfp", true, true, new String[0]),
        TEXT_BLOCKS("text-blocks"),
        THIS_ESCAPE("this-escape"),
        TRY("try"),
        UNCHECKED("unchecked"),
        VARARGS("varargs"),
        PREVIEW("preview", true, true, new String[0]),
        RESTRICTED("restricted");

        public final String option;
        public final List<String> optionList;
        public final boolean annotationSuppression;
        public final boolean enabledByDefault;

        private LintCategory(String option) {
            this(option, true, false, new String[0]);
        }

        private LintCategory(String option, boolean annotationSuppression, boolean enabledByDefault, String ... aliases) {
            this.option = option;
            this.annotationSuppression = annotationSuppression;
            this.enabledByDefault = enabledByDefault;
            ArrayList<String> optionList = new ArrayList<String>(1 + aliases.length);
            optionList.add(option);
            Collections.addAll(optionList, aliases);
            this.optionList = Collections.unmodifiableList(optionList);
            this.optionList.forEach(ident -> map.put(ident, this));
        }

        public static Optional<LintCategory> get(String option) {
            return Optional.ofNullable((LintCategory)((Object)map.get(option)));
        }

        public static Set<String> options() {
            return Collections.unmodifiableSet(map.keySet());
        }

        public static EnumSet<LintCategory> newEmptySet() {
            return EnumSet.noneOf(LintCategory.class);
        }
    }
}

