/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.ExhaustivenessComputer;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.ArrayUtils;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Bits;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Consumer;

public class Flow {
    protected static final Context.Key<Flow> flowKey = new Context.Key();
    private final Names names;
    private final Log log;
    private final Symtab syms;
    private final Types types;
    private final Check chk;
    private TreeMaker make;
    private final Resolve rs;
    private final JCDiagnostic.Factory diags;
    private final ExhaustivenessComputer exhaustiveness;
    private Env<AttrContext> attrEnv;

    public static Flow instance(Context context) {
        Flow instance = context.get(flowKey);
        if (instance == null) {
            instance = new Flow(context);
        }
        return instance;
    }

    public void analyzeTree(Env<AttrContext> env, TreeMaker make) {
        new AliveAnalyzer().analyzeTree(env, make);
        new AssignAnalyzer().analyzeTree(env, make);
        new FlowAnalyzer().analyzeTree(env, make);
        new CaptureAnalyzer().analyzeTree(env, make);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeLambda(Env<AttrContext> env, JCTree.JCLambda that, TreeMaker make, boolean speculative) {
        Log.DiscardDiagnosticHandler diagHandler = null;
        if (!speculative) {
            diagHandler = new Log.DiscardDiagnosticHandler(this.log);
        }
        try {
            new LambdaAliveAnalyzer().analyzeTree(env, that, make);
        }
        finally {
            if (!speculative) {
                this.log.popDiagnosticHandler(diagHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Type> analyzeLambdaThrownTypes(Env<AttrContext> env, JCTree.JCLambda that, TreeMaker make) {
        Log.DiscardDiagnosticHandler diagHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            new LambdaAssignAnalyzer(env).analyzeTree(env, that, make);
            LambdaFlowAnalyzer flowAnalyzer = new LambdaFlowAnalyzer();
            flowAnalyzer.analyzeTree(env, that, make);
            List<Type> list = flowAnalyzer.inferredThrownTypes;
            return list;
        }
        finally {
            this.log.popDiagnosticHandler(diagHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean aliveAfter(Env<AttrContext> env, JCTree that, TreeMaker make) {
        Log.DiscardDiagnosticHandler diagHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            SnippetAliveAnalyzer analyzer = new SnippetAliveAnalyzer();
            analyzer.analyzeTree(env, that, make);
            boolean bl = analyzer.isAlive();
            return bl;
        }
        finally {
            this.log.popDiagnosticHandler(diagHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean breaksToTree(Env<AttrContext> env, JCTree breakTo, JCTree body, TreeMaker make) {
        Log.DiscardDiagnosticHandler diagHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            SnippetBreakToAnalyzer analyzer = new SnippetBreakToAnalyzer(breakTo);
            analyzer.analyzeTree(env, body, make);
            boolean bl = analyzer.breaksTo();
            return bl;
        }
        finally {
            this.log.popDiagnosticHandler(diagHandler);
        }
    }

    protected Flow(Context context) {
        context.put(flowKey, this);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
        this.chk = Check.instance(context);
        this.rs = Resolve.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.exhaustiveness = ExhaustivenessComputer.instance(context);
    }

    class AliveAnalyzer
    extends BaseAnalyzer {
        private Liveness alive;

        AliveAnalyzer() {
        }

        @Override
        void markDead() {
            this.alive = Liveness.DEAD;
        }

        void scanDef(JCTree tree) {
            this.scanStat(tree);
            if (tree != null && tree.hasTag(JCTree.Tag.BLOCK) && this.alive == Liveness.DEAD) {
                Flow.this.log.error(tree.pos(), CompilerProperties.Errors.InitializerMustBeAbleToCompleteNormally);
            }
        }

        void scanStat(JCTree tree) {
            if (this.alive == Liveness.DEAD && tree != null) {
                Flow.this.log.error(tree.pos(), CompilerProperties.Errors.UnreachableStmt);
                if (!tree.hasTag(JCTree.Tag.SKIP)) {
                    this.alive = Liveness.RECOVERY;
                }
            }
            this.scan(tree);
        }

        void scanStats(List<? extends JCTree.JCStatement> trees) {
            if (trees != null) {
                List<JCTree.JCStatement> l = trees;
                while (l.nonEmpty()) {
                    this.scanStat((JCTree)l.head);
                    l = l.tail;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            if (tree.sym == null) {
                return;
            }
            Liveness alivePrev = this.alive;
            ListBuffer pendingExitsPrev = this.pendingExits;
            this.pendingExits = new ListBuffer();
            try {
                List<JCTree> l = tree.defs;
                while (l.nonEmpty()) {
                    if (((JCTree)l.head).hasTag(JCTree.Tag.CLASSDEF)) {
                        this.scan((JCTree)l.head);
                    }
                    l = l.tail;
                }
                this.forEachInitializer(tree, true, def -> {
                    this.scanDef((JCTree)def);
                    this.clearPendingExits(false);
                });
                this.forEachInitializer(tree, false, def -> {
                    this.scanDef((JCTree)def);
                    this.clearPendingExits(false);
                });
                l = tree.defs;
                while (l.nonEmpty()) {
                    if (((JCTree)l.head).hasTag(JCTree.Tag.METHODDEF)) {
                        this.scan((JCTree)l.head);
                    }
                    l = l.tail;
                }
            }
            finally {
                this.pendingExits = pendingExitsPrev;
                this.alive = alivePrev;
            }
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            if (tree.body == null) {
                return;
            }
            Assert.check(this.pendingExits.isEmpty());
            this.alive = Liveness.ALIVE;
            this.scanStat(tree.body);
            boolean bl = tree.completesNormally = this.alive != Liveness.DEAD;
            if (this.alive == Liveness.ALIVE && !tree.sym.type.getReturnType().hasTag(TypeTag.VOID)) {
                Flow.this.log.error(TreeInfo.diagEndPos(tree.body), CompilerProperties.Errors.MissingRetStmt);
            }
            this.clearPendingExits(true);
        }

        private void clearPendingExits(boolean inMethod) {
            List exits = this.pendingExits.toList();
            this.pendingExits = new ListBuffer();
            while (exits.nonEmpty()) {
                BaseAnalyzer.PendingExit exit = (BaseAnalyzer.PendingExit)exits.head;
                exits = exits.tail;
                Assert.check(inMethod && exit.tree.hasTag(JCTree.Tag.RETURN) || Flow.this.log.hasErrorOn(exit.tree.pos()));
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            this.scan(tree.init);
        }

        @Override
        public void visitBlock(JCTree.JCBlock tree) {
            this.scanStats(tree.stats);
        }

        @Override
        public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scanStat(tree.body);
            this.alive = this.alive.or(this.resolveContinues(tree));
            this.scan(tree.cond);
            this.alive = this.alive.and(!tree.cond.type.isTrue());
            this.alive = this.alive.or(this.resolveBreaks(tree, prevPendingExits));
        }

        @Override
        public void visitWhileLoop(JCTree.JCWhileLoop tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(tree.cond);
            this.alive = Liveness.from(!tree.cond.type.isFalse());
            this.scanStat(tree.body);
            this.alive = this.alive.or(this.resolveContinues(tree));
            this.alive = this.resolveBreaks(tree, prevPendingExits).or(!tree.cond.type.isTrue());
        }

        @Override
        public void visitForLoop(JCTree.JCForLoop tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            this.scanStats(tree.init);
            this.pendingExits = new ListBuffer();
            if (tree.cond != null) {
                this.scan(tree.cond);
                this.alive = Liveness.from(!tree.cond.type.isFalse());
            } else {
                this.alive = Liveness.ALIVE;
            }
            this.scanStat(tree.body);
            this.alive = this.alive.or(this.resolveContinues(tree));
            this.scan(tree.step);
            this.alive = this.resolveBreaks(tree, prevPendingExits).or(tree.cond != null && !tree.cond.type.isTrue());
        }

        @Override
        public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
            this.visitVarDef(tree.var);
            ListBuffer prevPendingExits = this.pendingExits;
            this.scan(tree.expr);
            this.pendingExits = new ListBuffer();
            this.scanStat(tree.body);
            this.alive = this.alive.or(this.resolveContinues(tree));
            this.resolveBreaks(tree, prevPendingExits);
            this.alive = Liveness.ALIVE;
        }

        @Override
        public void visitLabelled(JCTree.JCLabeledStatement tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scanStat(tree.body);
            this.alive = this.alive.or(this.resolveBreaks(tree, prevPendingExits));
        }

        @Override
        public void visitSwitch(JCTree.JCSwitch tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(tree.selector);
            boolean exhaustiveSwitch = TreeInfo.expectedExhaustive(tree);
            List<JCTree.JCCase> l = tree.cases;
            while (l.nonEmpty()) {
                this.alive = Liveness.ALIVE;
                JCTree.JCCase c = (JCTree.JCCase)l.head;
                for (JCTree.JCCaseLabel pat : c.labels) {
                    this.scan(pat);
                }
                this.scanStats(c.stats);
                if (this.alive != Liveness.DEAD && c.caseKind == JCTree.JCCase.RULE) {
                    this.scanSyntheticBreak(Flow.this.make, tree);
                    this.alive = Liveness.DEAD;
                }
                if (this.alive == Liveness.ALIVE && c.stats.nonEmpty() && l.tail.nonEmpty()) {
                    Flow.this.log.warning(((JCTree.JCCase)l.tail.head).pos(), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.PossibleFallThroughIntoCase);
                }
                l = l.tail;
            }
            boolean bl = tree.isExhaustive = tree.hasUnconditionalPattern || TreeInfo.isErrorEnumSwitch(tree.selector, tree.cases);
            if (exhaustiveSwitch) {
                tree.isExhaustive |= Flow.this.exhaustiveness.exhausts(tree.selector, tree.cases);
                if (!tree.isExhaustive) {
                    Flow.this.log.error(tree, CompilerProperties.Errors.NotExhaustiveStatement);
                }
            }
            if (!tree.hasUnconditionalPattern && !exhaustiveSwitch) {
                this.alive = Liveness.ALIVE;
            }
            this.alive = this.alive.or(this.resolveBreaks(tree, prevPendingExits));
        }

        @Override
        public void visitSwitchExpression(JCTree.JCSwitchExpression tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(tree.selector);
            Liveness prevAlive = this.alive;
            List<JCTree.JCCase> l = tree.cases;
            while (l.nonEmpty()) {
                this.alive = Liveness.ALIVE;
                JCTree.JCCase c = (JCTree.JCCase)l.head;
                for (JCTree.JCCaseLabel pat : c.labels) {
                    this.scan(pat);
                }
                this.scanStats(c.stats);
                if (this.alive == Liveness.ALIVE) {
                    if (c.caseKind == JCTree.JCCase.RULE) {
                        Flow.this.log.error(TreeInfo.diagEndPos(c.body), CompilerProperties.Errors.RuleCompletesNormally);
                    } else if (l.tail.isEmpty()) {
                        Flow.this.log.error(TreeInfo.diagEndPos(tree), CompilerProperties.Errors.SwitchExpressionCompletesNormally);
                    }
                }
                l = l.tail;
            }
            tree.isExhaustive = tree.hasUnconditionalPattern || TreeInfo.isErrorEnumSwitch(tree.selector, tree.cases) ? true : Flow.this.exhaustiveness.exhausts(tree.selector, tree.cases);
            if (!tree.isExhaustive) {
                Flow.this.log.error(tree, CompilerProperties.Errors.NotExhaustive);
            }
            this.alive = prevAlive;
            this.alive = this.alive.or(this.resolveYields(tree, prevPendingExits));
        }

        @Override
        public void visitTry(JCTree.JCTry tree) {
            ListBuffer exits;
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            for (JCTree resource : tree.resources) {
                if (resource instanceof JCTree.JCVariableDecl) {
                    JCTree.JCVariableDecl variableDecl = (JCTree.JCVariableDecl)resource;
                    this.visitVarDef(variableDecl);
                    continue;
                }
                if (resource instanceof JCTree.JCExpression) {
                    JCTree.JCExpression expression = (JCTree.JCExpression)resource;
                    this.scan(expression);
                    continue;
                }
                throw new AssertionError(tree);
            }
            this.scanStat(tree.body);
            Liveness aliveEnd = this.alive;
            List<JCTree.JCCatch> l = tree.catchers;
            while (l.nonEmpty()) {
                this.alive = Liveness.ALIVE;
                JCTree.JCVariableDecl param = ((JCTree.JCCatch)l.head).param;
                this.scan(param);
                this.scanStat(((JCTree.JCCatch)l.head).body);
                aliveEnd = aliveEnd.or(this.alive);
                l = l.tail;
            }
            if (tree.finalizer != null) {
                exits = this.pendingExits;
                this.pendingExits = prevPendingExits;
                this.alive = Liveness.ALIVE;
                this.scanStat(tree.finalizer);
                boolean bl = tree.finallyCanCompleteNormally = this.alive != Liveness.DEAD;
                if (this.alive == Liveness.DEAD) {
                    Flow.this.log.warning(TreeInfo.diagEndPos(tree.finalizer), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.FinallyCannotComplete);
                } else {
                    while (exits.nonEmpty()) {
                        this.pendingExits.append((BaseAnalyzer.PendingExit)exits.next());
                    }
                    this.alive = aliveEnd;
                }
            } else {
                this.alive = aliveEnd;
                exits = this.pendingExits;
                this.pendingExits = prevPendingExits;
                while (exits.nonEmpty()) {
                    this.pendingExits.append((BaseAnalyzer.PendingExit)exits.next());
                }
            }
        }

        @Override
        public void visitIf(JCTree.JCIf tree) {
            this.scan(tree.cond);
            this.scanStat(tree.thenpart);
            if (tree.elsepart != null) {
                Liveness aliveAfterThen = this.alive;
                this.alive = Liveness.ALIVE;
                this.scanStat(tree.elsepart);
                this.alive = this.alive.or(aliveAfterThen);
            } else {
                this.alive = Liveness.ALIVE;
            }
        }

        @Override
        public void visitBreak(JCTree.JCBreak tree) {
            this.recordExit(new BaseAnalyzer.PendingExit(tree));
        }

        @Override
        public void visitYield(JCTree.JCYield tree) {
            this.scan(tree.value);
            this.recordExit(new BaseAnalyzer.PendingExit(tree));
        }

        @Override
        public void visitContinue(JCTree.JCContinue tree) {
            this.recordExit(new BaseAnalyzer.PendingExit(tree));
        }

        @Override
        public void visitReturn(JCTree.JCReturn tree) {
            this.scan(tree.expr);
            this.recordExit(new BaseAnalyzer.PendingExit(tree));
        }

        @Override
        public void visitThrow(JCTree.JCThrow tree) {
            this.scan(tree.expr);
            this.markDead();
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation tree) {
            this.scan(tree.meth);
            this.scan(tree.args);
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass tree) {
            this.scan(tree.encl);
            this.scan(tree.args);
            if (tree.def != null) {
                this.scan(tree.def);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda tree) {
            if (tree.type != null && tree.type.isErroneous()) {
                return;
            }
            ListBuffer prevPending = this.pendingExits;
            Liveness prevAlive = this.alive;
            try {
                this.pendingExits = new ListBuffer();
                this.alive = Liveness.ALIVE;
                this.scanStat(tree.body);
                tree.canCompleteNormally = this.alive != Liveness.DEAD;
            }
            finally {
                this.pendingExits = prevPending;
                this.alive = prevAlive;
            }
        }

        @Override
        public void visitModuleDef(JCTree.JCModuleDecl tree) {
        }

        public void analyzeTree(Env<AttrContext> env, TreeMaker make) {
            this.analyzeTree(env, env.tree, make);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void analyzeTree(Env<AttrContext> env, JCTree tree, TreeMaker make) {
            try {
                Flow.this.attrEnv = env;
                Flow.this.make = make;
                this.pendingExits = new ListBuffer();
                this.alive = Liveness.ALIVE;
                this.scan(tree);
            }
            finally {
                this.pendingExits = null;
                Flow.this.make = null;
            }
        }
    }

    public class AssignAnalyzer
    extends BaseAnalyzer {
        final Bits inits;
        final Bits uninits;
        final Bits uninitsTry;
        final Bits initsWhenTrue;
        final Bits initsWhenFalse;
        final Bits uninitsWhenTrue;
        final Bits uninitsWhenFalse;
        protected JCTree.JCVariableDecl[] vardecls;
        JCTree.JCClassDecl classDef;
        int firstadr;
        protected int nextadr;
        protected int returnadr;
        Scope.WriteableScope unrefdResources;
        FlowKind flowKind = FlowKind.NORMAL;
        int startPos;
        private boolean isConstructor;

        public AssignAnalyzer() {
            this.inits = new Bits();
            this.uninits = new Bits();
            this.uninitsTry = new Bits();
            this.initsWhenTrue = new Bits(true);
            this.initsWhenFalse = new Bits(true);
            this.uninitsWhenTrue = new Bits(true);
            this.uninitsWhenFalse = new Bits(true);
        }

        @Override
        protected void markDead() {
            this.inits.inclRange(this.returnadr, this.nextadr);
            this.uninits.inclRange(this.returnadr, this.nextadr);
        }

        protected boolean trackable(Symbol.VarSymbol sym) {
            return sym.pos >= this.startPos && (sym.owner.kind == Kinds.Kind.MTH || sym.owner.kind == Kinds.Kind.VAR || this.isFinalUninitializedField(sym));
        }

        boolean isFinalUninitializedField(Symbol.VarSymbol sym) {
            return sym.owner.kind == Kinds.Kind.TYP && (sym.flags() & 0x200040010L) == 16L && this.classDef.sym.isEnclosedBy((Symbol.ClassSymbol)sym.owner);
        }

        void newVar(JCTree.JCVariableDecl varDecl) {
            Symbol.VarSymbol sym = varDecl.sym;
            this.vardecls = ArrayUtils.ensureCapacity(this.vardecls, this.nextadr);
            if ((sym.flags() & 0x10L) == 0L) {
                sym.flags_field |= 0x20000000000L;
            }
            sym.adr = this.nextadr;
            this.vardecls[this.nextadr] = varDecl;
            this.inits.excl(this.nextadr);
            this.uninits.incl(this.nextadr);
            ++this.nextadr;
        }

        void letInit(JCDiagnostic.DiagnosticPosition pos, Symbol.VarSymbol sym) {
            if (sym.adr >= this.firstadr && this.trackable(sym)) {
                if ((sym.flags() & 0x20000000000L) != 0L) {
                    if (!this.uninits.isMember(sym.adr)) {
                        sym.flags_field &= 0xFFFFFDFFFFFFFFFFL;
                    } else {
                        this.uninit(sym);
                    }
                } else if ((sym.flags() & 0x10L) != 0L) {
                    if ((sym.flags() & 0x200000000L) != 0L) {
                        if ((sym.flags() & 0x8000000000L) != 0L) {
                            Flow.this.log.error(pos, CompilerProperties.Errors.MulticatchParameterMayNotBeAssigned(sym));
                        } else {
                            Flow.this.log.error(pos, CompilerProperties.Errors.FinalParameterMayNotBeAssigned(sym));
                        }
                    } else if (!this.uninits.isMember(sym.adr)) {
                        Flow.this.log.error(pos, Flow.this.diags.errorKey(this.flowKind.errKey, sym));
                    } else {
                        this.uninit(sym);
                    }
                }
                this.inits.incl(sym.adr);
            } else if ((sym.flags() & 0x10L) != 0L) {
                Flow.this.log.error(pos, CompilerProperties.Errors.VarMightAlreadyBeAssigned(sym));
            }
        }

        void uninit(Symbol.VarSymbol sym) {
            if (!this.inits.isMember(sym.adr)) {
                this.uninits.excl(sym.adr);
                this.uninitsTry.excl(sym.adr);
            } else {
                this.uninits.excl(sym.adr);
            }
        }

        void letInit(JCTree tree) {
            if ((tree = TreeInfo.skipParens(tree)).hasTag(JCTree.Tag.IDENT) || tree.hasTag(JCTree.Tag.SELECT)) {
                Symbol sym = TreeInfo.symbol(tree);
                if (sym.kind == Kinds.Kind.VAR) {
                    this.letInit(tree.pos(), (Symbol.VarSymbol)sym);
                }
            }
        }

        void checkInit(JCDiagnostic.DiagnosticPosition pos, Symbol.VarSymbol sym) {
            this.checkInit(pos, sym, CompilerProperties.Errors.VarMightNotHaveBeenInitialized(sym));
        }

        void checkInit(JCDiagnostic.DiagnosticPosition pos, Symbol.VarSymbol sym, JCDiagnostic.Error errkey) {
            if ((sym.adr >= this.firstadr || sym.owner.kind != Kinds.Kind.TYP) && this.trackable(sym) && !this.inits.isMember(sym.adr) && (sym.flags_field & 0x40000000000L) == 0L) {
                Flow.this.log.error(pos, errkey);
                this.inits.incl(sym.adr);
            }
        }

        private void resetBits(Bits ... bits) {
            for (Bits b : bits) {
                b.reset();
            }
        }

        void split(boolean setToNull) {
            this.initsWhenFalse.assign(this.inits);
            this.uninitsWhenFalse.assign(this.uninits);
            this.initsWhenTrue.assign(this.inits);
            this.uninitsWhenTrue.assign(this.uninits);
            if (setToNull) {
                this.resetBits(this.inits, this.uninits);
            }
        }

        protected void merge() {
            this.inits.assign(this.initsWhenFalse.andSet(this.initsWhenTrue));
            this.uninits.assign(this.uninitsWhenFalse.andSet(this.uninitsWhenTrue));
        }

        void scanExpr(JCTree tree) {
            if (tree != null) {
                this.scan(tree);
                if (this.inits.isReset()) {
                    this.merge();
                }
            }
        }

        void scanExprs(List<? extends JCTree.JCExpression> trees) {
            if (trees != null) {
                List<JCTree.JCExpression> l = trees;
                while (l.nonEmpty()) {
                    this.scanExpr((JCTree)l.head);
                    l = l.tail;
                }
            }
        }

        void scanPattern(JCTree tree) {
            this.scan(tree);
        }

        void scanCond(JCTree tree) {
            if (tree.type.isFalse()) {
                if (this.inits.isReset()) {
                    this.merge();
                }
                this.initsWhenTrue.assign(this.inits);
                this.initsWhenTrue.inclRange(this.firstadr, this.nextadr);
                this.uninitsWhenTrue.assign(this.uninits);
                this.uninitsWhenTrue.inclRange(this.firstadr, this.nextadr);
                this.initsWhenFalse.assign(this.inits);
                this.uninitsWhenFalse.assign(this.uninits);
            } else if (tree.type.isTrue()) {
                if (this.inits.isReset()) {
                    this.merge();
                }
                this.initsWhenFalse.assign(this.inits);
                this.initsWhenFalse.inclRange(this.firstadr, this.nextadr);
                this.uninitsWhenFalse.assign(this.uninits);
                this.uninitsWhenFalse.inclRange(this.firstadr, this.nextadr);
                this.initsWhenTrue.assign(this.inits);
                this.uninitsWhenTrue.assign(this.uninits);
            } else {
                this.scan(tree);
                if (!this.inits.isReset()) {
                    this.split(tree.type != ((Flow)Flow.this).syms.unknownType);
                }
            }
            if (tree.type != ((Flow)Flow.this).syms.unknownType) {
                this.resetBits(this.inits, this.uninits);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            if (tree.sym == null) {
                return;
            }
            JCTree.JCClassDecl classDefPrev = this.classDef;
            int firstadrPrev = this.firstadr;
            int nextadrPrev = this.nextadr;
            ListBuffer pendingExitsPrev = this.pendingExits;
            this.pendingExits = new ListBuffer();
            if (tree.name != ((Flow)Flow.this).names.empty) {
                this.firstadr = this.nextadr;
            }
            this.classDef = tree;
            try {
                Symbol.VarSymbol sym;
                JCTree.JCVariableDecl def2;
                List<JCTree> l = tree.defs;
                while (l.nonEmpty()) {
                    if (((JCTree)l.head).hasTag(JCTree.Tag.VARDEF)) {
                        def2 = (JCTree.JCVariableDecl)l.head;
                        if ((def2.mods.flags & 8L) != 0L && this.trackable(sym = def2.sym)) {
                            this.newVar(def2);
                        }
                    }
                    l = l.tail;
                }
                this.forEachInitializer(tree, true, def -> {
                    this.scan((JCTree)def);
                    this.clearPendingExits(false);
                });
                for (int i = this.firstadr; i < this.nextadr; ++i) {
                    JCTree.JCVariableDecl vardecl = this.vardecls[i];
                    Symbol.VarSymbol var = vardecl.sym;
                    if (var.owner != this.classDef.sym || !var.isStatic()) continue;
                    this.checkInit(TreeInfo.diagnosticPositionFor((Symbol)var, vardecl), var);
                }
                l = tree.defs;
                while (l.nonEmpty()) {
                    if (((JCTree)l.head).hasTag(JCTree.Tag.VARDEF)) {
                        def2 = (JCTree.JCVariableDecl)l.head;
                        if ((def2.mods.flags & 8L) == 0L && this.trackable(sym = def2.sym)) {
                            this.newVar(def2);
                        }
                    }
                    l = l.tail;
                }
                l = tree.defs;
                while (l.nonEmpty()) {
                    if (((JCTree)l.head).hasTag(JCTree.Tag.METHODDEF)) {
                        this.scan((JCTree)l.head);
                    }
                    l = l.tail;
                }
                l = tree.defs;
                while (l.nonEmpty()) {
                    if (((JCTree)l.head).hasTag(JCTree.Tag.CLASSDEF)) {
                        this.scan((JCTree)l.head);
                    }
                    l = l.tail;
                }
            }
            finally {
                this.pendingExits = pendingExitsPrev;
                this.nextadr = nextadrPrev;
                this.firstadr = firstadrPrev;
                this.classDef = classDefPrev;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            if (tree.body == null) {
                return;
            }
            if ((tree.sym.flags() & 0x1000L) != 0L) {
                return;
            }
            Bits initsPrev = new Bits(this.inits);
            Bits uninitsPrev = new Bits(this.uninits);
            int nextadrPrev = this.nextadr;
            int firstadrPrev = this.firstadr;
            int returnadrPrev = this.returnadr;
            Assert.check(this.pendingExits.isEmpty());
            boolean isConstructorPrev = this.isConstructor;
            try {
                boolean isCompactOrGeneratedRecordConstructor;
                this.isConstructor = TreeInfo.isConstructor(tree);
                if (!this.isConstructor) {
                    this.firstadr = this.nextadr;
                }
                List<JCTree.JCVariableDecl> l = tree.params;
                while (l.nonEmpty()) {
                    JCTree.JCVariableDecl def = (JCTree.JCVariableDecl)l.head;
                    this.scan(def);
                    Assert.check((def.sym.flags() & 0x200000000L) != 0L, "Method parameter without PARAMETER flag");
                    this.initParam(def);
                    l = l.tail;
                }
                this.scan(tree.body);
                boolean bl = isCompactOrGeneratedRecordConstructor = (tree.sym.flags() & 0x8000000000000L) != 0L || (tree.sym.flags() & 0x2000001000000000L) == 0x2000001000000000L;
                if (this.isConstructor) {
                    boolean isSynthesized = (tree.sym.flags() & 0x1000000000L) != 0L;
                    for (int i = this.firstadr; i < this.nextadr; ++i) {
                        JCTree.JCVariableDecl vardecl = this.vardecls[i];
                        Symbol.VarSymbol var = vardecl.sym;
                        if (var.owner != this.classDef.sym || var.isStatic()) continue;
                        if (isSynthesized && !isCompactOrGeneratedRecordConstructor) {
                            this.checkInit(TreeInfo.diagnosticPositionFor((Symbol)var, vardecl), var, CompilerProperties.Errors.VarNotInitializedInDefaultConstructor(var));
                            continue;
                        }
                        if (isCompactOrGeneratedRecordConstructor) {
                            boolean isInstanceRecordField;
                            boolean bl2 = isInstanceRecordField = var.enclClass().isRecord() && (var.flags_field & 0x2000000001000012L) != 0L && var.owner.kind == Kinds.Kind.TYP;
                            if (isInstanceRecordField) {
                                boolean notInitialized;
                                boolean bl3 = notInitialized = !this.inits.isMember(var.adr);
                                if (notInitialized && this.uninits.isMember(var.adr) && tree.completesNormally) {
                                    var.flags_field |= 0x8000000000000L;
                                    continue;
                                }
                                this.checkInit(TreeInfo.diagEndPos(tree.body), var);
                                continue;
                            }
                            this.checkInit(TreeInfo.diagnosticPositionFor((Symbol)var, vardecl), var);
                            continue;
                        }
                        this.checkInit(TreeInfo.diagEndPos(tree.body), var);
                    }
                }
                this.clearPendingExits(true);
            }
            finally {
                this.inits.assign(initsPrev);
                this.uninits.assign(uninitsPrev);
                this.nextadr = nextadrPrev;
                this.firstadr = firstadrPrev;
                this.returnadr = returnadrPrev;
                this.isConstructor = isConstructorPrev;
            }
        }

        private void clearPendingExits(boolean inMethod) {
            List exits = this.pendingExits.toList();
            this.pendingExits = new ListBuffer();
            while (exits.nonEmpty()) {
                BaseAnalyzer.PendingExit exit = (BaseAnalyzer.PendingExit)exits.head;
                exits = exits.tail;
                Assert.check(inMethod && exit.tree.hasTag(JCTree.Tag.RETURN) || Flow.this.log.hasErrorOn(exit.tree.pos()), exit.tree);
                if (!inMethod || !this.isConstructor) continue;
                Assert.check(exit instanceof AssignPendingExit);
                this.inits.assign(((AssignPendingExit)exit).exit_inits);
                for (int i = this.firstadr; i < this.nextadr; ++i) {
                    this.checkInit(exit.tree.pos(), this.vardecls[i].sym);
                }
            }
        }

        protected void initParam(JCTree.JCVariableDecl def) {
            this.inits.incl(def.sym.adr);
            this.uninits.excl(def.sym.adr);
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            boolean track = this.trackable(tree.sym);
            if (track && (tree.sym.owner.kind == Kinds.Kind.MTH || tree.sym.owner.kind == Kinds.Kind.VAR)) {
                this.newVar(tree);
            }
            if (tree.init != null) {
                this.scanExpr(tree.init);
                if (track) {
                    this.letInit(tree.pos(), tree.sym);
                }
            }
        }

        @Override
        public void visitBlock(JCTree.JCBlock tree) {
            int nextadrPrev = this.nextadr;
            this.scan(tree.stats);
            this.nextadr = nextadrPrev;
        }

        @Override
        public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            FlowKind prevFlowKind = this.flowKind;
            this.flowKind = FlowKind.NORMAL;
            Bits initsSkip = new Bits(true);
            Bits uninitsSkip = new Bits(true);
            this.pendingExits = new ListBuffer();
            int prevErrors = ((Flow)Flow.this).log.nerrors;
            while (true) {
                Bits uninitsEntry = new Bits(this.uninits);
                uninitsEntry.excludeFrom(this.nextadr);
                this.scan(tree.body);
                this.resolveContinues(tree);
                this.scanCond(tree.cond);
                if (!this.flowKind.isFinal()) {
                    initsSkip.assign(this.initsWhenFalse);
                    uninitsSkip.assign(this.uninitsWhenFalse);
                }
                if (((Flow)Flow.this).log.nerrors != prevErrors || this.flowKind.isFinal() || new Bits(uninitsEntry).diffSet(this.uninitsWhenTrue).nextBit(this.firstadr) == -1) break;
                this.inits.assign(this.initsWhenTrue);
                this.uninits.assign(uninitsEntry.andSet(this.uninitsWhenTrue));
                this.flowKind = FlowKind.SPECULATIVE_LOOP;
            }
            this.flowKind = prevFlowKind;
            this.inits.assign(initsSkip);
            this.uninits.assign(uninitsSkip);
            this.resolveBreaks(tree, prevPendingExits);
        }

        @Override
        public void visitWhileLoop(JCTree.JCWhileLoop tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            FlowKind prevFlowKind = this.flowKind;
            this.flowKind = FlowKind.NORMAL;
            Bits initsSkip = new Bits(true);
            Bits uninitsSkip = new Bits(true);
            this.pendingExits = new ListBuffer();
            int prevErrors = ((Flow)Flow.this).log.nerrors;
            Bits uninitsEntry = new Bits(this.uninits);
            uninitsEntry.excludeFrom(this.nextadr);
            while (true) {
                this.scanCond(tree.cond);
                if (!this.flowKind.isFinal()) {
                    initsSkip.assign(this.initsWhenFalse);
                    uninitsSkip.assign(this.uninitsWhenFalse);
                }
                this.inits.assign(this.initsWhenTrue);
                this.uninits.assign(this.uninitsWhenTrue);
                this.scan(tree.body);
                this.resolveContinues(tree);
                if (((Flow)Flow.this).log.nerrors != prevErrors || this.flowKind.isFinal() || new Bits(uninitsEntry).diffSet(this.uninits).nextBit(this.firstadr) == -1) break;
                this.uninits.assign(uninitsEntry.andSet(this.uninits));
                this.flowKind = FlowKind.SPECULATIVE_LOOP;
            }
            this.flowKind = prevFlowKind;
            this.inits.assign(initsSkip);
            this.uninits.assign(uninitsSkip);
            this.resolveBreaks(tree, prevPendingExits);
        }

        @Override
        public void visitForLoop(JCTree.JCForLoop tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            FlowKind prevFlowKind = this.flowKind;
            this.flowKind = FlowKind.NORMAL;
            int nextadrPrev = this.nextadr;
            this.scan(tree.init);
            Bits initsSkip = new Bits(true);
            Bits uninitsSkip = new Bits(true);
            this.pendingExits = new ListBuffer();
            int prevErrors = ((Flow)Flow.this).log.nerrors;
            while (true) {
                Bits uninitsEntry = new Bits(this.uninits);
                uninitsEntry.excludeFrom(this.nextadr);
                if (tree.cond != null) {
                    this.scanCond(tree.cond);
                    if (!this.flowKind.isFinal()) {
                        initsSkip.assign(this.initsWhenFalse);
                        uninitsSkip.assign(this.uninitsWhenFalse);
                    }
                    this.inits.assign(this.initsWhenTrue);
                    this.uninits.assign(this.uninitsWhenTrue);
                } else if (!this.flowKind.isFinal()) {
                    initsSkip.assign(this.inits);
                    initsSkip.inclRange(this.firstadr, this.nextadr);
                    uninitsSkip.assign(this.uninits);
                    uninitsSkip.inclRange(this.firstadr, this.nextadr);
                }
                this.scan(tree.body);
                this.resolveContinues(tree);
                this.scan(tree.step);
                if (((Flow)Flow.this).log.nerrors != prevErrors || this.flowKind.isFinal() || new Bits(uninitsEntry).diffSet(this.uninits).nextBit(this.firstadr) == -1) break;
                this.uninits.assign(uninitsEntry.andSet(this.uninits));
                this.flowKind = FlowKind.SPECULATIVE_LOOP;
            }
            this.flowKind = prevFlowKind;
            this.inits.assign(initsSkip);
            this.uninits.assign(uninitsSkip);
            this.resolveBreaks(tree, prevPendingExits);
            this.nextadr = nextadrPrev;
        }

        @Override
        public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
            this.visitVarDef(tree.var);
            ListBuffer prevPendingExits = this.pendingExits;
            FlowKind prevFlowKind = this.flowKind;
            this.flowKind = FlowKind.NORMAL;
            int nextadrPrev = this.nextadr;
            this.scan(tree.expr);
            Bits initsStart = new Bits(this.inits);
            Bits uninitsStart = new Bits(this.uninits);
            this.letInit(tree.pos(), tree.var.sym);
            this.pendingExits = new ListBuffer();
            int prevErrors = ((Flow)Flow.this).log.nerrors;
            while (true) {
                Bits uninitsEntry = new Bits(this.uninits);
                uninitsEntry.excludeFrom(this.nextadr);
                this.scan(tree.body);
                this.resolveContinues(tree);
                if (((Flow)Flow.this).log.nerrors != prevErrors || this.flowKind.isFinal() || new Bits(uninitsEntry).diffSet(this.uninits).nextBit(this.firstadr) == -1) break;
                this.uninits.assign(uninitsEntry.andSet(this.uninits));
                this.flowKind = FlowKind.SPECULATIVE_LOOP;
            }
            this.flowKind = prevFlowKind;
            this.inits.assign(initsStart);
            this.uninits.assign(uninitsStart.andSet(this.uninits));
            this.resolveBreaks(tree, prevPendingExits);
            this.nextadr = nextadrPrev;
        }

        @Override
        public void visitLabelled(JCTree.JCLabeledStatement tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(tree.body);
            this.resolveBreaks(tree, prevPendingExits);
        }

        @Override
        public void visitSwitch(JCTree.JCSwitch tree) {
            this.handleSwitch(tree, tree.selector, tree.cases, tree.isExhaustive);
        }

        @Override
        public void visitSwitchExpression(JCTree.JCSwitchExpression tree) {
            this.handleSwitch(tree, tree.selector, tree.cases, tree.isExhaustive);
        }

        private void handleSwitch(JCTree tree, JCTree.JCExpression selector, List<JCTree.JCCase> cases, boolean isExhaustive) {
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            int nextadrPrev = this.nextadr;
            this.scanExpr(selector);
            Bits initsSwitch = new Bits(this.inits);
            Bits uninitsSwitch = new Bits(this.uninits);
            List<JCTree.JCCase> l = cases;
            while (l.nonEmpty()) {
                this.inits.assign(initsSwitch);
                this.uninits.assign(this.uninits.andSet(uninitsSwitch));
                JCTree.JCCase c = (JCTree.JCCase)l.head;
                for (JCTree.JCCaseLabel pat : c.labels) {
                    this.scanPattern(pat);
                }
                this.scan(c.guard);
                if (this.inits.isReset()) {
                    this.inits.assign(this.initsWhenTrue);
                    this.uninits.assign(this.uninitsWhenTrue);
                }
                this.scan(c.stats);
                if (c.completesNormally && c.caseKind == JCTree.JCCase.RULE) {
                    this.scanSyntheticBreak(Flow.this.make, tree);
                }
                this.addVars(c.stats, initsSwitch, uninitsSwitch);
                l = l.tail;
            }
            if (!isExhaustive) {
                if (tree.hasTag(JCTree.Tag.SWITCH_EXPRESSION)) {
                    this.markDead();
                } else if (tree.hasTag(JCTree.Tag.SWITCH) && !TreeInfo.expectedExhaustive((JCTree.JCSwitch)tree)) {
                    this.inits.assign(initsSwitch);
                    this.uninits.assign(this.uninits.andSet(uninitsSwitch));
                }
            }
            if (tree.hasTag(JCTree.Tag.SWITCH_EXPRESSION)) {
                this.resolveYields(tree, prevPendingExits);
            } else {
                this.resolveBreaks(tree, prevPendingExits);
            }
            this.nextadr = nextadrPrev;
        }

        private void addVars(List<JCTree.JCStatement> stats, Bits inits, Bits uninits) {
            while (stats.nonEmpty()) {
                JCTree stat = (JCTree)stats.head;
                if (stat.hasTag(JCTree.Tag.VARDEF)) {
                    int adr = ((JCTree.JCVariableDecl)stat).sym.adr;
                    inits.excl(adr);
                    uninits.incl(adr);
                }
                stats = stats.tail;
            }
        }

        @Override
        public void visitTry(JCTree.JCTry tree) {
            ListBuffer exits;
            ListBuffer<JCTree.JCVariableDecl> resourceVarDecls = new ListBuffer<JCTree.JCVariableDecl>();
            Bits uninitsTryPrev = new Bits(this.uninitsTry);
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            Bits initsTry = new Bits(this.inits);
            this.uninitsTry.assign(this.uninits);
            for (JCTree resource : tree.resources) {
                if (resource instanceof JCTree.JCVariableDecl) {
                    JCTree.JCVariableDecl variableDecl = (JCTree.JCVariableDecl)resource;
                    this.visitVarDef(variableDecl);
                    this.unrefdResources.enter(variableDecl.sym);
                    resourceVarDecls.append(variableDecl);
                    continue;
                }
                if (resource instanceof JCTree.JCExpression) {
                    JCTree.JCExpression expression = (JCTree.JCExpression)resource;
                    this.scanExpr(expression);
                    continue;
                }
                throw new AssertionError(tree);
            }
            this.scan(tree.body);
            this.uninitsTry.andSet(this.uninits);
            Bits initsEnd = new Bits(this.inits);
            Bits uninitsEnd = new Bits(this.uninits);
            int nextadrCatch = this.nextadr;
            if (!resourceVarDecls.isEmpty()) {
                for (JCTree.JCVariableDecl resVar : resourceVarDecls) {
                    if (!this.unrefdResources.includes(resVar.sym) || resVar.sym.isUnnamedVariable()) continue;
                    Flow.this.log.warning(resVar.pos(), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.TryResourceNotReferenced(resVar.sym));
                    this.unrefdResources.remove(resVar.sym);
                }
            }
            Bits initsCatchPrev = new Bits(initsTry);
            Bits uninitsCatchPrev = new Bits(this.uninitsTry);
            List<JCTree.JCCatch> l = tree.catchers;
            while (l.nonEmpty()) {
                JCTree.JCVariableDecl param = ((JCTree.JCCatch)l.head).param;
                this.inits.assign(initsCatchPrev);
                this.uninits.assign(uninitsCatchPrev);
                this.scan(param);
                this.initParam(param);
                this.scan(((JCTree.JCCatch)l.head).body);
                initsEnd.andSet(this.inits);
                uninitsEnd.andSet(this.uninits);
                this.nextadr = nextadrCatch;
                l = l.tail;
            }
            if (tree.finalizer != null) {
                this.inits.assign(initsTry);
                this.uninits.assign(this.uninitsTry);
                exits = this.pendingExits;
                this.pendingExits = prevPendingExits;
                this.scan(tree.finalizer);
                if (tree.finallyCanCompleteNormally) {
                    this.uninits.andSet(uninitsEnd);
                    while (exits.nonEmpty()) {
                        BaseAnalyzer.PendingExit exit = (BaseAnalyzer.PendingExit)exits.next();
                        if (exit instanceof AssignPendingExit) {
                            AssignPendingExit assignPendingExit = (AssignPendingExit)exit;
                            assignPendingExit.exit_inits.orSet(this.inits);
                            assignPendingExit.exit_uninits.andSet(this.uninits);
                        }
                        this.pendingExits.append(exit);
                    }
                    this.inits.orSet(initsEnd);
                }
            } else {
                this.inits.assign(initsEnd);
                this.uninits.assign(uninitsEnd);
                exits = this.pendingExits;
                this.pendingExits = prevPendingExits;
                while (exits.nonEmpty()) {
                    this.pendingExits.append((BaseAnalyzer.PendingExit)exits.next());
                }
            }
            this.uninitsTry.andSet(uninitsTryPrev).andSet(this.uninits);
        }

        @Override
        public void visitConditional(JCTree.JCConditional tree) {
            this.scanCond(tree.cond);
            Bits initsBeforeElse = new Bits(this.initsWhenFalse);
            Bits uninitsBeforeElse = new Bits(this.uninitsWhenFalse);
            this.inits.assign(this.initsWhenTrue);
            this.uninits.assign(this.uninitsWhenTrue);
            if (tree.truepart.type.hasTag(TypeTag.BOOLEAN) && tree.falsepart.type.hasTag(TypeTag.BOOLEAN)) {
                this.scanCond(tree.truepart);
                Bits initsAfterThenWhenTrue = new Bits(this.initsWhenTrue);
                Bits initsAfterThenWhenFalse = new Bits(this.initsWhenFalse);
                Bits uninitsAfterThenWhenTrue = new Bits(this.uninitsWhenTrue);
                Bits uninitsAfterThenWhenFalse = new Bits(this.uninitsWhenFalse);
                this.inits.assign(initsBeforeElse);
                this.uninits.assign(uninitsBeforeElse);
                this.scanCond(tree.falsepart);
                this.initsWhenTrue.andSet(initsAfterThenWhenTrue);
                this.initsWhenFalse.andSet(initsAfterThenWhenFalse);
                this.uninitsWhenTrue.andSet(uninitsAfterThenWhenTrue);
                this.uninitsWhenFalse.andSet(uninitsAfterThenWhenFalse);
            } else {
                this.scanExpr(tree.truepart);
                Bits initsAfterThen = new Bits(this.inits);
                Bits uninitsAfterThen = new Bits(this.uninits);
                this.inits.assign(initsBeforeElse);
                this.uninits.assign(uninitsBeforeElse);
                this.scanExpr(tree.falsepart);
                this.inits.andSet(initsAfterThen);
                this.uninits.andSet(uninitsAfterThen);
            }
        }

        @Override
        public void visitIf(JCTree.JCIf tree) {
            this.scanCond(tree.cond);
            Bits initsBeforeElse = new Bits(this.initsWhenFalse);
            Bits uninitsBeforeElse = new Bits(this.uninitsWhenFalse);
            this.inits.assign(this.initsWhenTrue);
            this.uninits.assign(this.uninitsWhenTrue);
            this.scan(tree.thenpart);
            if (tree.elsepart != null) {
                Bits initsAfterThen = new Bits(this.inits);
                Bits uninitsAfterThen = new Bits(this.uninits);
                this.inits.assign(initsBeforeElse);
                this.uninits.assign(uninitsBeforeElse);
                this.scan(tree.elsepart);
                this.inits.andSet(initsAfterThen);
                this.uninits.andSet(uninitsAfterThen);
            } else {
                this.inits.andSet(initsBeforeElse);
                this.uninits.andSet(uninitsBeforeElse);
            }
        }

        @Override
        public void visitBreak(JCTree.JCBreak tree) {
            this.recordExit(new AssignPendingExit(tree, this.inits, this.uninits));
        }

        @Override
        public void visitYield(JCTree.JCYield tree) {
            JCTree.JCSwitchExpression expr = (JCTree.JCSwitchExpression)tree.target;
            if (expr != null && expr.type.hasTag(TypeTag.BOOLEAN)) {
                this.scanCond(tree.value);
                final Bits initsAfterBreakWhenTrue = new Bits(this.initsWhenTrue);
                final Bits initsAfterBreakWhenFalse = new Bits(this.initsWhenFalse);
                final Bits uninitsAfterBreakWhenTrue = new Bits(this.uninitsWhenTrue);
                final Bits uninitsAfterBreakWhenFalse = new Bits(this.uninitsWhenFalse);
                BaseAnalyzer.PendingExit exit = new BaseAnalyzer.PendingExit(this, tree){
                    final /* synthetic */ AssignAnalyzer this$1;
                    {
                        this.this$1 = this$1;
                        super(tree);
                    }

                    @Override
                    void resolveJump() {
                        if (!this.this$1.inits.isReset()) {
                            this.this$1.split(true);
                        }
                        this.this$1.initsWhenTrue.andSet(initsAfterBreakWhenTrue);
                        this.this$1.initsWhenFalse.andSet(initsAfterBreakWhenFalse);
                        this.this$1.uninitsWhenTrue.andSet(uninitsAfterBreakWhenTrue);
                        this.this$1.uninitsWhenFalse.andSet(uninitsAfterBreakWhenFalse);
                    }
                };
                this.merge();
                this.recordExit(exit);
                return;
            }
            this.scanExpr(tree.value);
            this.recordExit(new AssignPendingExit(tree, this.inits, this.uninits));
        }

        @Override
        public void visitContinue(JCTree.JCContinue tree) {
            this.recordExit(new AssignPendingExit(tree, this.inits, this.uninits));
        }

        @Override
        public void visitReturn(JCTree.JCReturn tree) {
            this.scanExpr(tree.expr);
            this.recordExit(new AssignPendingExit(tree, this.inits, this.uninits));
        }

        @Override
        public void visitThrow(JCTree.JCThrow tree) {
            this.scanExpr(tree.expr);
            this.markDead();
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation tree) {
            this.scanExpr(tree.meth);
            this.scanExprs(tree.args);
            if (this.isConstructor) {
                Name name = TreeInfo.name(tree.meth);
                if (name == ((Flow)Flow.this).names._super) {
                    this.forEachInitializer(this.classDef, false, def -> {
                        this.scan((JCTree)def);
                        this.clearPendingExits(false);
                    });
                } else if (name == ((Flow)Flow.this).names._this) {
                    for (int address = this.firstadr; address < this.nextadr; ++address) {
                        Symbol.VarSymbol sym = this.vardecls[address].sym;
                        if (!this.isFinalUninitializedField(sym) || sym.isStatic()) continue;
                        this.letInit(tree.pos(), sym);
                    }
                }
            }
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass tree) {
            this.scanExpr(tree.encl);
            this.scanExprs(tree.args);
            this.scan(tree.def);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda tree) {
            Bits prevUninits = new Bits(this.uninits);
            Bits prevUninitsTry = new Bits(this.uninitsTry);
            Bits prevInits = new Bits(this.inits);
            int returnadrPrev = this.returnadr;
            int nextadrPrev = this.nextadr;
            ListBuffer prevPending = this.pendingExits;
            try {
                this.uninits.excludeFrom(this.firstadr);
                this.returnadr = this.nextadr;
                this.pendingExits = new ListBuffer();
                List<JCTree.JCVariableDecl> l = tree.params;
                while (l.nonEmpty()) {
                    JCTree.JCVariableDecl def = (JCTree.JCVariableDecl)l.head;
                    this.scan(def);
                    this.inits.incl(def.sym.adr);
                    this.uninits.excl(def.sym.adr);
                    l = l.tail;
                }
                if (tree.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                    this.scanExpr(tree.body);
                } else {
                    this.scan(tree.body);
                }
            }
            finally {
                this.returnadr = returnadrPrev;
                this.uninits.assign(prevUninits);
                this.uninitsTry.assign(prevUninitsTry);
                this.inits.assign(prevInits);
                this.pendingExits = prevPending;
                this.nextadr = nextadrPrev;
            }
        }

        @Override
        public void visitNewArray(JCTree.JCNewArray tree) {
            this.scanExprs(tree.dims);
            this.scanExprs(tree.elems);
        }

        @Override
        public void visitAssert(JCTree.JCAssert tree) {
            Bits initsExit = new Bits(this.inits);
            Bits uninitsExit = new Bits(this.uninits);
            this.scanCond(tree.cond);
            uninitsExit.andSet(this.uninitsWhenTrue);
            if (tree.detail != null) {
                this.inits.assign(this.initsWhenFalse);
                this.uninits.assign(this.uninitsWhenFalse);
                this.scanExpr(tree.detail);
            }
            this.inits.assign(initsExit);
            this.uninits.assign(uninitsExit);
        }

        @Override
        public void visitAssign(JCTree.JCAssign tree) {
            if (!TreeInfo.isIdentOrThisDotIdent(tree.lhs)) {
                this.scanExpr(tree.lhs);
            }
            this.scanExpr(tree.rhs);
            this.letInit(tree.lhs);
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess tree) {
            super.visitSelect(tree);
            if (TreeInfo.isThisQualifier(tree.selected) && tree.sym.kind == Kinds.Kind.VAR) {
                this.checkInit(tree.pos(), (Symbol.VarSymbol)tree.sym);
            }
        }

        @Override
        public void visitAssignop(JCTree.JCAssignOp tree) {
            this.scanExpr(tree.lhs);
            this.scanExpr(tree.rhs);
            this.letInit(tree.lhs);
        }

        @Override
        public void visitUnary(JCTree.JCUnary tree) {
            switch (tree.getTag()) {
                case NOT: {
                    this.scanCond(tree.arg);
                    Bits t = new Bits(this.initsWhenFalse);
                    this.initsWhenFalse.assign(this.initsWhenTrue);
                    this.initsWhenTrue.assign(t);
                    t.assign(this.uninitsWhenFalse);
                    this.uninitsWhenFalse.assign(this.uninitsWhenTrue);
                    this.uninitsWhenTrue.assign(t);
                    break;
                }
                case PREINC: 
                case POSTINC: 
                case PREDEC: 
                case POSTDEC: {
                    this.scanExpr(tree.arg);
                    this.letInit(tree.arg);
                    break;
                }
                default: {
                    this.scanExpr(tree.arg);
                }
            }
        }

        @Override
        public void visitBinary(JCTree.JCBinary tree) {
            switch (tree.getTag()) {
                case AND: {
                    this.scanCond(tree.lhs);
                    Bits initsWhenFalseLeft = new Bits(this.initsWhenFalse);
                    Bits uninitsWhenFalseLeft = new Bits(this.uninitsWhenFalse);
                    this.inits.assign(this.initsWhenTrue);
                    this.uninits.assign(this.uninitsWhenTrue);
                    this.scanCond(tree.rhs);
                    this.initsWhenFalse.andSet(initsWhenFalseLeft);
                    this.uninitsWhenFalse.andSet(uninitsWhenFalseLeft);
                    break;
                }
                case OR: {
                    this.scanCond(tree.lhs);
                    Bits initsWhenTrueLeft = new Bits(this.initsWhenTrue);
                    Bits uninitsWhenTrueLeft = new Bits(this.uninitsWhenTrue);
                    this.inits.assign(this.initsWhenFalse);
                    this.uninits.assign(this.uninitsWhenFalse);
                    this.scanCond(tree.rhs);
                    this.initsWhenTrue.andSet(initsWhenTrueLeft);
                    this.uninitsWhenTrue.andSet(uninitsWhenTrueLeft);
                    break;
                }
                default: {
                    this.scanExpr(tree.lhs);
                    this.scanExpr(tree.rhs);
                }
            }
        }

        @Override
        public void visitIdent(JCTree.JCIdent tree) {
            if (tree.sym.kind == Kinds.Kind.VAR) {
                this.checkInit(tree.pos(), (Symbol.VarSymbol)tree.sym);
                this.referenced(tree.sym);
            }
        }

        @Override
        public void visitTypeTest(JCTree.JCInstanceOf tree) {
            this.scanExpr(tree.expr);
            this.scan(tree.pattern);
        }

        @Override
        public void visitBindingPattern(JCTree.JCBindingPattern tree) {
            this.scan(tree.var);
            this.initParam(tree.var);
        }

        void referenced(Symbol sym) {
            this.unrefdResources.remove(sym);
        }

        @Override
        public void visitAnnotatedType(JCTree.JCAnnotatedType tree) {
            tree.underlyingType.accept(this);
        }

        @Override
        public void visitModuleDef(JCTree.JCModuleDecl tree) {
        }

        public void analyzeTree(Env<?> env, TreeMaker make) {
            this.analyzeTree(env, env.tree, make);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void analyzeTree(Env<?> env, JCTree tree, TreeMaker make) {
            int i;
            try {
                this.startPos = tree.pos().getStartPosition();
                if (this.vardecls == null) {
                    this.vardecls = new JCTree.JCVariableDecl[32];
                } else {
                    for (i = 0; i < this.vardecls.length; ++i) {
                        this.vardecls[i] = null;
                    }
                }
                this.firstadr = 0;
                this.nextadr = 0;
                Flow.this.make = make;
                this.pendingExits = new ListBuffer();
                this.classDef = null;
                this.unrefdResources = Scope.WriteableScope.create(env.enclClass.sym);
                this.scan(tree);
                this.startPos = -1;
            }
            catch (Throwable throwable) {
                this.startPos = -1;
                this.resetBits(this.inits, this.uninits, this.uninitsTry, this.initsWhenTrue, this.initsWhenFalse, this.uninitsWhenTrue, this.uninitsWhenFalse);
                if (this.vardecls != null) {
                    for (int i2 = 0; i2 < this.vardecls.length; ++i2) {
                        this.vardecls[i2] = null;
                    }
                }
                this.firstadr = 0;
                this.nextadr = 0;
                Flow.this.make = null;
                this.pendingExits = null;
                this.classDef = null;
                this.unrefdResources = null;
                throw throwable;
            }
            this.resetBits(this.inits, this.uninits, this.uninitsTry, this.initsWhenTrue, this.initsWhenFalse, this.uninitsWhenTrue, this.uninitsWhenFalse);
            if (this.vardecls != null) {
                for (i = 0; i < this.vardecls.length; ++i) {
                    this.vardecls[i] = null;
                }
            }
            this.firstadr = 0;
            this.nextadr = 0;
            Flow.this.make = null;
            this.pendingExits = null;
            this.classDef = null;
            this.unrefdResources = null;
        }

        public class AssignPendingExit
        extends BaseAnalyzer.PendingExit {
            final Bits inits;
            final Bits uninits;
            final Bits exit_inits;
            final Bits exit_uninits;

            public AssignPendingExit(JCTree tree, Bits inits, Bits uninits) {
                super(tree);
                this.exit_inits = new Bits(true);
                this.exit_uninits = new Bits(true);
                this.inits = inits;
                this.uninits = uninits;
                this.exit_inits.assign(inits);
                this.exit_uninits.assign(uninits);
            }

            @Override
            public void resolveJump() {
                this.inits.andSet(this.exit_inits);
                this.uninits.andSet(this.exit_uninits);
            }
        }
    }

    class FlowAnalyzer
    extends BaseAnalyzer {
        HashMap<Symbol, List<Type>> preciseRethrowTypes;
        JCTree.JCClassDecl classDef;
        List<Type> thrown;
        List<Type> caught;

        FlowAnalyzer() {
        }

        @Override
        void markDead() {
        }

        void errorUncaught() {
            BaseAnalyzer.PendingExit exit = (BaseAnalyzer.PendingExit)this.pendingExits.next();
            while (exit != null) {
                if (exit instanceof ThrownPendingExit) {
                    ThrownPendingExit thrownExit = (ThrownPendingExit)exit;
                    if (this.classDef != null && this.classDef.pos == exit.tree.pos) {
                        Flow.this.log.error(exit.tree.pos(), CompilerProperties.Errors.UnreportedExceptionDefaultConstructor(thrownExit.thrown));
                    } else if (exit.tree.hasTag(JCTree.Tag.VARDEF) && ((JCTree.JCVariableDecl)exit.tree).sym.isResourceVariable()) {
                        Flow.this.log.error(exit.tree.pos(), CompilerProperties.Errors.UnreportedExceptionImplicitClose(thrownExit.thrown, ((JCTree.JCVariableDecl)exit.tree).sym.name));
                    } else {
                        Flow.this.log.error(exit.tree.pos(), CompilerProperties.Errors.UnreportedExceptionNeedToCatchOrThrow(thrownExit.thrown));
                    }
                } else {
                    Assert.check(Flow.this.log.hasErrorOn(exit.tree.pos()));
                }
                exit = (BaseAnalyzer.PendingExit)this.pendingExits.next();
            }
        }

        void markThrown(JCTree tree, Type exc) {
            if (!Flow.this.chk.isUnchecked(tree.pos(), exc)) {
                if (!Flow.this.chk.isHandled(exc, this.caught)) {
                    this.pendingExits.append(new ThrownPendingExit(tree, exc));
                }
                this.thrown = Flow.this.chk.incl(exc, this.thrown);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            if (tree.sym == null) {
                return;
            }
            JCTree.JCClassDecl classDefPrev = this.classDef;
            List<Type> thrownPrev = this.thrown;
            List<Type> caughtPrev = this.caught;
            ListBuffer pendingExitsPrev = this.pendingExits;
            boolean anonymousClass = tree.name == ((Flow)Flow.this).names.empty;
            this.pendingExits = new ListBuffer();
            if (!anonymousClass) {
                this.caught = List.nil();
            }
            this.classDef = tree;
            this.thrown = List.nil();
            try {
                List<JCTree> l = tree.defs;
                while (l.nonEmpty()) {
                    if (((JCTree)l.head).hasTag(JCTree.Tag.CLASSDEF)) {
                        this.scan((JCTree)l.head);
                    }
                    l = l.tail;
                }
                this.forEachInitializer(tree, true, def -> {
                    this.scan((JCTree)def);
                    this.errorUncaught();
                });
                if (anonymousClass) {
                    l = tree.defs;
                    while (l.nonEmpty()) {
                        if (TreeInfo.isConstructor((JCTree)l.head)) {
                            JCTree.JCMethodDecl mdef = (JCTree.JCMethodDecl)l.head;
                            this.scan(mdef);
                            mdef.thrown = Flow.this.make.Types(this.thrown);
                            mdef.sym.type = Flow.this.types.createMethodTypeWithThrown(mdef.sym.type, this.thrown);
                        }
                        l = l.tail;
                    }
                    thrownPrev = Flow.this.chk.union(this.thrown, thrownPrev);
                }
                l = tree.defs;
                while (l.nonEmpty()) {
                    if (!(anonymousClass && TreeInfo.isConstructor((JCTree)l.head) || !((JCTree)l.head).hasTag(JCTree.Tag.METHODDEF))) {
                        this.scan((JCTree)l.head);
                        this.errorUncaught();
                    }
                    l = l.tail;
                }
                this.thrown = thrownPrev;
            }
            finally {
                this.pendingExits = pendingExitsPrev;
                this.caught = caughtPrev;
                this.classDef = classDefPrev;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            if (tree.body == null) {
                return;
            }
            List<Type> caughtPrev = this.caught;
            List<Type> mthrown = tree.sym.type.getThrownTypes();
            Assert.check(this.pendingExits.isEmpty());
            try {
                List<JCTree.JCVariableDecl> l = tree.params;
                while (l.nonEmpty()) {
                    JCTree.JCVariableDecl def = (JCTree.JCVariableDecl)l.head;
                    this.scan(def);
                    l = l.tail;
                }
                if (TreeInfo.hasConstructorCall(tree, ((Flow)Flow.this).names._super)) {
                    this.caught = Flow.this.chk.union(this.caught, mthrown);
                } else if ((tree.sym.flags() & 0x100008L) != 0x100000L) {
                    this.caught = mthrown;
                }
                this.scan(tree.body);
                List exits = this.pendingExits.toList();
                this.pendingExits = new ListBuffer();
                while (exits.nonEmpty()) {
                    BaseAnalyzer.PendingExit exit = (BaseAnalyzer.PendingExit)exits.head;
                    exits = exits.tail;
                    if (!(exit instanceof ThrownPendingExit)) {
                        Assert.check(exit.tree.hasTag(JCTree.Tag.RETURN) || Flow.this.log.hasErrorOn(exit.tree.pos()));
                        continue;
                    }
                    this.pendingExits.append(exit);
                }
            }
            finally {
                this.caught = caughtPrev;
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            this.scan(tree.init);
        }

        @Override
        public void visitBlock(JCTree.JCBlock tree) {
            this.scan(tree.stats);
        }

        @Override
        public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(tree.body);
            this.resolveContinues(tree);
            this.scan(tree.cond);
            this.resolveBreaks(tree, prevPendingExits);
        }

        @Override
        public void visitWhileLoop(JCTree.JCWhileLoop tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(tree.cond);
            this.scan(tree.body);
            this.resolveContinues(tree);
            this.resolveBreaks(tree, prevPendingExits);
        }

        @Override
        public void visitForLoop(JCTree.JCForLoop tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            this.scan(tree.init);
            this.pendingExits = new ListBuffer();
            if (tree.cond != null) {
                this.scan(tree.cond);
            }
            this.scan(tree.body);
            this.resolveContinues(tree);
            this.scan(tree.step);
            this.resolveBreaks(tree, prevPendingExits);
        }

        @Override
        public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
            this.visitVarDef(tree.var);
            ListBuffer prevPendingExits = this.pendingExits;
            this.scan(tree.expr);
            this.pendingExits = new ListBuffer();
            this.scan(tree.body);
            this.resolveContinues(tree);
            this.resolveBreaks(tree, prevPendingExits);
        }

        @Override
        public void visitLabelled(JCTree.JCLabeledStatement tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(tree.body);
            this.resolveBreaks(tree, prevPendingExits);
        }

        @Override
        public void visitSwitch(JCTree.JCSwitch tree) {
            this.handleSwitch(tree, tree.selector, tree.cases);
        }

        @Override
        public void visitSwitchExpression(JCTree.JCSwitchExpression tree) {
            this.handleSwitch(tree, tree.selector, tree.cases);
        }

        private void handleSwitch(JCTree tree, JCTree.JCExpression selector, List<JCTree.JCCase> cases) {
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(selector);
            List<JCTree.JCCase> l = cases;
            while (l.nonEmpty()) {
                JCTree.JCCase c = (JCTree.JCCase)l.head;
                this.scan(c.labels);
                this.scan(c.stats);
                l = l.tail;
            }
            if (tree.hasTag(JCTree.Tag.SWITCH_EXPRESSION)) {
                this.resolveYields(tree, prevPendingExits);
            } else {
                this.resolveBreaks(tree, prevPendingExits);
            }
        }

        @Override
        public void visitTry(JCTree.JCTry tree) {
            List<Type> caughtPrev = this.caught;
            List<Type> thrownPrev = this.thrown;
            this.thrown = List.nil();
            List<JCTree.JCCatch> l = tree.catchers;
            while (l.nonEmpty()) {
                Iterator<JCTree> subClauses = TreeInfo.isMultiCatch((JCTree.JCCatch)l.head) ? ((JCTree.JCTypeUnion)((JCTree.JCCatch)l.head).param.vartype).alternatives : List.of(((JCTree.JCCatch)l.head).param.vartype);
                Iterator iterator = ((List)((Object)subClauses)).iterator();
                while (iterator.hasNext()) {
                    JCTree.JCExpression ct = (JCTree.JCExpression)iterator.next();
                    this.caught = Flow.this.chk.incl(ct.type, this.caught);
                }
                l = l.tail;
            }
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            for (JCTree resource : tree.resources) {
                if (resource instanceof JCTree.JCVariableDecl) {
                    JCTree.JCVariableDecl variableDecl = (JCTree.JCVariableDecl)resource;
                    this.visitVarDef(variableDecl);
                    continue;
                }
                if (resource instanceof JCTree.JCExpression) {
                    JCTree.JCExpression expression = (JCTree.JCExpression)resource;
                    this.scan(expression);
                    continue;
                }
                throw new AssertionError(tree);
            }
            for (JCTree resource : tree.resources) {
                List<Type> closeableSupertypes = resource.type.isCompound() ? Flow.this.types.interfaces(resource.type).prepend(Flow.this.types.supertype(resource.type)) : List.of(resource.type);
                for (Type sup : closeableSupertypes) {
                    if (Flow.this.types.asSuper(sup, ((Flow)Flow.this).syms.autoCloseableType.tsym) == null) continue;
                    Symbol closeMethod = Flow.this.rs.resolveQualifiedMethod(tree, Flow.this.attrEnv, Flow.this.types.skipTypeVars(sup, false), ((Flow)Flow.this).names.close, List.nil(), List.nil());
                    Type mt = Flow.this.types.memberType(resource.type, closeMethod);
                    if (closeMethod.kind != Kinds.Kind.MTH) continue;
                    for (Type t : mt.getThrownTypes()) {
                        this.markThrown(resource, t);
                    }
                }
            }
            this.scan(tree.body);
            List<Type> thrownInTry = Flow.this.chk.union(this.thrown, List.of(((Flow)Flow.this).syms.runtimeExceptionType, ((Flow)Flow.this).syms.errorType));
            this.thrown = thrownPrev;
            this.caught = caughtPrev;
            List<Type> caughtInTry = List.nil();
            List<JCTree.JCCatch> l2 = tree.catchers;
            while (l2.nonEmpty()) {
                JCTree.JCVariableDecl param = ((JCTree.JCCatch)l2.head).param;
                List<JCTree.JCExpression> subClauses = TreeInfo.isMultiCatch((JCTree.JCCatch)l2.head) ? ((JCTree.JCTypeUnion)((JCTree.JCCatch)l2.head).param.vartype).alternatives : List.of(((JCTree.JCCatch)l2.head).param.vartype);
                List<Type> ctypes = List.nil();
                List<Type> rethrownTypes = Flow.this.chk.diff(thrownInTry, caughtInTry);
                for (JCTree.JCExpression ct : subClauses) {
                    Type exc = ct.type;
                    if (exc == ((Flow)Flow.this).syms.unknownType) continue;
                    ctypes = ctypes.append(exc);
                    if (Flow.this.types.isSameType(exc, ((Flow)Flow.this).syms.objectType)) continue;
                    JCDiagnostic.DiagnosticPosition pos = subClauses.size() > 1 ? ct.pos() : ((JCTree.JCCatch)l2.head).pos();
                    this.checkCaughtType(pos, exc, thrownInTry, caughtInTry);
                    caughtInTry = Flow.this.chk.incl(exc, caughtInTry);
                }
                this.scan(param);
                this.preciseRethrowTypes.put(param.sym, Flow.this.chk.intersect(ctypes, rethrownTypes));
                this.scan(((JCTree.JCCatch)l2.head).body);
                this.preciseRethrowTypes.remove(param.sym);
                l2 = l2.tail;
            }
            if (tree.finalizer != null) {
                List<Type> savedThrown = this.thrown;
                this.thrown = List.nil();
                ListBuffer exits = this.pendingExits;
                this.pendingExits = prevPendingExits;
                this.scan(tree.finalizer);
                if (!tree.finallyCanCompleteNormally) {
                    this.thrown = Flow.this.chk.union(this.thrown, thrownPrev);
                } else {
                    this.thrown = Flow.this.chk.union(this.thrown, Flow.this.chk.diff(thrownInTry, caughtInTry));
                    this.thrown = Flow.this.chk.union(this.thrown, savedThrown);
                    while (exits.nonEmpty()) {
                        this.pendingExits.append((BaseAnalyzer.PendingExit)exits.next());
                    }
                }
            } else {
                this.thrown = Flow.this.chk.union(this.thrown, Flow.this.chk.diff(thrownInTry, caughtInTry));
                ListBuffer exits = this.pendingExits;
                this.pendingExits = prevPendingExits;
                while (exits.nonEmpty()) {
                    this.pendingExits.append((BaseAnalyzer.PendingExit)exits.next());
                }
            }
        }

        @Override
        public void visitIf(JCTree.JCIf tree) {
            this.scan(tree.cond);
            this.scan(tree.thenpart);
            if (tree.elsepart != null) {
                this.scan(tree.elsepart);
            }
        }

        void checkCaughtType(JCDiagnostic.DiagnosticPosition pos, Type exc, List<Type> thrownInTry, List<Type> caughtInTry) {
            if (Flow.this.chk.subset(exc, caughtInTry)) {
                Flow.this.log.error(pos, CompilerProperties.Errors.ExceptAlreadyCaught(exc));
            } else if (!(Flow.this.chk.isUnchecked(pos, exc) || this.isExceptionOrThrowable(exc) || Flow.this.chk.intersects(exc, thrownInTry))) {
                Flow.this.log.error(pos, CompilerProperties.Errors.ExceptNeverThrownInTry(exc));
            } else {
                List<Type> catchableThrownTypes = Flow.this.chk.intersect(List.of(exc), thrownInTry);
                if (Flow.this.chk.diff(catchableThrownTypes, caughtInTry).isEmpty() && !this.isExceptionOrThrowable(exc)) {
                    JCDiagnostic.Warning key = catchableThrownTypes.length() == 1 ? CompilerProperties.Warnings.UnreachableCatch(catchableThrownTypes) : CompilerProperties.Warnings.UnreachableCatch1(catchableThrownTypes);
                    Flow.this.log.warning(pos, key);
                }
            }
        }

        private boolean isExceptionOrThrowable(Type exc) {
            return exc.tsym == ((Flow)Flow.this).syms.throwableType.tsym || exc.tsym == ((Flow)Flow.this).syms.exceptionType.tsym;
        }

        @Override
        public void visitBreak(JCTree.JCBreak tree) {
            this.recordExit(new BaseAnalyzer.PendingExit(tree));
        }

        @Override
        public void visitYield(JCTree.JCYield tree) {
            this.scan(tree.value);
            this.recordExit(new BaseAnalyzer.PendingExit(tree));
        }

        @Override
        public void visitContinue(JCTree.JCContinue tree) {
            this.recordExit(new BaseAnalyzer.PendingExit(tree));
        }

        @Override
        public void visitReturn(JCTree.JCReturn tree) {
            this.scan(tree.expr);
            this.recordExit(new BaseAnalyzer.PendingExit(tree));
        }

        @Override
        public void visitThrow(JCTree.JCThrow tree) {
            this.scan(tree.expr);
            Symbol sym = TreeInfo.symbol(tree.expr);
            if (sym != null && sym.kind == Kinds.Kind.VAR && (sym.flags() & 0x20000000010L) != 0L && this.preciseRethrowTypes.get(sym) != null) {
                for (Type t : this.preciseRethrowTypes.get(sym)) {
                    this.markThrown(tree, t);
                }
            } else {
                this.markThrown(tree, tree.expr.type);
            }
            this.markDead();
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation tree) {
            this.scan(tree.meth);
            this.scan(tree.args);
            List<Type> l = tree.meth.type.getThrownTypes();
            while (l.nonEmpty()) {
                this.markThrown(tree, (Type)l.head);
                l = l.tail;
            }
            if (TreeInfo.name(tree.meth) == ((Flow)Flow.this).names._super) {
                this.forEachInitializer(this.classDef, false, def -> {
                    this.scan((JCTree)def);
                    this.errorUncaught();
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitNewClass(JCTree.JCNewClass tree) {
            this.scan(tree.encl);
            this.scan(tree.args);
            List<Type> l = tree.constructorType.getThrownTypes();
            while (l.nonEmpty()) {
                this.markThrown(tree, (Type)l.head);
                l = l.tail;
            }
            List<Type> caughtPrev = this.caught;
            try {
                if (tree.def != null) {
                    List<Type> l2 = tree.constructor.type.getThrownTypes();
                    while (l2.nonEmpty()) {
                        this.caught = Flow.this.chk.incl((Type)l2.head, this.caught);
                        l2 = l2.tail;
                    }
                }
                this.scan(tree.def);
            }
            finally {
                this.caught = caughtPrev;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda tree) {
            if (tree.type != null && tree.type.isErroneous()) {
                return;
            }
            List<Type> prevCaught = this.caught;
            List<Type> prevThrown = this.thrown;
            ListBuffer prevPending = this.pendingExits;
            try {
                this.pendingExits = new ListBuffer();
                this.caught = tree.getDescriptorType(Flow.this.types).getThrownTypes();
                this.thrown = List.nil();
                this.scan(tree.body);
                List exits = this.pendingExits.toList();
                this.pendingExits = new ListBuffer();
                while (exits.nonEmpty()) {
                    BaseAnalyzer.PendingExit exit = (BaseAnalyzer.PendingExit)exits.head;
                    exits = exits.tail;
                    if (!(exit instanceof ThrownPendingExit)) {
                        Assert.check(exit.tree.hasTag(JCTree.Tag.RETURN) || Flow.this.log.hasErrorOn(exit.tree.pos()));
                        continue;
                    }
                    this.pendingExits.append(exit);
                }
                this.errorUncaught();
            }
            finally {
                this.pendingExits = prevPending;
                this.caught = prevCaught;
                this.thrown = prevThrown;
            }
        }

        @Override
        public void visitModuleDef(JCTree.JCModuleDecl tree) {
        }

        public void analyzeTree(Env<AttrContext> env, TreeMaker make) {
            this.analyzeTree(env, env.tree, make);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void analyzeTree(Env<AttrContext> env, JCTree tree, TreeMaker make) {
            try {
                Flow.this.attrEnv = env;
                Flow.this.make = make;
                this.pendingExits = new ListBuffer();
                this.preciseRethrowTypes = new HashMap();
                this.caught = null;
                this.thrown = null;
                this.classDef = null;
                this.scan(tree);
            }
            finally {
                this.pendingExits = null;
                Flow.this.make = null;
                this.caught = null;
                this.thrown = null;
                this.classDef = null;
            }
        }

        class ThrownPendingExit
        extends BaseAnalyzer.PendingExit {
            Type thrown;

            ThrownPendingExit(JCTree tree, Type thrown) {
                super(tree);
                this.thrown = thrown;
            }
        }
    }

    class CaptureAnalyzer
    extends BaseAnalyzer {
        JCTree currentTree;
        Scope.WriteableScope declaredInsideGuard;

        CaptureAnalyzer() {
        }

        @Override
        void markDead() {
        }

        void checkEffectivelyFinal(JCDiagnostic.DiagnosticPosition pos, Symbol.VarSymbol sym) {
            if (this.currentTree != null && sym.owner.kind == Kinds.Kind.MTH && sym.pos < this.getCurrentTreeStartPosition()) {
                switch (this.currentTree.getTag()) {
                    case CLASSDEF: 
                    case CASE: 
                    case LAMBDA: {
                        if ((sym.flags() & 0x20000000010L) != 0L) break;
                        this.reportEffectivelyFinalError(pos, sym);
                    }
                }
            }
        }

        int getCurrentTreeStartPosition() {
            int n;
            JCTree jCTree = this.currentTree;
            if (jCTree instanceof JCTree.JCCase) {
                JCTree.JCCase cse = (JCTree.JCCase)jCTree;
                n = cse.guard.getStartPosition();
            } else {
                n = this.currentTree.getStartPosition();
            }
            return n;
        }

        void letInit(JCTree tree) {
            if ((tree = TreeInfo.skipParens(tree)).hasTag(JCTree.Tag.IDENT) || tree.hasTag(JCTree.Tag.SELECT)) {
                Symbol sym = TreeInfo.symbol(tree);
                if (this.currentTree != null) {
                    switch (this.currentTree.getTag()) {
                        case CLASSDEF: 
                        case LAMBDA: {
                            if (sym.kind != Kinds.Kind.VAR || sym.owner.kind != Kinds.Kind.MTH || ((Symbol.VarSymbol)sym).pos >= this.currentTree.getStartPosition()) break;
                            this.reportEffectivelyFinalError(tree, sym);
                            break;
                        }
                        case CASE: {
                            if (this.declaredInsideGuard.includes(sym)) break;
                            Flow.this.log.error(tree.pos(), CompilerProperties.Errors.CannotAssignNotDeclaredGuard(sym));
                        }
                    }
                }
            }
        }

        void reportEffectivelyFinalError(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
            JCDiagnostic.Fragment fragment;
            switch (this.currentTree.getTag()) {
                case LAMBDA: {
                    fragment = CompilerProperties.Fragments.Lambda;
                    break;
                }
                case CASE: {
                    fragment = CompilerProperties.Fragments.Guard;
                    break;
                }
                case CLASSDEF: {
                    fragment = CompilerProperties.Fragments.InnerCls;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected tree kind: " + (Object)((Object)this.currentTree.getTag())));
                }
            }
            JCDiagnostic.Fragment subKey = fragment;
            Flow.this.log.error(pos, CompilerProperties.Errors.CantRefNonEffectivelyFinalVar(sym, Flow.this.diags.fragment(subKey)));
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            JCTree prevTree = this.currentTree;
            try {
                this.currentTree = tree.sym.isDirectlyOrIndirectlyLocal() ? tree : null;
                super.visitClassDef(tree);
            }
            finally {
                this.currentTree = prevTree;
            }
        }

        @Override
        public void visitLambda(JCTree.JCLambda tree) {
            JCTree prevTree = this.currentTree;
            try {
                this.currentTree = tree;
                super.visitLambda(tree);
            }
            finally {
                this.currentTree = prevTree;
            }
        }

        @Override
        public void visitBindingPattern(JCTree.JCBindingPattern tree) {
            this.scan(tree.var);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitCase(JCTree.JCCase tree) {
            this.scan(tree.labels);
            if (tree.guard != null) {
                JCTree prevTree = this.currentTree;
                Scope.WriteableScope prevDeclaredInsideGuard = this.declaredInsideGuard;
                try {
                    this.currentTree = tree;
                    this.declaredInsideGuard = Scope.WriteableScope.create(((Flow)Flow.this).attrEnv.enclClass.sym);
                    this.scan(tree.guard);
                }
                finally {
                    this.currentTree = prevTree;
                    this.declaredInsideGuard = prevDeclaredInsideGuard;
                }
            }
            this.scan(tree.stats);
        }

        @Override
        public void visitRecordPattern(JCTree.JCRecordPattern tree) {
            this.scan(tree.deconstructor);
            this.scan(tree.nested);
        }

        @Override
        public void visitIdent(JCTree.JCIdent tree) {
            if (tree.sym.kind == Kinds.Kind.VAR) {
                this.checkEffectivelyFinal(tree, (Symbol.VarSymbol)tree.sym);
            }
        }

        @Override
        public void visitAssign(JCTree.JCAssign tree) {
            JCTree.JCExpression lhs = TreeInfo.skipParens(tree.lhs);
            if (!(lhs instanceof JCTree.JCIdent)) {
                this.scan(lhs);
            }
            this.scan(tree.rhs);
            this.letInit(lhs);
        }

        @Override
        public void visitAssignop(JCTree.JCAssignOp tree) {
            this.scan(tree.lhs);
            this.scan(tree.rhs);
            this.letInit(tree.lhs);
        }

        @Override
        public void visitUnary(JCTree.JCUnary tree) {
            switch (tree.getTag()) {
                case PREINC: 
                case POSTINC: 
                case PREDEC: 
                case POSTDEC: {
                    this.scan(tree.arg);
                    this.letInit(tree.arg);
                    break;
                }
                default: {
                    this.scan(tree.arg);
                }
            }
        }

        @Override
        public void visitTry(JCTree.JCTry tree) {
            for (JCTree resource : tree.resources) {
                Symbol var;
                if (resource.hasTag(JCTree.Tag.VARDEF) || (var = TreeInfo.symbol(resource)) == null || (var.flags() & 0x20000000010L) != 0L) continue;
                Flow.this.log.error(resource.pos(), CompilerProperties.Errors.TryWithResourcesExprEffectivelyFinalVar(var));
            }
            super.visitTry(tree);
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            if (this.declaredInsideGuard != null) {
                this.declaredInsideGuard.enter(tree.sym);
            }
            super.visitVarDef(tree);
        }

        @Override
        public void visitYield(JCTree.JCYield tree) {
            this.scan(tree.value);
        }

        @Override
        public void visitModuleDef(JCTree.JCModuleDecl tree) {
        }

        public void analyzeTree(Env<AttrContext> env, TreeMaker make) {
            this.analyzeTree(env, env.tree, make);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void analyzeTree(Env<AttrContext> env, JCTree tree, TreeMaker make) {
            try {
                Flow.this.attrEnv = env;
                Flow.this.make = make;
                this.pendingExits = new ListBuffer();
                this.scan(tree);
            }
            finally {
                this.pendingExits = null;
                Flow.this.make = null;
            }
        }
    }

    class LambdaAliveAnalyzer
    extends AliveAnalyzer {
        boolean inLambda;

        LambdaAliveAnalyzer() {
        }

        @Override
        public void visitReturn(JCTree.JCReturn tree) {
            this.recordExit(new BaseAnalyzer.PendingExit(tree));
        }

        @Override
        public void visitLambda(JCTree.JCLambda tree) {
            if (this.inLambda || tree.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                return;
            }
            this.inLambda = true;
            try {
                super.visitLambda(tree);
            }
            finally {
                this.inLambda = false;
            }
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
        }
    }

    class LambdaAssignAnalyzer
    extends AssignAnalyzer {
        Scope.WriteableScope enclosedSymbols;
        boolean inLambda;

        LambdaAssignAnalyzer(Env<AttrContext> env) {
            this.enclosedSymbols = Scope.WriteableScope.create(env.enclClass.sym);
        }

        @Override
        public void visitLambda(JCTree.JCLambda tree) {
            if (this.inLambda) {
                return;
            }
            this.inLambda = true;
            try {
                super.visitLambda(tree);
            }
            finally {
                this.inLambda = false;
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            this.enclosedSymbols.enter(tree.sym);
            super.visitVarDef(tree);
        }

        @Override
        protected boolean trackable(Symbol.VarSymbol sym) {
            return this.enclosedSymbols.includes(sym) && sym.owner.kind == Kinds.Kind.MTH;
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
        }
    }

    class LambdaFlowAnalyzer
    extends FlowAnalyzer {
        List<Type> inferredThrownTypes;
        boolean inLambda;

        LambdaFlowAnalyzer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda tree) {
            if (tree.type != null && tree.type.isErroneous() || this.inLambda) {
                return;
            }
            List prevCaught = this.caught;
            List prevThrown = this.thrown;
            ListBuffer prevPending = this.pendingExits;
            this.inLambda = true;
            try {
                this.pendingExits = new ListBuffer();
                this.caught = List.of(((Flow)Flow.this).syms.throwableType);
                this.thrown = List.nil();
                this.scan(tree.body);
                this.inferredThrownTypes = this.thrown;
            }
            finally {
                this.pendingExits = prevPending;
                this.caught = prevCaught;
                this.thrown = prevThrown;
                this.inLambda = false;
            }
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
        }
    }

    class SnippetAliveAnalyzer
    extends AliveAnalyzer {
        SnippetAliveAnalyzer() {
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
        }

        @Override
        public void visitLambda(JCTree.JCLambda tree) {
        }

        public boolean isAlive() {
            return ((AliveAnalyzer)this).alive != Liveness.DEAD;
        }
    }

    class SnippetBreakToAnalyzer
    extends AliveAnalyzer {
        private final JCTree breakTo;
        private boolean breaksTo;

        public SnippetBreakToAnalyzer(JCTree breakTo) {
            this.breakTo = breakTo;
        }

        @Override
        public void visitBreak(JCTree.JCBreak tree) {
            this.breaksTo |= this.breakTo == tree.target && ((AliveAnalyzer)this).alive == Liveness.ALIVE;
        }

        public boolean breaksTo() {
            return this.breaksTo;
        }
    }

    static enum Liveness {
        ALIVE{

            @Override
            public Liveness or(Liveness other) {
                return this;
            }

            @Override
            public Liveness and(Liveness other) {
                return other;
            }
        }
        ,
        DEAD{

            @Override
            public Liveness or(Liveness other) {
                return other;
            }

            @Override
            public Liveness and(Liveness other) {
                return this;
            }
        }
        ,
        RECOVERY{

            @Override
            public Liveness or(Liveness other) {
                if (other == ALIVE) {
                    return ALIVE;
                }
                return this;
            }

            @Override
            public Liveness and(Liveness other) {
                if (other == DEAD) {
                    return DEAD;
                }
                return this;
            }
        };


        public abstract Liveness or(Liveness var1);

        public abstract Liveness and(Liveness var1);

        public Liveness or(boolean value) {
            return this.or(Liveness.from(value));
        }

        public Liveness and(boolean value) {
            return this.and(Liveness.from(value));
        }

        public static Liveness from(boolean value) {
            return value ? ALIVE : DEAD;
        }
    }

    static abstract class BaseAnalyzer
    extends TreeScanner {
        ListBuffer<PendingExit> pendingExits;
        JCTree.JCClassDecl initScanClass;

        BaseAnalyzer() {
        }

        abstract void markDead();

        void recordExit(PendingExit pe) {
            this.pendingExits.append(pe);
            this.markDead();
        }

        private Liveness resolveJump(JCTree tree, ListBuffer<PendingExit> oldPendingExits, JumpKind jk) {
            boolean resolved = false;
            List<PendingExit> exits = this.pendingExits.toList();
            this.pendingExits = oldPendingExits;
            while (exits.nonEmpty()) {
                PendingExit exit = (PendingExit)exits.head;
                if (exit.tree.hasTag(jk.treeTag) && jk.getTarget(exit.tree) == tree) {
                    exit.resolveJump();
                    resolved = true;
                } else {
                    this.pendingExits.append(exit);
                }
                exits = exits.tail;
            }
            return Liveness.from(resolved);
        }

        Liveness resolveContinues(JCTree tree) {
            return this.resolveJump(tree, new ListBuffer<PendingExit>(), JumpKind.CONTINUE);
        }

        Liveness resolveBreaks(JCTree tree, ListBuffer<PendingExit> oldPendingExits) {
            return this.resolveJump(tree, oldPendingExits, JumpKind.BREAK);
        }

        Liveness resolveYields(JCTree tree, ListBuffer<PendingExit> oldPendingExits) {
            return this.resolveJump(tree, oldPendingExits, JumpKind.YIELD);
        }

        @Override
        public void scan(JCTree tree) {
            if (tree != null && (tree.type == null || tree.type != Type.stuckType)) {
                super.scan(tree);
            }
        }

        @Override
        public void visitPackageDef(JCTree.JCPackageDecl tree) {
        }

        protected void scanSyntheticBreak(TreeMaker make, JCTree swtch) {
            if (swtch.hasTag(JCTree.Tag.SWITCH_EXPRESSION)) {
                JCTree.JCYield brk = make.at(-1).Yield(make.Erroneous().setType(swtch.type));
                brk.target = swtch;
                this.scan(brk);
            } else {
                JCTree.JCBreak brk = make.at(-1).Break(null);
                brk.target = swtch;
                this.scan(brk);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void forEachInitializer(JCTree.JCClassDecl classDef, boolean isStatic, Consumer<? super JCTree> handler) {
            if (classDef == this.initScanClass) {
                return;
            }
            JCTree.JCClassDecl initScanClassPrev = this.initScanClass;
            this.initScanClass = classDef;
            try {
                List<JCTree> defs = classDef.defs;
                while (defs.nonEmpty()) {
                    JCTree def = (JCTree)defs.head;
                    if (!def.hasTag(JCTree.Tag.CLASSDEF)) {
                        boolean isDefStatic;
                        boolean bl = isDefStatic = ((TreeInfo.flags(def) | (TreeInfo.symbolFor(def) == null ? 0L : TreeInfo.symbolFor((JCTree)def).flags_field)) & 8L) != 0L;
                        if (!def.hasTag(JCTree.Tag.METHODDEF) && isDefStatic == isStatic) {
                            handler.accept(def);
                        }
                    }
                    defs = defs.tail;
                }
            }
            finally {
                this.initScanClass = initScanClassPrev;
            }
        }

        static class PendingExit {
            JCTree tree;

            PendingExit(JCTree tree) {
                this.tree = tree;
            }

            void resolveJump() {
            }
        }

        static enum JumpKind {
            BREAK(JCTree.Tag.BREAK){

                @Override
                JCTree getTarget(JCTree tree) {
                    return ((JCTree.JCBreak)tree).target;
                }
            }
            ,
            CONTINUE(JCTree.Tag.CONTINUE){

                @Override
                JCTree getTarget(JCTree tree) {
                    return ((JCTree.JCContinue)tree).target;
                }
            }
            ,
            YIELD(JCTree.Tag.YIELD){

                @Override
                JCTree getTarget(JCTree tree) {
                    return ((JCTree.JCYield)tree).target;
                }
            };

            final JCTree.Tag treeTag;

            private JumpKind(JCTree.Tag treeTag) {
                this.treeTag = treeTag;
            }

            abstract JCTree getTarget(JCTree var1);
        }
    }

    static enum FlowKind {
        NORMAL("var.might.already.be.assigned", false),
        SPECULATIVE_LOOP("var.might.be.assigned.in.loop", true);

        final String errKey;
        final boolean isFinal;

        private FlowKind(String errKey, boolean isFinal) {
            this.errKey = errKey;
            this.isFinal = isFinal;
        }

        boolean isFinal() {
            return this.isFinal;
        }
    }
}

