/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.source.tree.MemberReferenceTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.CompileStates;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;

public class TransTypes
extends TreeTranslator {
    protected static final Context.Key<TransTypes> transTypesKey = new Context.Key();
    private Names names;
    private Log log;
    private Symtab syms;
    private TreeMaker make;
    private Enter enter;
    private Types types;
    private Annotate annotate;
    private Attr attr;
    private final Resolve resolve;
    private final CompileStates compileStates;
    private final Target target;
    private Type pt;
    Type returnType = null;
    private Env<AttrContext> env;
    private static final String statePreviousToFlowAssertMsg = "The current compile state [%s] of class %s is previous to WARN";

    public static TransTypes instance(Context context) {
        TransTypes instance = context.get(transTypesKey);
        if (instance == null) {
            instance = new TransTypes(context);
        }
        return instance;
    }

    protected TransTypes(Context context) {
        context.put(transTypesKey, this);
        this.compileStates = CompileStates.instance(context);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.enter = Enter.instance(context);
        this.types = Types.instance(context);
        this.make = TreeMaker.instance(context);
        this.resolve = Resolve.instance(context);
        this.annotate = Annotate.instance(context);
        this.attr = Attr.instance(context);
        this.target = Target.instance(context);
    }

    JCTree.JCExpression cast(JCTree.JCExpression tree, Type target) {
        int oldpos = this.make.pos;
        this.make.at(tree.pos);
        if (!this.types.isSameType(tree.type, target)) {
            if (!this.resolve.isAccessible(this.env, target.tsym)) {
                this.resolve.logAccessErrorInternal(this.env, tree, target);
            }
            tree = this.make.TypeCast(this.make.Type(target), tree).setType(target);
        }
        this.make.pos = oldpos;
        return tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCTree.JCExpression coerce(Env<AttrContext> env, JCTree.JCExpression tree, Type target) {
        Env<AttrContext> prevEnv = this.env;
        try {
            this.env = env;
            JCTree.JCExpression jCExpression = this.coerce(tree, target);
            return jCExpression;
        }
        finally {
            this.env = prevEnv;
        }
    }

    JCTree.JCExpression coerce(JCTree.JCExpression tree, Type target) {
        Type btarget = target.baseType();
        if (tree.type.isPrimitive() == target.isPrimitive()) {
            return this.types.isAssignable(tree.type, btarget, this.types.noWarnings) ? tree : this.cast(tree, btarget);
        }
        return tree;
    }

    JCTree.JCExpression retype(JCTree.JCExpression tree, Type erasedType, Type target) {
        if (!erasedType.isPrimitive()) {
            if (target != null && target.isPrimitive()) {
                target = this.erasure(tree.type);
            }
            tree.type = erasedType;
            if (target != null) {
                return this.coerce(tree, target);
            }
        }
        return tree;
    }

    <T extends JCTree> List<T> translateArgs(List<T> _args, List<Type> parameters, Type varargsElement) {
        if (parameters.isEmpty()) {
            return _args;
        }
        List<Object> args = _args;
        while (parameters.tail.nonEmpty()) {
            args.head = this.translate((JCTree)args.head, (Type)parameters.head);
            args = args.tail;
            parameters = parameters.tail;
        }
        Type parameter = (Type)parameters.head;
        Assert.check(varargsElement != null || args.length() == 1);
        if (varargsElement != null) {
            while (args.nonEmpty()) {
                args.head = this.translate((JCTree)args.head, varargsElement);
                args = args.tail;
            }
        } else {
            args.head = this.translate((JCTree)args.head, parameter);
        }
        return _args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends JCTree> List<T> translateArgs(List<T> _args, List<Type> parameters, Type varargsElement, Env<AttrContext> localEnv) {
        Env<AttrContext> prevEnv = this.env;
        try {
            this.env = localEnv;
            List<T> list = this.translateArgs(_args, parameters, varargsElement);
            return list;
        }
        finally {
            this.env = prevEnv;
        }
    }

    void addBridge(JCDiagnostic.DiagnosticPosition pos, Symbol.MethodSymbol meth, Symbol.MethodSymbol impl, Symbol.ClassSymbol origin, ListBuffer<JCTree> bridges) {
        this.make.at(pos);
        Type implTypeErasure = this.erasure(impl.type);
        Type bridgeType = meth.erasure(this.types);
        long flags = impl.flags() & 7L | 0x1000L | 0x80000000L | (origin.isInterface() ? 0x80000000000L : 0L);
        Symbol.MethodSymbol bridge = new Symbol.MethodSymbol(flags, meth.name, bridgeType, origin);
        bridge.params = this.createBridgeParams(impl, bridge, bridgeType);
        bridge.setAttributes(impl);
        JCTree.JCMethodDecl md = this.make.MethodDef(bridge, null);
        JCTree.JCExpression receiver = impl.owner == origin ? this.make.This(origin.erasure(this.types)) : this.make.Super(this.types.supertype((Type)origin.type).tsym.erasure(this.types), origin);
        Type calltype = implTypeErasure.getReturnType();
        JCTree.JCMethodInvocation call = this.make.Apply(null, this.make.Select(receiver, impl).setType(calltype), this.translateArgs(this.make.Idents(md.params), implTypeErasure.getParameterTypes(), null)).setType(calltype);
        JCTree.JCExpressionStatement stat = implTypeErasure.getReturnType().hasTag(TypeTag.VOID) ? this.make.Exec(call) : this.make.Return(this.coerce(call, bridgeType.getReturnType()));
        md.body = this.make.Block(0L, List.of(stat));
        bridges.append(md);
        origin.members().enter(bridge);
    }

    private List<Symbol.VarSymbol> createBridgeParams(Symbol.MethodSymbol impl, Symbol.MethodSymbol bridge, Type bridgeType) {
        List<Symbol.VarSymbol> bridgeParams = null;
        if (impl.params != null) {
            bridgeParams = List.nil();
            List<Symbol.VarSymbol> implParams = impl.params;
            Type.MethodType mType = (Type.MethodType)bridgeType;
            List<Type> argTypes = mType.argtypes;
            while (implParams.nonEmpty() && argTypes.nonEmpty()) {
                Symbol.VarSymbol param = new Symbol.VarSymbol(((Symbol.VarSymbol)implParams.head).flags() | 0x1000L | 0x200000000L, ((Symbol.VarSymbol)implParams.head).name, (Type)argTypes.head, bridge);
                param.setAttributes((Symbol)implParams.head);
                bridgeParams = bridgeParams.append(param);
                implParams = implParams.tail;
                argTypes = argTypes.tail;
            }
        }
        return bridgeParams;
    }

    void addBridgeIfNeeded(JCDiagnostic.DiagnosticPosition pos, Symbol sym, Symbol.ClassSymbol origin, ListBuffer<JCTree> bridges) {
        if (sym.kind == Kinds.Kind.MTH && sym.name != this.names.init && (sym.flags() & 0xAL) == 0L && (sym.flags() & 0x1000L) != 4096L && sym.isMemberOf(origin, this.types)) {
            Symbol.MethodSymbol meth = (Symbol.MethodSymbol)sym;
            Symbol.MethodSymbol bridge = meth.binaryImplementation(origin, this.types);
            Symbol.MethodSymbol impl = meth.implementation(origin, this.types, true);
            if (bridge == null || bridge == meth || impl != null && !bridge.owner.isSubClass(impl.owner, this.types)) {
                if (impl != null && bridge != impl && this.isBridgeNeeded(meth, impl, origin.type)) {
                    this.addBridge(pos, meth, impl, origin, bridges);
                } else if (impl == meth && impl.owner != origin && (impl.flags() & 0x10L) == 0L && (meth.flags() & 0x401L) == 1L && (origin.flags() & 1L) > (impl.owner.flags() & 1L)) {
                    this.addBridge(pos, meth, impl, origin, bridges);
                }
            }
        }
    }

    private boolean isBridgeNeeded(Symbol.MethodSymbol method, Symbol.MethodSymbol impl, Type dest) {
        if (impl != method) {
            Type method_erasure = method.erasure(this.types);
            if (!this.isSameMemberWhenErased(dest, method, method_erasure)) {
                return true;
            }
            Type impl_erasure = impl.erasure(this.types);
            if (!this.isSameMemberWhenErased(dest, impl, impl_erasure)) {
                return true;
            }
            return !this.types.isSameType(impl_erasure, method_erasure);
        }
        if ((method.flags() & 0x400L) != 0L) {
            return false;
        }
        return !this.isSameMemberWhenErased(dest, method, method.erasure(this.types));
    }

    private boolean isSameMemberWhenErased(Type type, Symbol.MethodSymbol method, Type erasure) {
        return this.types.isSameType(this.erasure(this.types.memberType(type, method)), erasure);
    }

    void addBridges(JCDiagnostic.DiagnosticPosition pos, Symbol.TypeSymbol i, Symbol.ClassSymbol origin, ListBuffer<JCTree> bridges) {
        for (Symbol sym : i.members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
            this.addBridgeIfNeeded(pos, sym, origin, bridges);
        }
        List<Type> l = this.types.interfaces(i.type);
        while (l.nonEmpty()) {
            this.addBridges(pos, ((Type)l.head).tsym, origin, bridges);
            l = l.tail;
        }
    }

    void addBridges(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol origin, ListBuffer<JCTree> bridges) {
        Type st = this.types.supertype(origin.type);
        while (st.hasTag(TypeTag.CLASS)) {
            this.addBridges(pos, st.tsym, origin, bridges);
            st = this.types.supertype(st);
        }
        List<Type> l = this.types.interfaces(origin.type);
        while (l.nonEmpty()) {
            this.addBridges(pos, ((Type)l.head).tsym, origin, bridges);
            l = l.tail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends JCTree> T translate(T tree, Type pt) {
        Type prevPt = this.pt;
        try {
            this.pt = pt;
            T t = this.translate(tree);
            return t;
        }
        finally {
            this.pt = prevPt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends JCTree> List<T> translate(List<T> trees, Type pt) {
        List<T> res;
        Type prevPt = this.pt;
        try {
            this.pt = pt;
            res = this.translate(trees);
        }
        finally {
            this.pt = prevPt;
        }
        return res;
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        this.translateClass(tree.sym);
        this.result = tree;
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        Type prevRetType = this.returnType;
        try {
            this.returnType = this.erasure(tree.type).getReturnType();
            tree.restype = this.translate(tree.restype, null);
            tree.typarams = List.nil();
            tree.params = this.translateVarDefs(tree.params);
            tree.recvparam = this.translate(tree.recvparam, null);
            tree.thrown = this.translate(tree.thrown, null);
            tree.body = this.translate(tree.body, tree.sym.erasure(this.types).getReturnType());
            tree.type = this.erasure(tree.type);
            this.result = tree;
        }
        finally {
            this.returnType = prevRetType;
        }
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        tree.vartype = this.translate(tree.vartype, null);
        tree.init = this.translate(tree.init, tree.sym.erasure(this.types));
        tree.type = this.erasure(tree.type);
        this.result = tree;
    }

    @Override
    public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
        tree.body = this.translate(tree.body);
        tree.cond = this.translate(tree.cond, (Type)this.syms.booleanType);
        this.result = tree;
    }

    @Override
    public void visitWhileLoop(JCTree.JCWhileLoop tree) {
        tree.cond = this.translate(tree.cond, (Type)this.syms.booleanType);
        tree.body = this.translate(tree.body);
        this.result = tree;
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop tree) {
        tree.init = this.translate(tree.init, null);
        if (tree.cond != null) {
            tree.cond = this.translate(tree.cond, (Type)this.syms.booleanType);
        }
        tree.step = this.translate(tree.step, null);
        tree.body = this.translate(tree.body);
        this.result = tree;
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
        tree.var = this.translate(tree.var, null);
        Type iterableType = tree.expr.type;
        tree.expr = this.translate(tree.expr, this.erasure(tree.expr.type));
        if (this.types.elemtype(tree.expr.type) == null) {
            tree.expr.type = iterableType;
        }
        tree.body = this.translate(tree.body);
        this.result = tree;
    }

    @Override
    public void visitLambda(JCTree.JCLambda tree) {
        Type prevRetType = this.returnType;
        try {
            this.returnType = this.erasure(tree.getDescriptorType(this.types)).getReturnType();
            tree.params = this.translate(tree.params);
            tree.body = this.translate(tree.body, tree.body.type == null || this.returnType.hasTag(TypeTag.VOID) ? null : this.returnType);
            tree.type = !tree.type.isIntersection() ? this.erasure(tree.type) : this.types.erasure(this.types.findDescriptorSymbol((Symbol.TypeSymbol)tree.type.tsym).owner.type);
            this.result = tree;
        }
        finally {
            this.returnType = prevRetType;
        }
    }

    @Override
    public void visitReference(JCTree.JCMemberReference tree) {
        if (this.needsConversionToLambda(tree)) {
            MemberReferenceToLambda conv = new MemberReferenceToLambda(tree);
            this.result = this.translate(conv.lambda());
        } else {
            Type t = this.types.skipTypeVars(tree.expr.type, false);
            Type receiverTarget = t.isCompound() ? this.erasure(tree.sym.owner.type) : this.erasure(t);
            tree.expr = tree.kind == JCTree.JCMemberReference.ReferenceKind.UNBOUND ? this.make.Type(receiverTarget) : this.translate(tree.expr, receiverTarget);
            tree.type = !tree.type.isIntersection() ? this.erasure(tree.type) : this.types.erasure(this.types.findDescriptorSymbol((Symbol.TypeSymbol)tree.type.tsym).owner.type);
            this.result = tree;
        }
    }

    boolean needsVarArgsConversion(JCTree.JCMemberReference tree) {
        return tree.varargsElement != null;
    }

    boolean isArrayOp(JCTree.JCMemberReference tree) {
        return tree.sym.owner == this.syms.arrayClass;
    }

    boolean receiverAccessible(JCTree.JCMemberReference tree) {
        return tree.ownerAccessible;
    }

    boolean interfaceParameterIsIntersectionOrUnionType(JCTree.JCMemberReference tree) {
        List<Type> tl = tree.getDescriptorType(this.types).getParameterTypes();
        while (tl.nonEmpty()) {
            Type pt = (Type)tl.head;
            if (this.isIntersectionOrUnionType(pt)) {
                return true;
            }
            tl = tl.tail;
        }
        return false;
    }

    boolean isIntersectionOrUnionType(Type t) {
        boolean bl;
        switch (t.getKind()) {
            case INTERSECTION: 
            case UNION: {
                bl = true;
                break;
            }
            case TYPEVAR: {
                Type.TypeVar tv = (Type.TypeVar)t;
                bl = this.isIntersectionOrUnionType(tv.getUpperBound());
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private boolean isProtectedInSuperClassOfEnclosingClassInOtherPackage(Symbol targetReference, Symbol currentClass) {
        return (targetReference.flags() & 4L) != 0L && targetReference.packge() != currentClass.packge();
    }

    boolean isPrivateInOtherClass(JCTree.JCMemberReference tree) {
        return (tree.sym.flags() & 2L) != 0L && !this.types.isSameType(this.types.erasure((Type)tree.sym.enclClass().asType()), this.types.erasure((Type)this.env.enclClass.sym.asType()));
    }

    boolean needsConversionToLambda(JCTree.JCMemberReference tree) {
        return this.interfaceParameterIsIntersectionOrUnionType(tree) || tree.hasKind(JCTree.JCMemberReference.ReferenceKind.SUPER) || this.needsVarArgsConversion(tree) || this.isArrayOp(tree) || !this.target.runtimeUseNestAccess() && this.isPrivateInOtherClass(tree) || this.isProtectedInSuperClassOfEnclosingClassInOtherPackage(tree.sym, this.env.enclClass.sym) || !this.receiverAccessible(tree) || tree.getMode() == MemberReferenceTree.ReferenceMode.NEW && tree.kind != JCTree.JCMemberReference.ReferenceKind.ARRAY_CTOR && (tree.sym.owner.isDirectlyOrIndirectlyLocal() || tree.sym.owner.isInner());
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch tree) {
        tree.selector = this.translate(tree.selector, this.erasure(tree.selector.type));
        tree.cases = this.translateCases(tree.cases);
        this.result = tree;
    }

    @Override
    public void visitCase(JCTree.JCCase tree) {
        tree.labels = this.translate(tree.labels, null);
        tree.guard = this.translate(tree.guard, (Type)this.syms.booleanType);
        tree.stats = this.translate(tree.stats);
        this.result = tree;
    }

    @Override
    public void visitAnyPattern(JCTree.JCAnyPattern tree) {
        this.result = tree;
    }

    @Override
    public void visitBindingPattern(JCTree.JCBindingPattern tree) {
        tree.var = this.translate(tree.var, null);
        this.result = tree;
    }

    @Override
    public void visitConstantCaseLabel(JCTree.JCConstantCaseLabel tree) {
        tree.expr = this.translate(tree.expr, null);
        this.result = tree;
    }

    @Override
    public void visitPatternCaseLabel(JCTree.JCPatternCaseLabel tree) {
        tree.pat = this.translate(tree.pat, null);
        this.result = tree;
    }

    @Override
    public void visitSwitchExpression(JCTree.JCSwitchExpression tree) {
        tree.selector = this.translate(tree.selector, this.erasure(tree.selector.type));
        tree.cases = this.translate(tree.cases, this.erasure(tree.type));
        tree.type = this.erasure(tree.type);
        this.result = this.retype(tree, tree.type, this.pt);
    }

    @Override
    public void visitRecordPattern(JCTree.JCRecordPattern tree) {
        tree.fullComponentTypes = ((List)tree.record.getRecordComponents()).map(rc -> this.types.memberType(tree.type, (Symbol)rc));
        tree.deconstructor = this.translate(tree.deconstructor, null);
        tree.nested = this.translate(tree.nested, null);
        this.result = tree;
    }

    @Override
    public void visitSynchronized(JCTree.JCSynchronized tree) {
        tree.lock = this.translate(tree.lock, this.erasure(tree.lock.type));
        tree.body = this.translate(tree.body);
        this.result = tree;
    }

    @Override
    public void visitTry(JCTree.JCTry tree) {
        tree.resources = this.translate(tree.resources, this.syms.autoCloseableType);
        tree.body = this.translate(tree.body);
        tree.catchers = this.translateCatchers(tree.catchers);
        tree.finalizer = this.translate(tree.finalizer);
        this.result = tree;
    }

    @Override
    public void visitConditional(JCTree.JCConditional tree) {
        tree.cond = this.translate(tree.cond, (Type)this.syms.booleanType);
        tree.truepart = this.translate(tree.truepart, this.erasure(tree.type));
        tree.falsepart = this.translate(tree.falsepart, this.erasure(tree.type));
        tree.type = this.erasure(tree.type);
        this.result = this.retype(tree, tree.type, this.pt);
    }

    @Override
    public void visitIf(JCTree.JCIf tree) {
        tree.cond = this.translate(tree.cond, (Type)this.syms.booleanType);
        tree.thenpart = this.translate(tree.thenpart);
        tree.elsepart = this.translate(tree.elsepart);
        this.result = tree;
    }

    @Override
    public void visitExec(JCTree.JCExpressionStatement tree) {
        tree.expr = this.translate(tree.expr, null);
        this.result = tree;
    }

    @Override
    public void visitReturn(JCTree.JCReturn tree) {
        if (!this.returnType.hasTag(TypeTag.VOID)) {
            tree.expr = this.translate(tree.expr, this.returnType);
        }
        this.result = tree;
    }

    @Override
    public void visitBreak(JCTree.JCBreak tree) {
        this.result = tree;
    }

    @Override
    public void visitYield(JCTree.JCYield tree) {
        tree.value = this.translate(tree.value, this.erasure(tree.value.type));
        tree.value.type = this.erasure(tree.value.type);
        tree.value = this.retype(tree.value, tree.value.type, this.pt);
        this.result = tree;
    }

    @Override
    public void visitThrow(JCTree.JCThrow tree) {
        tree.expr = this.translate(tree.expr, this.erasure(tree.expr.type));
        this.result = tree;
    }

    @Override
    public void visitAssert(JCTree.JCAssert tree) {
        tree.cond = this.translate(tree.cond, (Type)this.syms.booleanType);
        if (tree.detail != null) {
            tree.detail = this.translate(tree.detail, this.erasure(tree.detail.type));
        }
        this.result = tree;
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        List<Type> argtypes;
        tree.meth = this.translate(tree.meth, null);
        Symbol meth = TreeInfo.symbol(tree.meth);
        Type mt = meth.erasure(this.types);
        boolean useInstantiatedPtArgs = !this.types.isSignaturePolymorphic((Symbol.MethodSymbol)meth.baseSymbol());
        List<Type> list = argtypes = useInstantiatedPtArgs ? tree.meth.type.getParameterTypes() : mt.getParameterTypes();
        if (meth.name == this.names.init && meth.owner == this.syms.enumSym) {
            argtypes = argtypes.tail.tail;
        }
        if (tree.varargsElement != null) {
            tree.varargsElement = this.types.erasure(tree.varargsElement);
        } else if (tree.args.length() != argtypes.length()) {
            Assert.error(String.format("Incorrect number of arguments; expected %d, found %d", tree.args.length(), argtypes.length()));
        }
        tree.args = this.translateArgs(tree.args, argtypes, tree.varargsElement);
        tree.type = this.types.erasure(tree.type);
        this.result = this.retype(tree, mt.getReturnType(), this.pt);
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        if (tree.encl != null) {
            if (tree.def == null) {
                tree.encl = this.translate(tree.encl, this.erasure(tree.encl.type));
            } else {
                tree.args = tree.args.prepend(this.attr.makeNullCheck(tree.encl));
                tree.encl = null;
            }
        }
        Type erasedConstructorType = tree.constructorType != null ? this.erasure(tree.constructorType) : null;
        List<Type> argtypes = erasedConstructorType != null ? erasedConstructorType.getParameterTypes() : tree.constructor.erasure(this.types).getParameterTypes();
        tree.clazz = this.translate(tree.clazz, null);
        if (tree.varargsElement != null) {
            tree.varargsElement = this.types.erasure(tree.varargsElement);
        }
        tree.args = this.translateArgs(tree.args, argtypes, tree.varargsElement);
        tree.def = this.translate(tree.def, null);
        if (erasedConstructorType != null) {
            tree.constructorType = erasedConstructorType;
        }
        tree.type = this.erasure(tree.type);
        this.result = tree;
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray tree) {
        tree.elemtype = this.translate(tree.elemtype, null);
        this.translate(tree.dims, (Type)this.syms.intType);
        if (tree.type != null) {
            tree.elems = this.translate(tree.elems, this.erasure(this.types.elemtype(tree.type)));
            tree.type = this.erasure(tree.type);
        } else {
            tree.elems = this.translate(tree.elems, null);
        }
        this.result = tree;
    }

    @Override
    public void visitParens(JCTree.JCParens tree) {
        tree.expr = this.translate(tree.expr, this.pt);
        tree.type = this.erasure(tree.expr.type);
        this.result = tree;
    }

    @Override
    public void visitAssign(JCTree.JCAssign tree) {
        tree.lhs = this.translate(tree.lhs, null);
        tree.rhs = this.translate(tree.rhs, this.erasure(tree.lhs.type));
        tree.type = this.erasure(tree.lhs.type);
        this.result = this.retype(tree, tree.type, this.pt);
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp tree) {
        tree.lhs = this.translate(tree.lhs, null);
        tree.rhs = this.translate(tree.rhs, (Type)tree.operator.type.getParameterTypes().tail.head);
        tree.type = this.erasure(tree.type);
        this.result = tree;
    }

    @Override
    public void visitUnary(JCTree.JCUnary tree) {
        tree.arg = this.translate(tree.arg, tree.getTag() == JCTree.Tag.NULLCHK ? tree.type : (Type)tree.operator.type.getParameterTypes().head);
        this.result = tree;
    }

    @Override
    public void visitBinary(JCTree.JCBinary tree) {
        tree.lhs = this.translate(tree.lhs, (Type)tree.operator.type.getParameterTypes().head);
        tree.rhs = this.translate(tree.rhs, (Type)tree.operator.type.getParameterTypes().tail.head);
        this.result = tree;
    }

    @Override
    public void visitAnnotatedType(JCTree.JCAnnotatedType tree) {
        List<Attribute.TypeCompound> mirrors = this.annotate.fromAnnotations(tree.annotations);
        tree.underlyingType = this.translate(tree.underlyingType);
        tree.type = tree.underlyingType.type.annotatedType(mirrors);
        this.result = tree;
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast tree) {
        tree.clazz = this.translate(tree.clazz, null);
        Type originalTarget = tree.type;
        tree.type = this.erasure(tree.type);
        JCTree.JCExpression newExpression = this.translate(tree.expr, tree.type);
        if (newExpression != tree.expr) {
            JCTree.JCTypeCast typeCast = newExpression.hasTag(JCTree.Tag.TYPECAST) ? (JCTree.JCTypeCast)newExpression : null;
            JCTree.JCExpression jCExpression = tree.expr = typeCast != null && this.types.isSameType(typeCast.type, tree.type) ? typeCast.expr : newExpression;
        }
        if (originalTarget.isIntersection()) {
            Type.IntersectionClassType ict = (Type.IntersectionClassType)originalTarget;
            for (Type c : ict.getExplicitComponents()) {
                Type ec = this.erasure(c);
                if (this.types.isSameType(ec, tree.type) || this.types.isSameType(ec, this.pt)) continue;
                tree.expr = this.coerce(tree.expr, ec);
            }
        }
        this.result = this.retype(tree, tree.type, this.pt);
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf tree) {
        tree.pattern = this.translate(tree.pattern, null);
        if (tree.pattern.type.isPrimitive()) {
            tree.erasedExprOriginalType = this.erasure(tree.expr.type);
            tree.expr = this.translate(tree.expr, null);
        } else {
            tree.expr = this.translate(tree.expr, null);
        }
        this.result = tree;
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess tree) {
        tree.indexed = this.translate(tree.indexed, this.erasure(tree.indexed.type));
        tree.index = this.translate(tree.index, (Type)this.syms.intType);
        this.result = this.retype(tree, this.types.elemtype(tree.indexed.type), this.pt);
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation tree) {
        this.result = tree;
    }

    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        Type et = tree.sym.erasure(this.types);
        if (tree.sym.kind == Kinds.Kind.TYP && tree.sym.type.hasTag(TypeTag.TYPEVAR)) {
            this.result = this.make.at(tree.pos).Type(et);
        } else if (tree.type.constValue() != null) {
            this.result = tree;
        } else if (tree.sym.kind == Kinds.Kind.VAR) {
            this.result = this.retype(tree, et, this.pt);
        } else {
            tree.type = this.erasure(tree.type);
            this.result = tree;
        }
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        Type t = this.types.skipTypeVars(tree.selected.type, false);
        tree.selected = t.isCompound() ? this.coerce(this.translate(tree.selected, this.erasure(tree.selected.type)), this.erasure(tree.sym.owner.type)) : this.translate(tree.selected, this.erasure(t));
        if (tree.type.constValue() != null) {
            this.result = tree;
        } else if (tree.sym.kind == Kinds.Kind.VAR) {
            this.result = this.retype(tree, tree.sym.erasure(this.types), this.pt);
        } else {
            tree.type = this.erasure(tree.type);
            this.result = tree;
        }
    }

    @Override
    public void visitTypeArray(JCTree.JCArrayTypeTree tree) {
        tree.elemtype = this.translate(tree.elemtype, null);
        tree.type = this.erasure(tree.type);
        this.result = tree;
    }

    @Override
    public void visitTypeApply(JCTree.JCTypeApply tree) {
        JCTree.JCExpression clazz = this.translate(tree.clazz, null);
        this.result = clazz;
    }

    @Override
    public void visitTypeIntersection(JCTree.JCTypeIntersection tree) {
        this.result = this.translate((JCTree.JCExpression)tree.bounds.head, null);
    }

    private Type erasure(Type t) {
        return this.types.erasure(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void translateClass(Symbol.ClassSymbol c) {
        boolean envHasCompState;
        Env<AttrContext> myEnv;
        Type st = this.types.supertype(c.type);
        if (st.hasTag(TypeTag.CLASS)) {
            this.translateClass((Symbol.ClassSymbol)st.tsym);
        }
        if ((myEnv = this.enter.getEnv(c)) == null || (c.flags_field & 0x4000000000000L) != 0L) {
            return;
        }
        c.flags_field |= 0x4000000000000L;
        boolean bl = envHasCompState = this.compileStates.get(myEnv) != null;
        if (!envHasCompState && c.outermostClass() == c) {
            Assert.error("No info for outermost class: " + myEnv.enclClass.sym);
        }
        if (envHasCompState && CompileStates.CompileState.WARN.isAfter((CompileStates.CompileState)((Object)this.compileStates.get(myEnv)))) {
            Assert.error(String.format(statePreviousToFlowAssertMsg, this.compileStates.get(myEnv), myEnv.enclClass.sym));
        }
        Env<AttrContext> oldEnv = this.env;
        try {
            this.env = myEnv;
            TreeMaker savedMake = this.make;
            Type savedPt = this.pt;
            this.make = this.make.forToplevel(this.env.toplevel);
            this.pt = null;
            try {
                JCTree.JCClassDecl tree = (JCTree.JCClassDecl)this.env.tree;
                tree.typarams = List.nil();
                super.visitClassDef(tree);
                this.make.at(tree.pos);
                ListBuffer<JCTree> bridges = new ListBuffer<JCTree>();
                this.addBridges(tree.pos(), c, bridges);
                tree.defs = bridges.toList().prependList(tree.defs);
                tree.type = this.erasure(tree.type);
            }
            finally {
                this.make = savedMake;
                this.pt = savedPt;
            }
        }
        finally {
            this.env = oldEnv;
        }
    }

    public JCTree translateTopLevelClass(JCTree cdef, TreeMaker make) {
        this.make = make;
        this.pt = null;
        return this.translate(cdef, null);
    }

    private class MemberReferenceToLambda {
        private final JCTree.JCMemberReference tree;
        private final ListBuffer<JCTree.JCExpression> args = new ListBuffer();
        private final ListBuffer<JCTree.JCVariableDecl> params = new ListBuffer();
        private final Symbol.MethodSymbol owner;
        private JCTree.JCExpression receiverExpression;

        MemberReferenceToLambda(JCTree.JCMemberReference tree) {
            this.owner = new Symbol.MethodSymbol(0L, ((TransTypes)TransTypes.this).names.empty, Type.noType, ((TransTypes)TransTypes.this).env.enclClass.sym);
            this.receiverExpression = null;
            this.tree = tree;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        JCTree.JCExpression lambda() {
            int prevPos = ((TransTypes)TransTypes.this).make.pos;
            try {
                TransTypes.this.make.at(this.tree);
                Symbol.VarSymbol rcvr = this.addParametersReturnReceiver();
                JCTree.JCExpression expr = this.tree.getMode() == MemberReferenceTree.ReferenceMode.INVOKE ? this.expressionInvoke(rcvr) : this.expressionNew();
                JCTree.JCLambda slam = TransTypes.this.make.Lambda(this.params.toList(), expr);
                slam.target = this.tree.target;
                slam.owner = this.tree.owner;
                slam.type = this.tree.type;
                slam.pos = this.tree.pos;
                slam.wasMethodReference = true;
                if (this.receiverExpression != null) {
                    JCTree.JCExpression jCExpression = TransTypes.this.make.at(this.tree.pos).LetExpr(TransTypes.this.make.VarDef(rcvr, this.receiverExpression), (JCTree.JCExpression)slam).setType(this.tree.type);
                    return jCExpression;
                }
                JCTree.JCLambda jCLambda = slam;
                return jCLambda;
            }
            finally {
                TransTypes.this.make.at(prevPos);
            }
        }

        Symbol.VarSymbol addParametersReturnReceiver() {
            int i;
            Symbol.VarSymbol rcvr;
            List<Type> descPTypes = this.tree.getDescriptorType(TransTypes.this.types).getParameterTypes();
            switch (this.tree.kind) {
                case BOUND: {
                    rcvr = new Symbol.VarSymbol(4096L, TransTypes.this.names.fromString("rec$"), this.tree.getQualifierExpression().type, this.owner);
                    rcvr.pos = this.tree.pos;
                    this.receiverExpression = TransTypes.this.attr.makeNullCheck(this.tree.getQualifierExpression());
                    break;
                }
                case UNBOUND: {
                    rcvr = this.addParameter("rec$", (Type)descPTypes.head, false);
                    descPTypes = descPTypes.tail;
                    break;
                }
                default: {
                    rcvr = null;
                }
            }
            List<Type> implPTypes = this.tree.sym.type.getParameterTypes();
            int implSize = implPTypes.size();
            int samSize = descPTypes.size();
            int last = TransTypes.this.needsVarArgsConversion(this.tree) ? implSize - 1 : implSize;
            for (i = 0; implPTypes.nonEmpty() && i < last; ++i) {
                Type parmType = (Type)descPTypes.head;
                this.addParameter("x$" + i, parmType, true);
                implPTypes = implPTypes.tail;
                descPTypes = descPTypes.tail;
            }
            for (i = last; i < samSize; ++i) {
                this.addParameter("xva$" + i, this.tree.varargsElement, true);
            }
            return rcvr;
        }

        private JCTree.JCExpression expressionInvoke(Symbol.VarSymbol rcvr) {
            JCTree.JCExpression qualifier = rcvr != null ? TransTypes.this.make.Ident(rcvr) : this.tree.getQualifierExpression();
            JCTree.JCFieldAccess select = TransTypes.this.make.Select(qualifier, this.tree.sym.name);
            select.sym = this.tree.sym;
            select.type = this.tree.referentType;
            JCTree.JCMethodInvocation apply = TransTypes.this.make.Apply(List.nil(), select, this.args.toList()).setType(this.tree.referentType.getReturnType());
            TreeInfo.setVarargsElement(apply, this.tree.varargsElement);
            return apply;
        }

        private JCTree.JCExpression expressionNew() {
            if (this.tree.kind == JCTree.JCMemberReference.ReferenceKind.ARRAY_CTOR) {
                JCTree.JCNewArray newArr = TransTypes.this.make.NewArray(TransTypes.this.make.Type(TransTypes.this.types.elemtype(this.tree.getQualifierExpression().type)), List.of(TransTypes.this.make.Ident(this.params.first())), null);
                newArr.type = this.tree.getQualifierExpression().type;
                return newArr;
            }
            JCTree.JCNewClass newClass = TransTypes.this.make.NewClass(null, List.nil(), TransTypes.this.make.Type(this.tree.getQualifierExpression().type), this.args.toList(), null);
            newClass.constructor = this.tree.sym;
            newClass.constructorType = this.tree.sym.erasure(TransTypes.this.types);
            newClass.type = this.tree.getQualifierExpression().type;
            TreeInfo.setVarargsElement(newClass, this.tree.varargsElement);
            return newClass;
        }

        private Symbol.VarSymbol addParameter(String name, Type p, boolean genArg) {
            Symbol.VarSymbol vsym = new Symbol.VarSymbol(0x200001000L, TransTypes.this.names.fromString(name), p, this.owner);
            vsym.pos = this.tree.pos;
            this.params.append(TransTypes.this.make.VarDef(vsym, null));
            if (genArg) {
                this.args.append(TransTypes.this.make.Ident(vsym));
            }
            return vsym;
        }
    }
}

