/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.ast;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.netbeans.modules.languages.hcl.ast.HCLExpression;
import org.netbeans.modules.languages.hcl.ast.HCLIdentifier;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface HCLForExpression
extends HCLExpression {
    public HCLIdentifier keyVar();

    public HCLIdentifier valueVar();

    public HCLExpression iterable();

    public HCLExpression condition();

    public record Object(HCLIdentifier keyVar, HCLIdentifier valueVar, HCLExpression iterable, HCLExpression condition, HCLExpression resultKey, HCLExpression resultValue, boolean grouping) implements HCLForExpression
    {
        @Override
        public String asString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{for ");
            if (this.keyVar != null) {
                sb.append(this.keyVar.asString()).append(',');
            }
            sb.append(HCLExpression.asString(this.valueVar)).append(" in ").append(HCLExpression.asString(this.iterable)).append(':');
            sb.append(HCLExpression.asString(this.resultKey)).append("=>").append(HCLExpression.asString(this.resultValue));
            if (this.grouping) {
                sb.append("...");
            }
            if (this.condition != null) {
                sb.append(" if ").append(this.condition.asString());
            }
            sb.append('}');
            return sb.toString();
        }

        @Override
        public List<? extends HCLExpression> elements() {
            return Stream.of(this.iterable, this.resultKey, this.resultValue, this.condition).filter(Objects::nonNull).toList();
        }
    }

    public record Tuple(HCLIdentifier keyVar, HCLIdentifier valueVar, HCLExpression iterable, HCLExpression condition, HCLExpression result) implements HCLForExpression
    {
        @Override
        public String asString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[for ");
            if (this.keyVar != null) {
                sb.append(this.keyVar.asString()).append(',');
            }
            sb.append(HCLExpression.asString(this.valueVar)).append(" in ").append(HCLExpression.asString(this.iterable)).append(':');
            sb.append(HCLExpression.asString(this.result));
            if (this.condition != null) {
                sb.append(" if ").append(this.condition.asString());
            }
            sb.append(']');
            return sb.toString();
        }

        @Override
        public List<? extends HCLExpression> elements() {
            return Stream.of(this.iterable, this.result, this.condition).filter(Objects::nonNull).toList();
        }
    }
}

